/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.core.events;

import com.google.common.collect.Sets;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgrade_aquatic")
public class LootEvents {
    private static final Set<ResourceLocation> TOOTH_RUINS_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{LootTables.field_204115_q});
    private static final Set<ResourceLocation> TOOTH_TREASURE_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{LootTables.field_204312_r});
    private static final Set<ResourceLocation> PICKERELWEED_LOOT_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{LootTables.field_204772_t});
    private static final Set<ResourceLocation> PICKERELWEED_FISHINGJUNK_LOOT_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{LootTables.field_186388_am});

    @SubscribeEvent
    public static void onInjectLoot(LootTableLoadEvent event) {
        LootPool pool;
        if (TOOTH_RUINS_INJECTIONS.contains(event.getName())) {
            pool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("upgrade_aquatic", "injections/tooth_ruins")).func_216086_a(1).func_216085_b(0)).name("tooth_ruins").func_216044_b();
            event.getTable().addPool(pool);
        }
        if (TOOTH_TREASURE_INJECTIONS.contains(event.getName())) {
            pool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("upgrade_aquatic", "injections/tooth_treasure")).func_216086_a(1).func_216085_b(0)).name("tooth_treasure").func_216044_b();
            event.getTable().addPool(pool);
        }
        if (PICKERELWEED_LOOT_INJECTIONS.contains(event.getName())) {
            pool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("upgrade_aquatic", "injections/pickerelweed_structures")).func_216086_a(1).func_216085_b(0)).name("pickerelweed_structure").func_216044_b();
            event.getTable().addPool(pool);
        }
        if (PICKERELWEED_FISHINGJUNK_LOOT_INJECTIONS.contains(event.getName())) {
            pool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("upgrade_aquatic", "injections/pickerelweed_fishjunk")).func_216086_a(1).func_216085_b(0)).name("pickerelweed_fishing").func_216044_b();
            event.getTable().addPool(pool);
        }
    }

    @SubscribeEvent
    public static void addDrops(LivingDropsEvent event) {
        Random rand = event.getEntityLiving().func_70681_au();
        if (event.getEntity().func_200600_R() == EntityType.field_200800_n) {
            int spineAmount = event.getLootingLevel() > 0 ? (rand.nextInt(3) + 1) * event.getLootingLevel() : rand.nextInt(2) + 1;
            ItemEntity eyeDrop = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), new ItemStack((IItemProvider)UABlocks.ELDER_EYE.get()));
            ItemEntity spineDrop = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), new ItemStack((IItemProvider)UABlocks.ELDER_GUARDIAN_SPINE.get(), spineAmount));
            event.getDrops().add(eyeDrop);
            event.getDrops().add(spineDrop);
        } else if (event.getEntity().func_200600_R() == EntityType.field_200761_A) {
            int spineAmount = rand.nextInt(2) + rand.nextInt(event.getLootingLevel() + 1);
            ItemEntity drop = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), new ItemStack((IItemProvider)UABlocks.GUARDIAN_SPINE.get(), spineAmount));
            event.getDrops().add(drop);
        }
    }
}

