/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.core.other;

import com.minecraftabnormals.abnormals_core.common.dispenser.FishBucketDispenseBehavior;
import com.minecraftabnormals.abnormals_core.core.api.IBucketableEntity;
import com.minecraftabnormals.abnormals_core.core.util.BlockUtil;
import com.minecraftabnormals.upgrade_aquatic.client.particle.UAParticles;
import com.minecraftabnormals.upgrade_aquatic.common.entities.pike.PikeEntity;
import com.minecraftabnormals.upgrade_aquatic.common.items.GlowingInkItem;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class UADispenseBehaviorRegistry {
    static IDispenseItemBehavior inkDispenseBehavior = new DefaultDispenseItemBehavior(){

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            GlowingInkItem.createEffectCloud(Effects.field_76440_q, (World)source.func_197524_h(), source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
            stack.func_190918_g(1);
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
            source.func_197524_h().func_184133_a(null, source.func_180699_d(), SoundEvents.field_203639_hT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }

        protected void func_82489_a(IBlockSource source, Direction facingIn) {
            GlowingInkItem.squirtInkServer((IParticleData)ParticleTypes.field_203219_V, source.func_180699_d().func_177972_a(facingIn));
        }
    };
    static IDispenseItemBehavior glowingInkDispenseBehavior = new DefaultDispenseItemBehavior(){

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            ServerWorld world = source.func_197524_h();
            BlockPos pos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
            BlockState state = source.func_197524_h().func_180495_p(pos);
            GlowingInkItem.createEffectCloud(Effects.field_76439_r, (World)world, pos);
            if (GlowingInkItem.DEAD_CORAL_CONVERSION_MAP.containsKey(state.func_177230_c())) {
                Block livingCoral = GlowingInkItem.DEAD_CORAL_CONVERSION_MAP.get(state.func_177230_c());
                world.func_175656_a(pos, BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)livingCoral.func_176223_P()));
                world.func_205220_G_().func_205360_a(pos, (Object)livingCoral, 60 + world.func_201674_k().nextInt(40));
            }
            stack.func_190918_g(1);
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
            source.func_197524_h().func_184133_a(null, source.func_180699_d(), SoundEvents.field_203639_hT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }

        protected void func_82489_a(IBlockSource source, Direction facingIn) {
            GlowingInkItem.squirtInkServer((IParticleData)UAParticles.GLOW_SQUID_INK.get(), source.func_180699_d().func_177972_a(facingIn));
        }
    };
    static IDispenseItemBehavior bucketFishItemBehavior = new DefaultDispenseItemBehavior(){

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            BlockPos blockPos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
            ServerWorld world = source.func_197524_h();
            List entities = world.func_217357_a(WaterMobEntity.class, new AxisAlignedBB(blockPos));
            if (!entities.isEmpty()) {
                for (WaterMobEntity mob : entities) {
                    if (mob instanceof AbstractFishEntity) {
                        ItemStack bucket = ((AbstractFishEntity)mob).func_203707_dx();
                        mob.func_70106_y();
                        world.func_184133_a(null, blockPos, SoundEvents.field_203814_aa, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        return bucket;
                    }
                    if (mob instanceof IBucketableEntity) {
                        if (mob instanceof PikeEntity) {
                            ItemStack bucket = ((IBucketableEntity)mob).getBucket();
                            CompoundNBT nbt = bucket.func_196082_o();
                            CompoundNBT compoundnbt1 = new CompoundNBT();
                            nbt.func_74768_a("BucketVariantTag", ((PikeEntity)mob).getPikeType().id);
                            if (!mob.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                                mob.func_184582_a(EquipmentSlotType.MAINHAND).func_77955_b(compoundnbt1);
                            }
                            nbt.func_218657_a("PikeHeldItem", (INBT)compoundnbt1);
                            nbt.func_74757_a("ShouldDropItem", ((PikeEntity)mob).shouldDropItem());
                            mob.func_70106_y();
                            world.func_184133_a(null, blockPos, SoundEvents.field_203814_aa, SoundCategory.BLOCKS, 0.5f, 1.0f);
                            return bucket;
                        }
                        ItemStack bucket = ((IBucketableEntity)mob).getBucket();
                        mob.func_70106_y();
                        world.func_184133_a(null, blockPos, SoundEvents.field_203814_aa, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        return bucket;
                    }
                    if (!(mob instanceof SquidEntity)) continue;
                    ItemStack bucket = new ItemStack((IItemProvider)UAItems.SQUID_BUCKET.get());
                    if (mob.func_145818_k_()) {
                        bucket.func_200302_a(mob.func_200201_e());
                    }
                    mob.func_70106_y();
                    world.func_184133_a(null, blockPos, SoundEvents.field_203814_aa, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    return bucket;
                }
            }
            return new FishBucketDispenseBehavior().dispense(source, stack);
        }
    };

    public static void registerDispenseBehaviors() {
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UAItems.NAUTILUS_BUCKET.get()), (IDispenseItemBehavior)new FishBucketDispenseBehavior());
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UAItems.PIKE_BUCKET.get()), (IDispenseItemBehavior)new FishBucketDispenseBehavior());
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UAItems.LIONFISH_BUCKET.get()), (IDispenseItemBehavior)new FishBucketDispenseBehavior());
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UAItems.SQUID_BUCKET.get()), (IDispenseItemBehavior)new FishBucketDispenseBehavior());
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UAItems.GLOW_SQUID_BUCKET.get()), (IDispenseItemBehavior)new FishBucketDispenseBehavior());
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151131_as, (IDispenseItemBehavior)bucketFishItemBehavior);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_196136_br, (IDispenseItemBehavior)inkDispenseBehavior);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UAItems.GLOWING_INK_SAC.get()), (IDispenseItemBehavior)glowingInkDispenseBehavior);
    }
}

