/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.core.registry;

import com.minecraftabnormals.upgrade_aquatic.common.blocks.EmbeddedAmmoniteBlock;
import com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature.BeachgrassDunesFeature;
import com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature.DriftwoodFeature;
import com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature.FloweringRushFeature;
import com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature.PickerelweedFeature;
import com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature.PrismarineCoralFeature;
import com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature.PrismarineCoralShelfFeature;
import com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature.PrismarineStalactiteFeature;
import com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature.RiverTreeFeature;
import com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature.SearocketFeature;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.CaveEdgeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="upgrade_aquatic")
public class UAFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"upgrade_aquatic");
    public static final RegistryObject<Feature<NoFeatureConfig>> PRISMARINE_CORAL_SHELF = FEATURES.register("prismarine_coral_shelf", () -> new PrismarineCoralShelfFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> PRISMARINE_CORAL_STALACTITE = FEATURES.register("prismarine_coral_stalactite", () -> new PrismarineStalactiteFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> PRISMARINE_CORAL = FEATURES.register("prismarine_coral", () -> new PrismarineCoralFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> PICKERELWEED = FEATURES.register("pickerelweed", () -> new PickerelweedFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> SEAROCKET = FEATURES.register("searocket", () -> new SearocketFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> FLOWERING_RUSH = FEATURES.register("flowering_rush", () -> new FloweringRushFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> DRIFTWOOD = FEATURES.register("driftwood", () -> new DriftwoodFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> DUNES = FEATURES.register("dunes", () -> new BeachgrassDunesFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> RIVER_TREE = FEATURES.register("river_tree", () -> new RiverTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_));

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        ResourceLocation biome = event.getName();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        generation.func_242513_a(GenerationStage.Decoration.RAW_GENERATION, Configured.PRISMARINE_CORAL);
        if (event.getCategory() == Biome.Category.OCEAN) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.DRIFTWOOD_OCEAN);
        }
        if (event.getCategory() == Biome.Category.BEACH) {
            generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.ORE_AMMONITE);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.DRIFTWOOD_BEACH);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.PATCH_SEAROCKET);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.BEACHGRASS_DUNES);
        }
        if (event.getCategory() == Biome.Category.RIVER) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.RIVER_TREE);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.DRIFTWOOD_RIVER);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.PATCH_FLOWERING_RUSH);
        }
        if (event.getCategory() == Biome.Category.SWAMP) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.DRIFTWOOD_SWAMP);
        }
        if (biome.equals((Object)Biomes.field_185444_T.func_240901_a_())) {
            generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.PATCH_PICKERELWEED_EXTRA);
        }
        if (event.getCategory() == Biome.Category.BEACH || event.getCategory() == Biome.Category.OCEAN || biome.equals((Object)Biomes.field_150576_N.func_240901_a_())) {
            generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.ORE_AMMONITE);
        }
        if (event.getCategory() != Biome.Category.OCEAN && event.getCategory() != Biome.Category.BEACH && event.getCategory() != Biome.Category.DESERT && event.getCategory() != Biome.Category.ICY) {
            generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Configured.PATCH_PICKERELWEED);
        }
        if (biome.toString().contains("rainforest_basin")) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.DRIFTWOOD_BASIN);
        }
    }

    public static final class Configured {
        public static final ConfiguredFeature<?, ?> ORE_AMMONITE = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, (BlockState)((Block)UABlocks.EMBEDDED_AMMONITE.get()).func_176223_P().func_206870_a((Property)EmbeddedAmmoniteBlock.field_176387_N, (Comparable)Direction.func_239631_a_((Random)new Random())), 3)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(20, 0, 73))).func_242728_a()).func_242731_b(30);
        public static final ConfiguredFeature<?, ?> BEACHGRASS_DUNES = (ConfiguredFeature)((Feature)DUNES.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(18);
        public static final ConfiguredFeature<?, ?> RIVER_TREE = ((Feature)RIVER_TREE.get()).func_225566_b_((IFeatureConfig)Configs.RIVER_TREE_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.8f, 2)));
        public static final ConfiguredFeature<?, ?> PRISMARINE_CORAL = ((Feature)PRISMARINE_CORAL.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215039_y.func_227446_a_((IPlacementConfig)new CaveEdgeConfig(GenerationStage.Carving.LIQUID, 0.0125f)));
        public static final ConfiguredFeature<?, ?> PATCH_SEAROCKET = (ConfiguredFeature)((Feature)SEAROCKET.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(15);
        public static final ConfiguredFeature<?, ?> PATCH_PICKERELWEED = (ConfiguredFeature)((Feature)PICKERELWEED.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(28);
        public static final ConfiguredFeature<?, ?> PATCH_PICKERELWEED_EXTRA = (ConfiguredFeature)((Feature)PICKERELWEED.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(90);
        public static final ConfiguredFeature<?, ?> PATCH_FLOWERING_RUSH = (ConfiguredFeature)((Feature)FLOWERING_RUSH.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(15);
        public static final ConfiguredFeature<?, ?> DRIFTWOOD_OCEAN = (ConfiguredFeature)((Feature)DRIFTWOOD.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(1);
        public static final ConfiguredFeature<?, ?> DRIFTWOOD_BEACH = (ConfiguredFeature)((Feature)DRIFTWOOD.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(14);
        public static final ConfiguredFeature<?, ?> DRIFTWOOD_RIVER = (ConfiguredFeature)((Feature)DRIFTWOOD.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(125);
        public static final ConfiguredFeature<?, ?> DRIFTWOOD_SWAMP = (ConfiguredFeature)((Feature)DRIFTWOOD.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(21);
        public static final ConfiguredFeature<?, ?> DRIFTWOOD_BASIN = (ConfiguredFeature)((Feature)DRIFTWOOD.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(85);

        public static void registerConfiguredFeatures() {
            Configured.register("ore_ammonite", ORE_AMMONITE);
            Configured.register("beachgrass_dunes", BEACHGRASS_DUNES);
            Configured.register("river_tree", RIVER_TREE);
            Configured.register("prismarine_coral", PRISMARINE_CORAL);
            Configured.register("patch_searocket", PATCH_SEAROCKET);
            Configured.register("patch_pickerelweed", PATCH_PICKERELWEED);
            Configured.register("patch_pickerelweed_extra", PATCH_PICKERELWEED_EXTRA);
            Configured.register("flowering_rush", PATCH_FLOWERING_RUSH);
            Configured.register("driftwood_ocean", DRIFTWOOD_OCEAN);
            Configured.register("driftwood_beach", DRIFTWOOD_BEACH);
            Configured.register("driftwood_river", DRIFTWOOD_RIVER);
            Configured.register("driftwood_swamp", DRIFTWOOD_SWAMP);
            Configured.register("driftwood_basin", DRIFTWOOD_BASIN);
        }

        private static <FC extends IFeatureConfig> void register(String name, ConfiguredFeature<FC, ?> configuredFeature) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("upgrade_aquatic", name), configuredFeature);
        }
    }

    public static final class Configs {
        public static final BaseTreeFeatureConfig RIVER_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)UABlocks.RIVER_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)UABlocks.RIVER_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new StraightTrunkPlacer(0, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_();
    }
}

