/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import com.google.common.collect.ImmutableList;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.IModCompat;
import de.teamlapen.lib.lib.util.LogUtil;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModCompatLoader
implements IInitListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String configName;
    @Nullable
    private List<IModCompat> availableModCompats = new LinkedList<IModCompat>();
    private List<IModCompat> loadedModCompats;

    public ModCompatLoader(String configName) {
        this.configName = configName;
    }

    public void addModCompat(IModCompat compat) {
        if (this.availableModCompats == null) {
            throw new IllegalStateException("Add mod compats BEFORE pre-init (" + compat.getModID() + ")");
        }
        this.availableModCompats.add(compat);
    }

    public List<IModCompat> getAvailableModCompats() {
        return this.availableModCompats;
    }

    public List<IModCompat> getLoadedModCompats() {
        return ImmutableList.copyOf(this.loadedModCompats);
    }

    @Override
    public void onInitStep(IInitListener.Step step, ParallelDispatchEvent event) {
        if (step == IInitListener.Step.COMMON_SETUP) {
            this.prepareModCompats(FMLPaths.CONFIGDIR.get().toFile());
        }
        Iterator<IModCompat> it = this.loadedModCompats.iterator();
        while (it.hasNext()) {
            IModCompat next = it.next();
            try {
                next.onInitStep(step, event);
            }
            catch (Exception e) {
                LOGGER.error(LogUtil.COMPAT, "---------------------------------------------------------");
                LOGGER.error(LogUtil.COMPAT, "Mod Compat {} threw an exception during {}. Unloading.", (Object)next.getModID(), (Object)step);
                LOGGER.error(LogUtil.COMPAT, "Issue", (Throwable)e);
                LOGGER.error(LogUtil.COMPAT, "---------------------------------------------------------");
                it.remove();
            }
        }
    }

    private boolean isModLoaded(IModCompat modCompat) {
        return ModList.get().isLoaded(modCompat.getModID());
    }

    private void prepareModCompats(File configDir) {
        if (this.availableModCompats == null) {
            LOGGER.warn("Trying to load mod compat twice");
            return;
        }
        LinkedList<IModCompat> loaded = new LinkedList<IModCompat>();
        for (IModCompat modCompat : this.availableModCompats) {
            if (!this.isModLoaded(modCompat)) continue;
            loaded.add(modCompat);
            LOGGER.trace(LogUtil.COMPAT, "Prepared {} compatibility", (Object)modCompat.getModID());
        }
        this.loadedModCompats = loaded;
        this.availableModCompats = null;
    }
}

