/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.proxy;

import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.network.UpdateEntityPacket;
import de.teamlapen.lib.proxy.CommonProxy;
import de.teamlapen.lib.util.ISoundReference;
import de.teamlapen.lib.util.SoundReference;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static final Logger LOGGER = LogManager.getLogger();

    private static void handleCapability(Entity e, ResourceLocation key, CompoundNBT data) {
        Capability cap = (Capability)HelperRegistry.getSyncableEntityCaps().get((Object)key);
        if (cap == null && e instanceof PlayerEntity) {
            cap = (Capability)HelperRegistry.getSyncablePlayerCaps().get((Object)key);
        }
        if (cap == null) {
            LOGGER.warn("Capability with key {} is not registered in the HelperRegistry", (Object)key);
        } else {
            LazyOptional opt = e.getCapability(cap, null);
            opt.ifPresent(inst -> {
                if (inst instanceof ISyncable) {
                    ((ISyncable)inst).loadUpdateFromNBT(data);
                } else {
                    LOGGER.warn("Target entity's capability {} ({})does not implement ISyncable", inst, (Object)key);
                }
            });
            if (!opt.isPresent()) {
                LOGGER.warn("Target entity {} does not have capability {}", (Object)e, (Object)cap);
            }
        }
    }

    @Override
    @Nonnull
    public ISoundReference createSoundReference(SoundEvent event, SoundCategory category, BlockPos pos, float volume, float pinch) {
        return new SoundReference((ISound)new SimpleSound(event, category, volume, pinch, pos));
    }

    @Override
    @Nonnull
    public ISoundReference createSoundReference(SoundEvent event, SoundCategory category, double x, double y, double z, float volume, float pinch) {
        return new SoundReference((ISound)new SimpleSound(event, category, volume, pinch, (double)((float)x), (double)((float)y), (double)((float)z)));
    }

    @Override
    public String getActiveLanguage() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().toString();
    }

    @Override
    public PlayerEntity getPlayerEntity(NetworkEvent.Context ctx) {
        return EffectiveSide.get() == LogicalSide.CLIENT ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public void handleUpdateEntityPacket(UpdateEntityPacket msg) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            LOGGER.error("Cannot handle update package because sending player entity is null. Message: {}", (Object)msg);
        } else {
            Entity e = player.func_130014_f_().func_73045_a(msg.getId());
            if (e == null) {
                LOGGER.error("Did not find entity {}", (Object)msg.getId());
                if (msg.isPlayerItself()) {
                    LOGGER.error("Message is meant for player itself, but id mismatch {} {}. Loading anyway.", (Object)player.func_145782_y(), (Object)msg.getId());
                    e = player;
                }
            }
            if (e != null) {
                if (msg.getData() != null) {
                    try {
                        ISyncable syncable = (ISyncable)e;
                        syncable.loadUpdateFromNBT(msg.getData());
                    }
                    catch (ClassCastException ex) {
                        LOGGER.warn("Target entity {} does not implement ISyncable ({})", (Object)e, (Object)ex);
                    }
                }
                if (msg.getCaps() != null) {
                    for (String key : msg.getCaps().func_150296_c()) {
                        ClientProxy.handleCapability(e, new ResourceLocation(key), msg.getCaps().func_74775_l(key));
                    }
                }
            }
        }
    }
}

