/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import com.mojang.brigadier.CommandDispatcher;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.config.BloodValueLoaderDynamic;
import de.teamlapen.lib.lib.network.AbstractPacketDispatcher;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.ModCompatLoader;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.client.core.ClientEventHandler;
import de.teamlapen.vampirism.config.BloodValues;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModCommands;
import de.teamlapen.vampirism.core.ModEventHandler;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.core.ModWorld;
import de.teamlapen.vampirism.core.RegistryManager;
import de.teamlapen.vampirism.data.AdvancementGenerator;
import de.teamlapen.vampirism.data.BlockStateGenerator;
import de.teamlapen.vampirism.data.ItemModelGenerator;
import de.teamlapen.vampirism.data.LootTablesGenerator;
import de.teamlapen.vampirism.data.RecipesGenerator;
import de.teamlapen.vampirism.data.SkillNodeGenerator;
import de.teamlapen.vampirism.data.TagGenerator;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.ModEntityEventHandler;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import de.teamlapen.vampirism.entity.VampirismEntitySelectors;
import de.teamlapen.vampirism.entity.action.ActionManagerEntity;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.factions.FactionRegistry;
import de.teamlapen.vampirism.modcompat.IMCHandler;
import de.teamlapen.vampirism.network.ModPacketDispatcher;
import de.teamlapen.vampirism.player.ModPlayerEventHandler;
import de.teamlapen.vampirism.player.actions.ActionManager;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.skills.SkillManager;
import de.teamlapen.vampirism.player.skills.SkillTreeManager;
import de.teamlapen.vampirism.player.vampire.BloodVision;
import de.teamlapen.vampirism.player.vampire.NightVision;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.potion.blood.BloodPotionRegistry;
import de.teamlapen.vampirism.potion.blood.BloodPotions;
import de.teamlapen.vampirism.proxy.ClientProxy;
import de.teamlapen.vampirism.proxy.IProxy;
import de.teamlapen.vampirism.proxy.ServerProxy;
import de.teamlapen.vampirism.tests.Tests;
import de.teamlapen.vampirism.util.GeneralRegistryImpl;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.REFERENCE;
import de.teamlapen.vampirism.util.SupporterManager;
import de.teamlapen.vampirism.util.VampireBookManager;
import de.teamlapen.vampirism.world.GarlicChunkHandler;
import de.teamlapen.vampirism.world.WorldGenManager;
import java.awt.Color;
import java.io.File;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityClassification;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="vampirism")
public class VampirismMod {
    public static final AbstractPacketDispatcher dispatcher = new ModPacketDispatcher();
    public static final ItemGroup creativeTab = new ItemGroup("vampirism"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModItems.vampire_fang);
        }
    };
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EntityClassification HUNTER_CREATURE_TYPE = EntityClassification.MONSTER;
    private static final EntityClassification VAMPIRE_CREATURE_TYPE = EntityClassification.MONSTER;
    private static final CreatureAttribute VAMPIRE_CREATURE_ATTRIBUTE = new CreatureAttribute();
    public static VampirismMod instance;
    public static IProxy proxy;
    public static boolean inDev;
    public static boolean inDataGen;
    public final ModCompatLoader modCompatLoader = new ModCompatLoader("vampirism/vampirism_mod_compat.cfg");
    private final RegistryManager registryManager;
    private VersionChecker.VersionInfo versionInfo;

    public static boolean isRealism() {
        return false;
    }

    public VampirismMod() {
        instance = this;
        this.checkEnv();
        Optional opt = ModList.get().getModContainerById("vampirism");
        if (opt.isPresent()) {
            REFERENCE.VERSION = ((ModContainer)opt.get()).getModInfo().getVersion();
        } else {
            LOGGER.warn("Cannot get version from mod info");
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::gatherData);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEventHandler::onModelBakeEvent);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        });
        VampirismConfig.registerConfigs();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.addModCompats();
        this.registryManager = new RegistryManager();
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.registryManager);
        MinecraftForge.EVENT_BUS.register((Object)this.registryManager);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, ModBiomes::onBiomeLoadingEventAdditions);
        this.setupAPI1();
        this.setupAPI2();
        File vampConfigDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "vampirism");
    }

    public VersionChecker.VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @SubscribeEvent
    public void onAddReloadListenerEvent(AddReloadListenerEvent event) {
        SkillTreeManager.getInstance().getSkillTree().initRootSkills();
        event.addListener((IFutureReloadListener)SkillTreeManager.getInstance());
        event.addListener((IFutureReloadListener)BloodValues.ENTITIES);
        event.addListener((IFutureReloadListener)BloodValues.ITEMS);
        event.addListener((IFutureReloadListener)BloodValues.FLUIDS);
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        ModCommands.registerCommands((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStart(FMLServerStartingEvent event) {
        for (BloodValueLoaderDynamic loader : BloodValues.getDynamicLoader()) {
            loader.onServerStarting(event.getServer());
        }
    }

    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        ModFeatures.registerStructureSeparation();
        ModWorld.addVillageStructures();
    }

    @SubscribeEvent
    public void onServerStarted(FMLServerStartedEvent event) {
        if (!ModLootTables.checkAndResetInsertedAll()) {
            LOGGER.warn("LootTables -------------------------------");
            LOGGER.warn("LootTables Failed to inject all loottables");
            LOGGER.warn("LootTables -------------------------------");
        }
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        for (BloodValueLoaderDynamic loader : BloodValues.getDynamicLoader()) {
            loader.onServerStopping();
        }
    }

    private void addModCompats() {
    }

    private void checkEnv() {
        String launchTarget = System.getenv().get("target");
        if (launchTarget != null && launchTarget.contains("dev")) {
            inDev = true;
        }
        if (launchTarget != null && launchTarget.contains("data")) {
            inDataGen = true;
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        this.finishAPI1();
        HelperRegistry.registerPlayerEventReceivingCapability(VampirePlayer.CAP, VampirePlayer.class);
        HelperRegistry.registerPlayerEventReceivingCapability(HunterPlayer.CAP, HunterPlayer.class);
        HelperRegistry.registerSyncableEntityCapability(ExtendedCreature.CAP, REFERENCE.EXTENDED_CREATURE_KEY, ExtendedCreature.class);
        HelperRegistry.registerSyncablePlayerCapability(VampirePlayer.CAP, REFERENCE.VAMPIRE_PLAYER_KEY, VampirePlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(HunterPlayer.CAP, REFERENCE.HUNTER_PLAYER_KEY, HunterPlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(FactionPlayerHandler.CAP, REFERENCE.FACTION_PLAYER_HANDLER_KEY, FactionPlayerHandler.class);
    }

    private void finishAPI1() {
        ((FactionRegistry)VampirismAPI.factionRegistry()).finish();
    }

    private void finishAPI2() {
        ((VampirismEntityRegistry)VampirismAPI.entityRegistry()).finishRegistration();
        ((BloodPotionRegistry)VampirismAPI.bloodPotionRegistry()).finish();
    }

    private void gatherData(GatherDataEvent event) {
        this.registryManager.onGatherData(event);
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            TagGenerator.register(gen);
            gen.func_200390_a((IDataProvider)new LootTablesGenerator(gen));
            gen.func_200390_a((IDataProvider)new AdvancementGenerator(gen));
            gen.func_200390_a((IDataProvider)new RecipesGenerator(gen));
            gen.func_200390_a((IDataProvider)new SkillNodeGenerator(gen));
        }
        if (event.includeClient()) {
            gen.func_200390_a((IDataProvider)new BlockStateGenerator(event.getGenerator(), event.getExistingFileHelper()));
            gen.func_200390_a((IDataProvider)new ItemModelGenerator(event.getGenerator(), event.getExistingFileHelper()));
        }
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        this.modCompatLoader.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
    }

    private void processIMC(InterModProcessEvent event) {
        this.finishAPI2();
        this.registryManager.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
        IMCHandler.handleInterModMessage(event);
        if (inDev) {
            Tests.runBackgroundTests();
        }
        ModWorld.initVillageStructures();
    }

    private void setup(FMLCommonSetupEvent event) {
        HunterPlayer.registerCapability();
        VampirePlayer.registerCapability();
        FactionPlayerHandler.registerCapability();
        ExtendedCreature.registerCapability();
        this.modCompatLoader.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        this.setupAPI3();
        dispatcher.registerPackets();
        this.registryManager.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        this.versionInfo = (Boolean)VampirismConfig.COMMON.versionCheck.get() == false ? new VersionChecker.VersionInfo(REFERENCE.VERSION) : VersionChecker.executeVersionCheck("https://maxanier.de/projects/vampirism/versions.json", REFERENCE.VERSION, !inDev && (Boolean)VampirismConfig.COMMON.collectStats.get() != false);
        ModEventHandler eventHandler = new ModEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)new ModPlayerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModEntityEventHandler());
        MinecraftForge.EVENT_BUS.addListener(ModLootTables::onLootLoad);
        SupporterManager.getInstance().initAsync();
        VampireBookManager.getInstance().init();
        BloodPotions.register();
        Permissions.init();
        VampirismEntitySelectors.registerSelectors();
    }

    private void setupAPI1() {
        FactionRegistry factionRegistry = new FactionRegistry();
        SundamageRegistry sundamageRegistry = new SundamageRegistry();
        VampirismEntityRegistry biteableRegistry = new VampirismEntityRegistry();
        ActionManager actionManager = new ActionManager();
        SkillManager skillManager = new SkillManager();
        GeneralRegistryImpl generalRegistry = new GeneralRegistryImpl();
        ActionManagerEntity entityActionManager = new ActionManagerEntity();
        WorldGenManager worldGenRegistry = new WorldGenManager();
        biteableRegistry.setDefaultConvertingHandlerCreator(DefaultConvertingHandler::new);
        BloodPotionRegistry bloodPotionRegistry = new BloodPotionRegistry();
        VampirismAPI.setUpRegistries(factionRegistry, sundamageRegistry, biteableRegistry, actionManager, skillManager, generalRegistry, bloodPotionRegistry, entityActionManager, worldGenRegistry);
        VampirismAPI.setUpAccessors(new GarlicChunkHandler.Provider());
    }

    private void setupAPI2() {
        VReference.VAMPIRE_FACTION = VampirismAPI.factionRegistry().registerPlayableFaction(REFERENCE.VAMPIRE_PLAYER_KEY, IVampirePlayer.class, Color.MAGENTA.darker().darker(), true, () -> VampirePlayer.CAP, 14);
        VReference.VAMPIRE_FACTION.setChatColor(TextFormatting.DARK_PURPLE).setTranslationKeys("text.vampirism.vampire", "text.vampirism.vampires");
        VReference.HUNTER_FACTION = VampirismAPI.factionRegistry().registerPlayableFaction(REFERENCE.HUNTER_PLAYER_KEY, IHunterPlayer.class, Color.BLUE, false, () -> HunterPlayer.CAP, 14);
        VReference.HUNTER_FACTION.setChatColor(TextFormatting.DARK_BLUE).setTranslationKeys("text.vampirism.hunter", "text.vampirism.hunters");
        VReference.HUNTER_CREATURE_TYPE = HUNTER_CREATURE_TYPE;
        VReference.VAMPIRE_CREATURE_TYPE = VAMPIRE_CREATURE_TYPE;
        VReference.VAMPIRE_CREATURE_ATTRIBUTE = VAMPIRE_CREATURE_ATTRIBUTE;
    }

    private void setupAPI3() {
        VReference.vision_nightVision = VampirismAPI.vampireVisionRegistry().registerVision("nightVision", new NightVision());
        VReference.vision_bloodVision = VampirismAPI.vampireVisionRegistry().registerVision("bloodVision", new BloodVision());
    }

    private void setupClient(FMLClientSetupEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
        this.modCompatLoader.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
    }

    static {
        proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
        inDev = false;
        inDataGen = false;
    }
}

