/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.advancements.AbstractCriterionTrigger;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SkillUnlockedTrigger
extends AbstractCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "skill_unlocked");

    public SkillUnlockedTrigger() {
        super(ID, Listeners::new);
    }

    public static Instance builder(ISkill skill) {
        return new Instance(skill);
    }

    public static Instance builder(ResourceLocation id) {
        return new Instance(id);
    }

    public void trigger(ServerPlayerEntity player, ISkill skill) {
        Listeners listeners = (Listeners)this.listenersForPlayers.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(skill);
        }
    }

    public Instance deserialize(JsonObject json, ConditionArrayParser parser) {
        return new Instance(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"skill")));
    }

    static class Listeners
    extends AbstractCriterionTrigger.GenericListeners<Instance> {
        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            super(playerAdvancementsIn);
        }

        void trigger(ISkill skill) {
            List list = null;
            for (ICriterionTrigger.Listener listener : this.playerListeners) {
                if (!((Instance)listener.func_192158_a()).test(skill)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener : list) {
                    listener.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    static class Instance
    extends CriterionInstance {
        @Nonnull
        private final ResourceLocation skillId;

        Instance(@Nonnull ISkill skill) {
            super(ID, EntityPredicate.AndPredicate.field_234582_a_);
            this.skillId = skill.getRegistryName();
        }

        Instance(@Nonnull ResourceLocation skillId) {
            super(ID, EntityPredicate.AndPredicate.field_234582_a_);
            this.skillId = skillId;
        }

        public boolean test(@Nonnull ISkill skill) {
            return this.skillId.equals((Object)skill.getRegistryName());
        }

        public JsonObject func_230240_a_(ConditionArraySerializer serializer) {
            JsonObject jsonObject = super.func_230240_a_(serializer);
            jsonObject.addProperty("skill", this.skillId.toString());
            return jsonObject;
        }
    }
}

