/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.advancements.AbstractCriterionTrigger;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampireActionTrigger
extends AbstractCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "vampire_action");
    private static final Logger LOGGER = LogManager.getLogger();

    public VampireActionTrigger() {
        super(ID, Listeners::new);
    }

    public static Instance builder(Action action) {
        return new Instance(action);
    }

    @Nonnull
    public Instance deserialize(JsonObject json, ConditionArrayParser parser) {
        Action action = Action.NONE;
        if (json.has("action")) {
            String name = json.get("action").getAsString();
            try {
                action = Action.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Action {} does not exist", (Object)name);
            }
        } else {
            LOGGER.warn("Action not specified");
        }
        return new Instance(action);
    }

    public void trigger(ServerPlayerEntity player, Action action) {
        Listeners listeners = (Listeners)this.listenersForPlayers.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(action);
        }
    }

    static class Listeners
    extends AbstractCriterionTrigger.GenericListeners<Instance> {
        Listeners(PlayerAdvancements playerAdvancementsIn) {
            super(playerAdvancementsIn);
        }

        void trigger(Action action) {
            List list = null;
            for (ICriterionTrigger.Listener listener : this.playerListeners) {
                if (!((Instance)listener.func_192158_a()).trigger(action)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    static class Instance
    extends CriterionInstance {
        @Nonnull
        private final Action action;

        Instance(@Nonnull Action action) {
            super(ID, EntityPredicate.AndPredicate.field_234582_a_);
            this.action = action;
        }

        boolean trigger(Action action) {
            return this.action == action;
        }

        @Nonnull
        public JsonObject func_230240_a_(ConditionArraySerializer serializer) {
            JsonObject json = super.func_230240_a_(serializer);
            json.addProperty("action", this.action.name());
            return json;
        }
    }

    public static enum Action {
        SNIPED_IN_BAT,
        POISONOUS_BITE,
        PERFORM_RITUAL_INFUSION,
        BAT,
        SUCK_BLOOD,
        NONE;

    }
}

