/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.tileentity.AltarInfusionTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class AltarInfusionBlock
extends VampirismBlockContainer {
    protected static final VoxelShape altarBase = AltarInfusionBlock.makeShape();
    private static final String name = "altar_infusion";

    private static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
        VoxelShape b = Block.func_208617_a((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
        VoxelShape c = Block.func_208617_a((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
        VoxelShape d1 = Block.func_208617_a((double)1.0, (double)6.0, (double)1.0, (double)3.0, (double)7.0, (double)15.0);
        VoxelShape d2 = Block.func_208617_a((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)7.0, (double)3.0);
        VoxelShape d3 = Block.func_208617_a((double)15.0, (double)6.0, (double)15.0, (double)15.0, (double)7.0, (double)3.0);
        VoxelShape d4 = Block.func_208617_a((double)15.0, (double)6.0, (double)15.0, (double)3.0, (double)7.0, (double)15.0);
        VoxelShape e1 = Block.func_208617_a((double)1.0, (double)6.0, (double)1.0, (double)3.0, (double)12.0, (double)3.0);
        VoxelShape e2 = Block.func_208617_a((double)13.0, (double)6.0, (double)1.0, (double)15.0, (double)12.0, (double)3.0);
        VoxelShape e3 = Block.func_208617_a((double)13.0, (double)6.0, (double)13.0, (double)15.0, (double)12.0, (double)15.0);
        VoxelShape e4 = Block.func_208617_a((double)1.0, (double)6.0, (double)13.0, (double)3.0, (double)12.0, (double)15.0);
        VoxelShape f1 = Block.func_208617_a((double)1.0, (double)12.0, (double)1.0, (double)2.0, (double)13.0, (double)2.0);
        VoxelShape f2 = Block.func_208617_a((double)14.0, (double)12.0, (double)1.0, (double)15.0, (double)13.0, (double)2.0);
        VoxelShape f3 = Block.func_208617_a((double)1.0, (double)12.0, (double)14.0, (double)2.0, (double)13.0, (double)15.0);
        VoxelShape f4 = Block.func_208617_a((double)14.0, (double)12.0, (double)14.0, (double)15.0, (double)13.0, (double)15.0);
        VoxelShape g = Block.func_208617_a((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
        VoxelShape h1 = Block.func_208617_a((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
        VoxelShape h2 = Block.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0);
        VoxelShape h3 = Block.func_208617_a((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
        return VoxelShapes.func_216384_a((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d1, d2, d3, d4, e1, e2, e3, e4, f1, f2, f3, f4, g, h1, h2, h3});
    }

    public AltarInfusionBlock() {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(5.0f).func_226896_b_());
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new AltarInfusionTileEntity();
    }

    public int getHarvestLevel(BlockState state) {
        return 2;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return altarBase;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        AltarInfusionTileEntity te = (AltarInfusionTileEntity)worldIn.func_175625_s(pos);
        if (worldIn.field_72995_K || te == null) {
            return ActionResultType.SUCCESS;
        }
        AltarInfusionTileEntity.Result result = te.canActivate(player, true);
        if (heldItem.func_190926_b() && result == AltarInfusionTileEntity.Result.OK) {
            te.startRitual(player);
            return ActionResultType.SUCCESS;
        }
        if (!heldItem.func_190926_b() || result == AltarInfusionTileEntity.Result.INVMISSING) {
            if (te.getCurrentPhase() != AltarInfusionTileEntity.PHASE.NOT_RUNNING) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.altar_infusion.ritual_still_running"), Util.field_240973_b_);
                return ActionResultType.SUCCESS;
            }
            player.func_213829_a((INamedContainerProvider)te);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropItems(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    private void dropItems(World world, BlockPos pos) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item.func_190926_b()) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            ItemEntity entityItem = new ItemEntity(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), item.func_77946_l());
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.func_213293_j(rand.nextGaussian() * (double)factor, rand.nextGaussian() * (double)factor + (double)0.2f, rand.nextGaussian() * (double)factor);
            world.func_217376_c((Entity)entityItem);
            inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }
}

