/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import de.teamlapen.vampirism.network.PlayEventPacket;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TentBlock
extends VampirismBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final IntegerProperty POSITION = IntegerProperty.func_177719_a((String)"position", (int)0, (int)3);
    private static final String name = "tent";
    private static final Table<Direction, Integer, VoxelShape> shapes;
    private static final Map<PlayerEntity.SleepResult, ITextComponent> sleepResults;
    private static final Table<Integer, Direction, Pair<Double, Double>> offsets;

    public TentBlock() {
        this(name);
    }

    protected TentBlock(String name) {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200943_b(0.6f).func_200947_a(SoundType.field_185854_g).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POSITION, (Comparable)Integer.valueOf(0))).func_206870_a((Property)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        if (HunterPlayer.getOpt(player).map(VampirismPlayer::getLevel).orElse(0) == 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.tent.cant_use"), true);
            return ActionResultType.SUCCESS;
        }
        if (!BedBlock.func_235330_a_((World)world)) {
            world.func_217377_a(pos, false);
            BlockPos blockpos = pos.func_177972_a(((Direction)blockState.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d());
            if (world.func_180495_p(blockpos).func_203425_a((Block)this)) {
                world.func_217377_a(blockpos, false);
            }
            world.func_230546_a_(null, DamageSource.func_233546_a_(), null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)blockState.func_177229_b((Property)BedBlock.field_176471_b)).booleanValue()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.tent.occupied"), true);
            return ActionResultType.SUCCESS;
        }
        BlockPos finalPos = pos;
        player.func_213819_a(pos).ifLeft(sleepResult1 -> {
            if (sleepResult1 != null) {
                player.func_146105_b(sleepResults.getOrDefault(sleepResult1, sleepResult1.func_221259_a()), true);
            }
        }).ifRight(u -> {
            this.setBedOccupied(blockState, world, pos, null, true);
            TentBlock.setTentSleepPosition(player, pos, (Integer)player.field_70170_p.func_180495_p(pos).func_177229_b((Property)POSITION), (Direction)player.field_70170_p.func_180495_p(pos).func_177229_b((Property)BlockStateProperties.field_208157_J));
        });
        return ActionResultType.SUCCESS;
    }

    public boolean func_196260_a(BlockState blockState, IWorldReader worldReader, BlockPos blockPos) {
        return worldReader.func_180495_p(blockPos).isAir((IBlockReader)worldReader, blockPos);
    }

    public void setBedOccupied(BlockState state, World world, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        this.forWholeTent(pos, state, (direction, blockPos) -> {
            BlockState blockState = world.func_180495_p(blockPos);
            if (blockState.func_177230_c() instanceof TentBlock) {
                world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)BlockStateProperties.field_208192_s, (Comparable)Boolean.valueOf(occupied)), 2);
            }
        });
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.7f);
    }

    public void func_176208_a(World world, @Nonnull BlockPos blockPos, BlockState blockState, @Nonnull PlayerEntity playerEntity) {
        this.forWholeTent(blockPos, blockState, (direction, blockPos1) -> {
            world.func_175655_b(blockPos1, true);
            if (!world.field_72995_K) {
                VampirismMod.dispatcher.sendToAllAround(new PlayEventPacket(1, (BlockPos)blockPos1, Block.func_196246_j((BlockState)world.func_180495_p(blockPos1))), (RegistryKey<World>)world.func_234923_W_(), blockPos1.func_177958_n(), blockPos1.func_177956_o(), blockPos1.func_177952_p(), 64.0);
                if (!playerEntity.func_184812_l_()) {
                    TentBlock.func_220054_a((BlockState)world.func_180495_p(blockPos1), (World)world, (BlockPos)blockPos1, null, (Entity)playerEntity, (ItemStack)playerEntity.func_184614_ca());
                }
            }
        });
    }

    public boolean isBed(BlockState state, IBlockReader world, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    public Direction getBedDirection(BlockState state, IWorldReader world, BlockPos pos) {
        switch ((Integer)state.func_177229_b((Property)POSITION)) {
            case 0: 
            case 3: {
                return ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d();
            }
        }
        return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_225608_bj_()) {
            super.func_176216_a(worldIn, entityIn);
        } else {
            Vector3d vec3d = entityIn.func_213322_ci();
            if (vec3d.field_72448_b < 0.0) {
                double d0 = entityIn instanceof LivingEntity ? 1.0 : 0.8;
                entityIn.func_213293_j(vec3d.field_72450_a, -vec3d.field_72448_b * (double)0.33f * d0, vec3d.field_72449_c);
            }
        }
    }

    private void forWholeTent(BlockPos blockPos, BlockState blockState, BiConsumer<Direction, BlockPos> consumer) {
        BlockPos main = blockPos;
        Direction dir = (Direction)blockState.func_177229_b((Property)FACING);
        int p = (Integer)blockState.func_177229_b((Property)POSITION);
        if (p == 0) {
            dir = dir.func_176734_d();
        } else if (p == 1) {
            main = blockPos.func_177972_a(dir.func_176746_e());
        } else if (p == 2) {
            main = blockPos.func_177972_a(dir.func_176746_e()).func_177972_a(dir.func_176734_d());
        } else if (p == 3) {
            main = blockPos.func_177972_a(dir);
            dir = dir.func_176734_d();
        }
        consumer.accept(dir, blockPos);
        BlockPos cur = main;
        if (cur != blockPos) {
            consumer.accept(dir, cur);
        }
        if ((cur = main.func_177972_a(dir)) != blockPos) {
            consumer.accept(dir, cur);
        }
        if ((cur = main.func_177972_a(dir.func_176735_f())) != blockPos) {
            consumer.accept(dir, cur);
        }
        if ((cur = main.func_177972_a(dir).func_177972_a(dir.func_176735_f())) != blockPos) {
            consumer.accept(dir, cur);
        }
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader blockReader, BlockPos blockPos, ISelectionContext context) {
        return (VoxelShape)shapes.get((Object)blockState.func_177229_b((Property)FACING), (Object)blockState.func_177229_b((Property)POSITION));
    }

    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POSITION, BlockStateProperties.field_208192_s});
    }

    public static void setTentSleepPosition(PlayerEntity player, BlockPos blockPos, int position, Direction facing) {
        player.func_70107_b((double)blockPos.func_177958_n() + (Double)((Pair)offsets.get((Object)position, (Object)facing)).getFirst(), (double)blockPos.func_177956_o() + 0.0625, (double)blockPos.func_177952_p() + (Double)((Pair)offsets.get((Object)position, (Object)facing)).getSecond());
    }

    private static VoxelShape makeShape() {
        return VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.5, (double)1.0, (double)0.0, (double)1.4, (double)1.45, (double)16.0), Block.func_208617_a((double)0.9, (double)1.4, (double)0.0, (double)1.8, (double)1.85, (double)16.0), Block.func_208617_a((double)1.3, (double)1.8, (double)0.0, (double)2.2, (double)2.25, (double)16.0), Block.func_208617_a((double)1.7, (double)2.2, (double)0.0, (double)2.6, (double)2.65, (double)16.0), Block.func_208617_a((double)2.1, (double)2.6, (double)0.0, (double)3.0, (double)3.05, (double)16.0), Block.func_208617_a((double)2.5, (double)3.0, (double)0.0, (double)3.4, (double)3.45, (double)16.0), Block.func_208617_a((double)2.9, (double)3.4, (double)0.0, (double)3.8, (double)3.85, (double)16.0), Block.func_208617_a((double)3.3, (double)3.8, (double)0.0, (double)4.2, (double)4.25, (double)16.0), Block.func_208617_a((double)3.7, (double)4.2, (double)0.0, (double)4.6, (double)4.65, (double)16.0), Block.func_208617_a((double)4.1, (double)4.6, (double)0.0, (double)5.0, (double)5.05, (double)16.0), Block.func_208617_a((double)4.5, (double)5.0, (double)0.0, (double)5.4, (double)5.45, (double)16.0), Block.func_208617_a((double)4.9, (double)5.4, (double)0.0, (double)5.8, (double)5.85, (double)16.0), Block.func_208617_a((double)5.3, (double)5.8, (double)0.0, (double)6.2, (double)6.25, (double)16.0), Block.func_208617_a((double)5.7, (double)6.2, (double)0.0, (double)6.6, (double)6.65, (double)16.0), Block.func_208617_a((double)6.1, (double)6.6, (double)0.0, (double)7.0, (double)7.05, (double)16.0), Block.func_208617_a((double)6.5, (double)7.0, (double)0.0, (double)7.4, (double)7.45, (double)16.0), Block.func_208617_a((double)6.9, (double)7.4, (double)0.0, (double)7.8, (double)7.85, (double)16.0), Block.func_208617_a((double)7.3, (double)7.8, (double)0.0, (double)8.2, (double)8.25, (double)16.0), Block.func_208617_a((double)7.7, (double)8.2, (double)0.0, (double)8.6, (double)8.65, (double)16.0), Block.func_208617_a((double)8.1, (double)8.6, (double)0.0, (double)9.0, (double)9.05, (double)16.0), Block.func_208617_a((double)8.5, (double)9.0, (double)0.0, (double)9.4, (double)9.45, (double)16.0), Block.func_208617_a((double)8.9, (double)9.4, (double)0.0, (double)9.8, (double)9.85, (double)16.0), Block.func_208617_a((double)9.3, (double)9.8, (double)0.0, (double)10.2, (double)10.25, (double)16.0), Block.func_208617_a((double)9.7, (double)10.2, (double)0.0, (double)10.6, (double)10.65, (double)16.0), Block.func_208617_a((double)10.1, (double)10.6, (double)0.0, (double)11.0, (double)11.05, (double)16.0), Block.func_208617_a((double)10.5, (double)11.0, (double)0.0, (double)11.4, (double)11.45, (double)16.0), Block.func_208617_a((double)10.9, (double)11.4, (double)0.0, (double)11.8, (double)11.85, (double)16.0), Block.func_208617_a((double)11.3, (double)11.8, (double)0.0, (double)12.2, (double)12.25, (double)16.0), Block.func_208617_a((double)11.7, (double)12.2, (double)0.0, (double)12.6, (double)12.65, (double)16.0), Block.func_208617_a((double)12.1, (double)12.6, (double)0.0, (double)13.0, (double)13.05, (double)16.0), Block.func_208617_a((double)12.5, (double)13.0, (double)0.0, (double)13.4, (double)13.45, (double)16.0), Block.func_208617_a((double)12.9, (double)13.4, (double)0.0, (double)13.8, (double)13.85, (double)16.0), Block.func_208617_a((double)13.3, (double)13.8, (double)0.0, (double)14.2, (double)14.25, (double)16.0), Block.func_208617_a((double)13.7, (double)14.2, (double)0.0, (double)14.6, (double)14.65, (double)16.0), Block.func_208617_a((double)14.1, (double)14.6, (double)0.0, (double)15.0, (double)15.05, (double)16.0), Block.func_208617_a((double)14.5, (double)15.0, (double)0.0, (double)15.4, (double)15.45, (double)16.0), Block.func_208617_a((double)14.9, (double)15.4, (double)0.0, (double)15.8, (double)15.85, (double)16.0), Block.func_208617_a((double)15.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    }

    private static VoxelShape makeShapeBack2() {
        return VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.85, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)14.0, (double)1.0, (double)0.0, (double)15.0, (double)14.65, (double)1.0), Block.func_208617_a((double)13.0, (double)1.0, (double)0.0, (double)14.0, (double)13.85, (double)1.0), Block.func_208617_a((double)12.0, (double)1.0, (double)0.0, (double)13.0, (double)12.65, (double)1.0), Block.func_208617_a((double)11.0, (double)1.0, (double)0.0, (double)12.0, (double)11.85, (double)1.0), Block.func_208617_a((double)10.0, (double)1.0, (double)0.0, (double)11.0, (double)10.65, (double)1.0), Block.func_208617_a((double)9.0, (double)1.0, (double)0.0, (double)10.0, (double)9.85, (double)1.0), Block.func_208617_a((double)8.0, (double)1.0, (double)0.0, (double)9.0, (double)8.65, (double)1.0), Block.func_208617_a((double)7.0, (double)1.0, (double)0.0, (double)8.0, (double)7.85, (double)1.0), Block.func_208617_a((double)6.0, (double)1.0, (double)0.0, (double)7.0, (double)6.65, (double)1.0), Block.func_208617_a((double)5.0, (double)1.0, (double)0.0, (double)6.0, (double)5.85, (double)1.0), Block.func_208617_a((double)4.0, (double)1.0, (double)0.0, (double)5.0, (double)4.65, (double)1.0), Block.func_208617_a((double)3.0, (double)1.0, (double)0.0, (double)4.0, (double)3.85, (double)1.0), Block.func_208617_a((double)2.0, (double)1.0, (double)0.0, (double)3.0, (double)2.65, (double)1.0), Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)2.0, (double)1.85, (double)1.0)});
    }

    private static VoxelShape makeShapeBack1() {
        return VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)14.0, (double)1.0, (double)0.0, (double)15.0, (double)1.85, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)13.0, (double)1.0, (double)0.0, (double)14.0, (double)2.65, (double)1.0), Block.func_208617_a((double)12.0, (double)1.0, (double)0.0, (double)13.0, (double)3.85, (double)1.0), Block.func_208617_a((double)11.0, (double)1.0, (double)0.0, (double)12.0, (double)4.65, (double)1.0), Block.func_208617_a((double)10.0, (double)1.0, (double)0.0, (double)11.0, (double)5.85, (double)1.0), Block.func_208617_a((double)9.0, (double)1.0, (double)0.0, (double)10.0, (double)6.65, (double)1.0), Block.func_208617_a((double)8.0, (double)1.0, (double)0.0, (double)9.0, (double)7.85, (double)1.0), Block.func_208617_a((double)7.0, (double)1.0, (double)0.0, (double)8.0, (double)8.65, (double)1.0), Block.func_208617_a((double)6.0, (double)1.0, (double)0.0, (double)7.0, (double)9.85, (double)1.0), Block.func_208617_a((double)5.0, (double)1.0, (double)0.0, (double)6.0, (double)10.65, (double)1.0), Block.func_208617_a((double)4.0, (double)1.0, (double)0.0, (double)5.0, (double)11.85, (double)1.0), Block.func_208617_a((double)3.0, (double)1.0, (double)0.0, (double)4.0, (double)12.65, (double)1.0), Block.func_208617_a((double)2.0, (double)1.0, (double)0.0, (double)3.0, (double)13.85, (double)1.0), Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)2.0, (double)14.65, (double)1.0), Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.85, (double)1.0)});
    }

    static {
        VoxelShape NORTH = TentBlock.makeShape();
        VoxelShape EAST = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.NINETY);
        VoxelShape SOUTH = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        VoxelShape WEST = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
        VoxelShape BACK = TentBlock.makeShapeBack1();
        VoxelShape BACKMIRROR = TentBlock.makeShapeBack2();
        VoxelShape SOUTHR = VoxelShapes.func_197872_a((VoxelShape)SOUTH, (VoxelShape)BACK);
        VoxelShape NORTHL = VoxelShapes.func_197872_a((VoxelShape)NORTH, (VoxelShape)BACKMIRROR);
        ImmutableTable.Builder shapeBuilder = ImmutableTable.builder();
        shapeBuilder.put((Object)Direction.NORTH, (Object)0, (Object)NORTH);
        shapeBuilder.put((Object)Direction.NORTH, (Object)1, (Object)NORTH);
        shapeBuilder.put((Object)Direction.NORTH, (Object)2, (Object)NORTHL);
        shapeBuilder.put((Object)Direction.NORTH, (Object)3, (Object)UtilLib.rotateShape(SOUTHR, UtilLib.RotationAmount.HUNDRED_EIGHTY));
        shapeBuilder.put((Object)Direction.EAST, (Object)0, (Object)EAST);
        shapeBuilder.put((Object)Direction.EAST, (Object)1, (Object)EAST);
        shapeBuilder.put((Object)Direction.EAST, (Object)2, (Object)UtilLib.rotateShape(NORTHL, UtilLib.RotationAmount.NINETY));
        shapeBuilder.put((Object)Direction.EAST, (Object)3, (Object)UtilLib.rotateShape(SOUTHR, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY));
        shapeBuilder.put((Object)Direction.SOUTH, (Object)0, (Object)SOUTH);
        shapeBuilder.put((Object)Direction.SOUTH, (Object)1, (Object)SOUTH);
        shapeBuilder.put((Object)Direction.SOUTH, (Object)2, (Object)UtilLib.rotateShape(NORTHL, UtilLib.RotationAmount.HUNDRED_EIGHTY));
        shapeBuilder.put((Object)Direction.SOUTH, (Object)3, (Object)SOUTHR);
        shapeBuilder.put((Object)Direction.WEST, (Object)0, (Object)WEST);
        shapeBuilder.put((Object)Direction.WEST, (Object)1, (Object)WEST);
        shapeBuilder.put((Object)Direction.WEST, (Object)2, (Object)UtilLib.rotateShape(NORTHL, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY));
        shapeBuilder.put((Object)Direction.WEST, (Object)3, (Object)UtilLib.rotateShape(SOUTHR, UtilLib.RotationAmount.NINETY));
        shapes = shapeBuilder.build();
        ImmutableTable.Builder offsetsBuilder = ImmutableTable.builder();
        offsetsBuilder.put((Object)0, (Object)Direction.NORTH, (Object)Pair.of((Object)1.0, (Object)1.6));
        offsetsBuilder.put((Object)0, (Object)Direction.EAST, (Object)Pair.of((Object)-0.6, (Object)1.0));
        offsetsBuilder.put((Object)0, (Object)Direction.SOUTH, (Object)Pair.of((Object)0.0, (Object)-0.6));
        offsetsBuilder.put((Object)0, (Object)Direction.WEST, (Object)Pair.of((Object)1.6, (Object)0.0));
        offsetsBuilder.put((Object)1, (Object)Direction.NORTH, (Object)Pair.of((Object)1.0, (Object)-0.6));
        offsetsBuilder.put((Object)1, (Object)Direction.EAST, (Object)Pair.of((Object)1.6, (Object)1.0));
        offsetsBuilder.put((Object)1, (Object)Direction.SOUTH, (Object)Pair.of((Object)0.0, (Object)1.6));
        offsetsBuilder.put((Object)1, (Object)Direction.WEST, (Object)Pair.of((Object)-0.6, (Object)0.0));
        offsetsBuilder.put((Object)2, (Object)Direction.NORTH, (Object)Pair.of((Object)1.0, (Object)0.4));
        offsetsBuilder.put((Object)2, (Object)Direction.EAST, (Object)Pair.of((Object)0.6, (Object)1.0));
        offsetsBuilder.put((Object)2, (Object)Direction.SOUTH, (Object)Pair.of((Object)0.0, (Object)0.6));
        offsetsBuilder.put((Object)2, (Object)Direction.WEST, (Object)Pair.of((Object)0.4, (Object)0.0));
        offsetsBuilder.put((Object)3, (Object)Direction.NORTH, (Object)Pair.of((Object)1.0, (Object)0.6));
        offsetsBuilder.put((Object)3, (Object)Direction.EAST, (Object)Pair.of((Object)0.4, (Object)1.0));
        offsetsBuilder.put((Object)3, (Object)Direction.SOUTH, (Object)Pair.of((Object)0.0, (Object)0.4));
        offsetsBuilder.put((Object)3, (Object)Direction.WEST, (Object)Pair.of((Object)0.6, (Object)0.0));
        offsets = offsetsBuilder.build();
        ImmutableMap.Builder sleepBuilder = ImmutableMap.builder();
        sleepBuilder.put((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_NOW, (Object)new TranslationTextComponent("text.vampirism.tent.no_sleep"));
        sleepBuilder.put((Object)PlayerEntity.SleepResult.TOO_FAR_AWAY, (Object)new TranslationTextComponent("text.vampirism.tent.too_far_away"));
        sleepBuilder.put((Object)PlayerEntity.SleepResult.OBSTRUCTED, (Object)new TranslationTextComponent("text.vampirism.tent.obstructed"));
        sleepResults = sleepBuilder.build();
    }
}

