/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import de.teamlapen.vampirism.inventory.container.WeaponTableContainer;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.util.Helper;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;

public class WeaponTableBlock
extends VampirismBlock {
    public static final String regName = "weapon_table";
    public static final int MAX_LAVA = 5;
    public static final int MB_PER_META = 200;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final IntegerProperty LAVA = IntegerProperty.func_177719_a((String)"lava", (int)0, (int)5);
    private static final ITextComponent name = new TranslationTextComponent("gui.vampirism.hunter_weapon_table");
    private static final VoxelShape NORTH = WeaponTableBlock.makeShape();
    private static final VoxelShape EAST = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.NINETY);
    private static final VoxelShape SOUTH = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.HUNDRED_EIGHTY);
    private static final VoxelShape WEST = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);

    private static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)2.0, (double)8.0);
        VoxelShape b = Block.func_208617_a((double)4.0, (double)2.0, (double)1.0, (double)12.0, (double)3.0, (double)7.0);
        VoxelShape c = Block.func_208617_a((double)5.0, (double)3.0, (double)2.0, (double)11.0, (double)6.0, (double)6.0);
        VoxelShape d = Block.func_208617_a((double)3.0, (double)6.0, (double)0.0, (double)13.0, (double)9.5, (double)8.0);
        VoxelShape e = Block.func_208617_a((double)0.0, (double)1.0, (double)9.0, (double)7.0, (double)2.0, (double)16.0);
        VoxelShape e1 = Block.func_208617_a((double)0.0, (double)0.0, (double)9.0, (double)2.0, (double)1.0, (double)11.0);
        VoxelShape e2 = Block.func_208617_a((double)5.0, (double)0.0, (double)9.0, (double)7.0, (double)1.0, (double)11.0);
        VoxelShape e3 = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)1.0, (double)16.0);
        VoxelShape e4 = Block.func_208617_a((double)5.0, (double)0.0, (double)14.0, (double)7.0, (double)1.0, (double)16.0);
        VoxelShape e5 = Block.func_208617_a((double)0.0, (double)1.0, (double)9.0, (double)1.0, (double)7.0, (double)16.0);
        VoxelShape e6 = Block.func_208617_a((double)0.0, (double)1.0, (double)9.0, (double)7.0, (double)7.0, (double)10.0);
        VoxelShape e7 = Block.func_208617_a((double)7.0, (double)1.0, (double)16.0, (double)0.0, (double)7.0, (double)15.0);
        VoxelShape e8 = Block.func_208617_a((double)7.0, (double)1.0, (double)16.0, (double)6.0, (double)7.0, (double)9.0);
        VoxelShape f = Block.func_208617_a((double)10.0, (double)0.0, (double)11.0, (double)15.0, (double)3.0, (double)14.0);
        VoxelShape g = Block.func_208617_a((double)12.0, (double)3.0, (double)12.0, (double)13.0, (double)10.0, (double)13.0);
        return VoxelShapes.func_216384_a((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d, e, e1, e2, e3, e4, e5, e6, e7, e8, f, g});
    }

    public WeaponTableBlock() {
        super(regName, AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)LAVA, (Comparable)Integer.valueOf(0))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        return new SimpleNamedContainerProvider((id, playerInventory, playerEntity) -> new WeaponTableContainer(id, playerInventory, IWorldPosCallable.func_221488_a((World)worldIn, (BlockPos)pos)), name);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return NORTH;
            }
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return NORTH;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            int fluid = (Integer)world.func_180495_p(pos).func_177229_b((Property)LAVA);
            boolean flag = false;
            ItemStack heldItem = player.func_184586_b(hand);
            if (fluid < 5) {
                LazyOptional opt = FluidUtil.getFluidHandler((ItemStack)heldItem);
                flag = opt.map(fluidHandler -> {
                    FluidStack drained;
                    FluidStack missing = new FluidStack((Fluid)Fluids.field_204547_b, (5 - fluid) * 200);
                    FluidStack drainable = fluidHandler.drain(missing, IFluidHandler.FluidAction.SIMULATE);
                    if (drainable.isEmpty()) {
                        missing.setAmount(1000);
                        drainable = fluidHandler.drain(missing, IFluidHandler.FluidAction.SIMULATE);
                    }
                    if (drainable.getAmount() >= 200 && (drained = fluidHandler.drain(missing, IFluidHandler.FluidAction.EXECUTE)).getAmount() > 0) {
                        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LAVA, (Comparable)Integer.valueOf(Math.min(5, fluid + drained.getAmount() / 200))));
                        player.func_184611_a(hand, fluidHandler.getContainer());
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
            if (!flag) {
                if (this.canUse(player) && player instanceof ServerPlayerEntity) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, playerIn) -> new WeaponTableContainer(id, playerInventory, IWorldPosCallable.func_221488_a((World)playerIn.field_70170_p, (BlockPos)pos)), (ITextComponent)new TranslationTextComponent("container.crafting")), (BlockPos)pos);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.weapon_table.cannot_use"), true);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LAVA, FACING});
    }

    private boolean canUse(PlayerEntity player) {
        if (Helper.isHunter(player)) {
            return HunterPlayer.get(player).getSkillHandler().isSkillEnabled(HunterSkills.weapon_table);
        }
        return false;
    }
}

