/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.blocks;

import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.tileentity.BloodContainerTileEntity;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class BakedBloodContainerModel
implements IDynamicBakedModel {
    public static final int FLUID_LEVELS = 14;
    public static final IBakedModel[] BLOOD_FLUID_MODELS = new IBakedModel[14];
    public static final IBakedModel[] IMPURE_BLOOD_FLUID_MODELS = new IBakedModel[14];
    private static final ItemOverrideList overrideList = new CustomItemOverride();
    private final IBakedModel baseModel;
    private boolean impure;
    private int fluidLevel = 0;
    private boolean item;

    public BakedBloodContainerModel(IBakedModel baseModel) {
        this.baseModel = baseModel;
    }

    public BakedBloodContainerModel(IBakedModel baseModel, FluidStack stack) {
        this.baseModel = baseModel;
        this.impure = stack.getFluid().equals(ModFluids.impure_blood);
        this.fluidLevel = MathHelper.func_76125_a((int)(stack.getAmount() / 900), (int)1, (int)14) - 1;
        this.item = true;
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return overrideList;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(this.baseModel.func_200117_a(state, side, rand));
        if (!this.item) {
            Integer level = (Integer)extraData.getData(BloodContainerTileEntity.FLUID_LEVEL_PROP);
            Boolean impure = (Boolean)extraData.getData(BloodContainerTileEntity.FLUID_IMPURE);
            if (impure != null && level != null && level > 0 && level <= 14) {
                quads.addAll((impure != false ? IMPURE_BLOOD_FLUID_MODELS[level - 1] : BLOOD_FLUID_MODELS[level - 1]).func_200117_a(state, side, rand));
            }
        } else {
            quads.addAll((this.impure ? IMPURE_BLOOD_FLUID_MODELS[this.fluidLevel] : BLOOD_FLUID_MODELS[this.fluidLevel]).func_200117_a(state, side, rand));
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.baseModel.func_230044_c_();
    }

    private static class CustomItemOverride
    extends ItemOverrideList {
        CustomItemOverride() {
        }

        public IBakedModel func_239290_a_(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, ClientWorld world, LivingEntity entity) {
            FluidStack fluid;
            if (originalModel instanceof BakedBloodContainerModel && stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid") && !(fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)stack.func_77978_p().func_74775_l("fluid"))).isEmpty()) {
                return new BakedBloodContainerModel(originalModel, fluid);
            }
            return originalModel;
        }
    }
}

