/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VampirePlayerHeadLayer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private final ResourceLocation[] eyeOverlays = new ResourceLocation[16];
    private final ResourceLocation[] fangOverlays;

    public VampirePlayerHeadLayer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRendererIn) {
        super(entityRendererIn);
        int i;
        for (i = 0; i < this.eyeOverlays.length; ++i) {
            this.eyeOverlays[i] = new ResourceLocation("vampirism:textures/entity/vanilla/eyes" + i + ".png");
        }
        this.fangOverlays = new ResourceLocation[7];
        for (i = 0; i < this.fangOverlays.length; ++i) {
            this.fangOverlays[i] = new ResourceLocation("vampirism:textures/entity/vanilla/fangs" + i + ".png");
        }
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int i, AbstractClientPlayerEntity player, float v, float v1, float v2, float v3, float v4, float v5) {
        if (!((Boolean)VampirismConfig.CLIENT.renderVampireEyes.get()).booleanValue() || !player.func_70089_S()) {
            return;
        }
        VampirePlayer vampirePlayer = VampirePlayer.get((PlayerEntity)player);
        if (vampirePlayer.getLevel() > 0 && !vampirePlayer.isDisguised() && !player.func_82150_aj()) {
            int eyeType = Math.max(0, Math.min(vampirePlayer.getEyeType(), this.eyeOverlays.length - 1));
            int fangType = Math.max(0, Math.min(vampirePlayer.getFangType(), this.fangOverlays.length - 1));
            IVertexBuilder vertexBuilderEye = iRenderTypeBuffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)this.eyeOverlays[eyeType]));
            int packerOverlay = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
            ModelRenderer head = ((PlayerModel)this.func_215332_c()).field_78116_c;
            head.func_228308_a_(matrixStack, vertexBuilderEye, i, packerOverlay);
            IVertexBuilder vertexBuilderFang = iRenderTypeBuffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)this.fangOverlays[fangType]));
            head.func_228308_a_(matrixStack, vertexBuilderFang, i, packerOverlay);
        }
    }
}

