/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.particle;

import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleData;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class FlyingBloodEntityParticle
extends SpriteTexturedParticle {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int MAX_AGE = 60;
    private final Entity entity;

    public FlyingBloodEntityParticle(ClientWorld world, double posX, double posY, double posZ, Entity entity, boolean direct) {
        super(world, posX, posY, posZ, 0.0, 0.0, 0.0);
        Validate.notNull((Object)entity);
        this.entity = entity;
        this.field_70552_h = 0.95f;
        this.field_70553_i = 0.05f;
        this.field_70551_j = 0.05f;
        this.field_70547_e = direct ? 30 : 60;
        if (direct) {
            this.field_187129_i = (this.field_187122_b.field_73012_v.nextDouble() - 0.5) / 5.0;
            this.field_187130_j = this.field_187122_b.field_73012_v.nextDouble() / 5.0;
            this.field_187131_k = (this.field_187122_b.field_73012_v.nextDouble() - 0.5) / 5.0;
        } else {
            this.field_187129_i = this.field_187122_b.field_73012_v.nextDouble() - 0.5;
            this.field_187130_j = this.field_187122_b.field_73012_v.nextDouble() + 0.2;
            this.field_187131_k = this.field_187122_b.field_73012_v.nextDouble() - 0.5;
        }
        this.func_217567_a(Minecraft.func_71410_x().field_71452_i.field_215243_j.func_195424_a(new ResourceLocation("minecraft", "particle/critical_hit")));
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        double wayX = this.entity.func_226277_ct_() - this.field_187126_f;
        double wayY = this.entity.func_226278_cu_() + (double)this.entity.func_70047_e() - this.field_187127_g;
        double wayZ = this.entity.func_226281_cx_() - this.field_187128_h;
        int tleft = this.field_70547_e - this.field_70546_d;
        if (tleft < this.field_70547_e / 2) {
            this.field_187129_i = wayX / (double)tleft;
            this.field_187130_j = wayY / (double)tleft;
            this.field_187131_k = wayZ / (double)tleft;
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (++this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<FlyingBloodEntityParticleData> {
        @Nullable
        public Particle makeParticle(FlyingBloodEntityParticleData typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Entity e = worldIn.func_73045_a(typeIn.getEntityID());
            if (e == null) {
                LOGGER.warn("Could not find entity {} for flying blood particle", (Object)typeIn.getEntityID());
                return null;
            }
            return new FlyingBloodEntityParticle(worldIn, x, y, z, e, typeIn.getDirect());
        }
    }
}

