/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableList;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.world.biome.VampirismBiomeFeatures;
import java.util.ArrayList;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

public class ModBiomes {
    @ObjectHolder(value="vampirism:vampire_forest")
    public static final Biome vampire_forest = (Biome)UtilLib.getNull();
    public static final RegistryKey<Biome> VAMPIRE_FOREST_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("vampirism", "vampire_forest"));

    static void registerBiomes(IForgeRegistry<Biome> registry) {
        MobSpawnInfo.Builder forestSpawnBuilder = new MobSpawnInfo.Builder();
        forestSpawnBuilder.func_242572_a(0.25f);
        forestSpawnBuilder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.vampire, BalanceMobProps.mobProps.VAMPIRE_SPAWN_CHANCE / 2, 1, 3));
        BalanceMobProps.mobProps.getClass();
        forestSpawnBuilder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.vampire_baron, 10, 1, 1));
        BalanceMobProps.mobProps.getClass();
        forestSpawnBuilder.func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners(ModEntities.blinding_bat, 30, 2, 4));
        forestSpawnBuilder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.dummy_creature, BalanceMobProps.mobProps.DUMMY_CREATURE_SPAWN_CHANCE, 3, 6));
        BiomeAmbience.Builder ambienceBuilder = new BiomeAmbience.Builder().func_235246_b_(15607045).func_235248_c_(15607045).func_235239_a_(0xE0A0A0).func_242539_d(0xA08080).func_242540_e(0x1E1F1F).func_242541_f(0x1E1F1F).func_235243_a_(MoodSoundAmbience.field_235027_b_);
        registry.register(ModBiomes.getVampireForestBuilder(0.1f, 0.025f, forestSpawnBuilder, ambienceBuilder).func_242455_a().setRegistryName(VAMPIRE_FOREST_KEY.func_240901_a_()));
        VampirismAPI.sundamageRegistry().addNoSundamageBiomes(VAMPIRE_FOREST_KEY.func_240901_a_());
    }

    static void addBiomesToGeneratorUnsafe() {
        ArrayList<RegistryKey> modList = new ArrayList<RegistryKey>(OverworldBiomeProvider.field_226847_e_);
        modList.add(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("vampirism", "vampire_forest")));
        OverworldBiomeProvider.field_226847_e_ = ImmutableList.copyOf(modList);
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(VAMPIRE_FOREST_KEY, ((Integer)VampirismConfig.BALANCE.vampireForestWeight.get()).intValue()));
    }

    public static void onBiomeLoadingEventAdditions(BiomeLoadingEvent event) {
        if (event.getSpawns().getEntityTypes().contains(EntityType.field_200725_aD)) {
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.vampire, BalanceMobProps.mobProps.VAMPIRE_SPAWN_CHANCE, 1, 2));
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.advanced_vampire, BalanceMobProps.mobProps.ADVANCED_VAMPIRE_SPAWN_PROBE, 1, 1));
        }
        event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, (ConfiguredFeature)ModFeatures.vampire_dungeon.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242729_a(((Integer)VampirismConfig.BALANCE.vampireDungeonWeight.get()).intValue()));
        if (!((Boolean)VampirismConfig.SERVER.disableHunterTentGen.get()).booleanValue() && VampirismAPI.worldGenRegistry().canStructureBeGeneratedInBiome(ModFeatures.hunter_camp.getRegistryName(), event.getName(), event.getCategory())) {
            event.getGeneration().func_242516_a(ModFeatures.hunter_camp.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    private static Biome.Builder getVampireForestBuilder(float depth, float scale, MobSpawnInfo.Builder spawnBuilder, BiomeAmbience.Builder ambienceBuilder) {
        BiomeGenerationSettings.Builder biomeGeneratorSettings = new BiomeGenerationSettings.Builder().func_242517_a(SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)new SurfaceBuilderConfig(ModBlocks.cursed_earth.func_176223_P(), ModBlocks.cursed_earth.func_176223_P(), ModBlocks.cursed_earth.func_176223_P())));
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)biomeGeneratorSettings);
        VampirismBiomeFeatures.addModdedWaterLake(biomeGeneratorSettings);
        VampirismBiomeFeatures.addVampireFlower(biomeGeneratorSettings);
        DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)biomeGeneratorSettings);
        DefaultBiomeFeatures.func_243705_S((BiomeGenerationSettings.Builder)biomeGeneratorSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)biomeGeneratorSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)biomeGeneratorSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)biomeGeneratorSettings);
        VampirismBiomeFeatures.addVampireTrees(biomeGeneratorSettings);
        VampirismBiomeFeatures.addWaterSprings(biomeGeneratorSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(depth).func_205420_b(scale).func_205414_c(0.3f).func_205417_d(0.0f).func_235097_a_(ambienceBuilder.func_235238_a_()).func_242458_a(spawnBuilder.func_242577_b()).func_242457_a(biomeGeneratorSettings.func_242508_a());
    }
}

