/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModLootTables {
    private static final Set<ResourceLocation> LOOT_TABLES = Sets.newHashSet();
    private static final Map<String, ResourceLocation> INJECTION_TABLES = Maps.newHashMap();
    public static final ResourceLocation abandoned_mineshaft = ModLootTables.registerInject("abandoned_mineshaft");
    public static final ResourceLocation jungle_temple = ModLootTables.registerInject("jungle_temple");
    public static final ResourceLocation stronghold_corridor = ModLootTables.registerInject("stronghold_corridor");
    public static final ResourceLocation desert_pyramid = ModLootTables.registerInject("desert_pyramid");
    public static final ResourceLocation stronghold_library = ModLootTables.registerInject("stronghold_library");
    public static final ResourceLocation chest_hunter_trainer = ModLootTables.register("chests/village/hunter_trainer");
    public static final ResourceLocation chest_vampire_dungeon = ModLootTables.register("chests/dungeon/vampire_dungeon");
    private static int injected = 0;

    static ResourceLocation registerInject(String resourceName) {
        ResourceLocation registryName = ModLootTables.register("inject/" + resourceName);
        INJECTION_TABLES.put(resourceName, registryName);
        return registryName;
    }

    static ResourceLocation register(String resourceName) {
        return ModLootTables.register(new ResourceLocation("vampirism", resourceName));
    }

    static ResourceLocation register(@Nonnull ResourceLocation resourceLocation) {
        LOOT_TABLES.add(resourceLocation);
        return resourceLocation;
    }

    public static Set<ResourceLocation> getLootTables() {
        return ImmutableSet.copyOf(LOOT_TABLES);
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        String file;
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix) && INJECTION_TABLES.containsKey(file = name.substring(name.indexOf(prefix) + prefix.length()))) {
            event.getTable().addPool(ModLootTables.getInjectPool(file));
            ++injected;
        }
    }

    private static LootPool getInjectPool(String entryName) {
        StandaloneLootEntry.Builder entryBuilder = TableLootEntry.func_216171_a((ResourceLocation)INJECTION_TABLES.get(entryName)).func_216086_a(1);
        return LootPool.func_216096_a().name("vampirism_inject_pool").bonusRolls(0.0f, 1.0f).func_216046_a((IRandomRange)new RandomValueRange(1.0f)).func_216045_a((LootEntry.Builder)entryBuilder).func_216044_b();
    }

    public static boolean checkAndResetInsertedAll() {
        int i = injected;
        injected = 0;
        return i >= INJECTION_TABLES.size();
    }
}

