/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.util.ASMHooks;
import de.teamlapen.vampirism.world.gen.util.BiomeTopBlockProcessor;
import de.teamlapen.vampirism.world.gen.util.RandomBlockState;
import de.teamlapen.vampirism.world.gen.util.RandomStructureProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.VillagesPools;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModWorld {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean debug = false;

    public static void initVillageStructures() {
        ModWorld.setupSingleJigsawPieceGeneration();
        VillagesPools.func_244194_a();
        Pair<Map<String, List<Pair<JigsawPiece, Integer>>>, Map<String, JigsawPattern>> structures = ModWorld.getStructures();
        ModWorld.replaceTemples((Map)structures.getFirst());
        ModWorld.addVillageStructures((Map)structures.getFirst());
        ModWorld.saveChanges((Map)structures.getFirst(), (Map)structures.getSecond());
    }

    public static void addVillageStructures() {
        Pair<Map<String, List<Pair<JigsawPiece, Integer>>>, Map<String, JigsawPattern>> structures = ModWorld.getStructures();
        ModWorld.addVillageStructures((Map)structures.getFirst());
        ModWorld.saveChanges((Map)structures.getFirst(), (Map)structures.getSecond());
    }

    public static void addVillageStructures(Map<String, List<Pair<JigsawPiece, Integer>>> map) {
        ModWorld.addHunterTrainerHouse(map);
        ModWorld.addTotem(map);
    }

    private static Pair<Map<String, List<Pair<JigsawPiece, Integer>>>, Map<String, JigsawPattern>> getStructures() {
        HashMap<String, JigsawPattern> patterns = new HashMap<String, JigsawPattern>(){
            {
                this.put("plains", WorldGenRegistries.field_243656_h.func_241873_b(new ResourceLocation("village/plains/houses")).get());
                this.put("desert", WorldGenRegistries.field_243656_h.func_241873_b(new ResourceLocation("village/desert/houses")).get());
                this.put("savanna", WorldGenRegistries.field_243656_h.func_241873_b(new ResourceLocation("village/savanna/houses")).get());
                this.put("taiga", WorldGenRegistries.field_243656_h.func_241873_b(new ResourceLocation("village/taiga/houses")).get());
                this.put("snowy", WorldGenRegistries.field_243656_h.func_241873_b(new ResourceLocation("village/snowy/houses")).get());
                this.put("plains_zombie", WorldGenRegistries.field_243656_h.func_241873_b(new ResourceLocation("village/plains/zombie/houses")).get());
                this.put("desert_zombie", WorldGenRegistries.field_243656_h.func_241873_b(new ResourceLocation("village/desert/zombie/houses")).get());
                this.put("savanna_zombie", WorldGenRegistries.field_243656_h.func_241873_b(new ResourceLocation("village/savanna/zombie/houses")).get());
                this.put("taiga_zombie", WorldGenRegistries.field_243656_h.func_241873_b(new ResourceLocation("village/taiga/zombie/houses")).get());
                this.put("snowy_zombie", WorldGenRegistries.field_243656_h.func_241873_b(new ResourceLocation("village/snowy/zombie/houses")).get());
            }
        };
        HashMap buildings = Maps.newHashMapWithExpectedSize((int)patterns.size());
        patterns.forEach((biome, pattern) -> {
            List cfr_ignored_0 = buildings.put(biome, Lists.newArrayList((Iterable)pattern.field_214952_d));
        });
        return Pair.of((Object)buildings, (Object)patterns);
    }

    private static void replaceTemples(Map<String, List<Pair<JigsawPiece, Integer>>> buildings) {
        HashMap<String, Map<String, JigsawPiece>> temples = new HashMap<String, Map<String, JigsawPiece>>(){
            {
                this.put("plains", ImmutableMap.of((Object)ModWorld.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_3"), (Object)ModWorld.singleJigsawPiece("village/plains/houses/plains_temple_3", ProcessorLists.field_244107_g), (Object)ModWorld.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_4"), (Object)ModWorld.singleJigsawPiece("village/plains/houses/plains_temple_4", ProcessorLists.field_244107_g)));
                this.put("desert", ImmutableMap.of((Object)ModWorld.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_1"), (Object)ModWorld.singleJigsawPiece("village/desert/houses/desert_temple_1"), (Object)ModWorld.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_2"), (Object)ModWorld.singleJigsawPiece("village/desert/houses/desert_temple_2")));
                this.put("savanna", ImmutableMap.of((Object)ModWorld.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_1"), (Object)ModWorld.singleJigsawPiece("village/savanna/houses/savanna_temple_1"), (Object)ModWorld.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_2"), (Object)ModWorld.singleJigsawPiece("village/savanna/houses/savanna_temple_2")));
                this.put("taiga", ImmutableMap.of((Object)ModWorld.singleLegacyJigsawString("minecraft:village/taiga/houses/taiga_temple_1"), (Object)ModWorld.singleJigsawPiece("village/taiga/houses/taiga_temple_1", ProcessorLists.field_244107_g)));
                this.put("snowy", ImmutableMap.of((Object)ModWorld.singleLegacyJigsawString("minecraft:village/snowy/houses/snowy_temple_1"), (Object)ModWorld.singleJigsawPiece("village/snowy/houses/snowy_temple_1")));
                this.put("plains_zombie", ImmutableMap.of((Object)ModWorld.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_3"), (Object)ModWorld.singleJigsawPiece("village/plains/houses/plains_temple_3", ProcessorLists.field_244102_b), (Object)ModWorld.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_4"), (Object)ModWorld.singleJigsawPiece("village/plains/houses/plains_temple_4", ProcessorLists.field_244102_b)));
                this.put("desert_zombie", ImmutableMap.of((Object)ModWorld.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_1"), (Object)ModWorld.singleJigsawPiece("village/desert/houses/desert_temple_1", ProcessorLists.field_244106_f), (Object)ModWorld.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_2"), (Object)ModWorld.singleJigsawPiece("village/desert/houses/desert_temple_2", ProcessorLists.field_244106_f)));
                this.put("savanna_zombie", ImmutableMap.of((Object)ModWorld.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_1"), (Object)ModWorld.singleJigsawPiece("village/savanna/houses/savanna_temple_1", ProcessorLists.field_244103_c), (Object)ModWorld.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_2"), (Object)ModWorld.singleJigsawPiece("village/savanna/houses/savanna_temple_2", ProcessorLists.field_244103_c)));
                this.put("taiga_zombie", ImmutableMap.of((Object)ModWorld.singleLegacyJigsawString("minecraft:village/taiga/zombie/houses/taiga_temple_1"), (Object)ModWorld.singleJigsawPiece("village/taiga/houses/taiga_temple_1", ProcessorLists.field_244105_e)));
                this.put("snowy_zombie", ImmutableMap.of((Object)ModWorld.singleLegacyJigsawString("minecraft:village/snowy/houses/snowy_temple_1"), (Object)ModWorld.singleJigsawPiece("village/snowy/houses/snowy_temple_1", ProcessorLists.field_244104_d)));
            }
        };
        HashMap allPieces = Maps.newHashMapWithExpectedSize((int)temples.size());
        temples.forEach((biome, replacer) -> ((List)buildings.get(biome)).removeIf(house -> {
            if (replacer.containsKey(((JigsawPiece)house.getFirst()).toString())) {
                allPieces.computeIfAbsent(biome, key -> Lists.newArrayList()).add(Pair.of(replacer.get(((JigsawPiece)house.getFirst()).toString()), (Object)house));
                return true;
            }
            return false;
        }));
        if (allPieces.size() > temples.size()) {
            LOGGER.error("Could not find all temples to replace");
        }
        temples.forEach((biome, replacer) -> replacer.values().forEach(piece -> {
            if (allPieces.containsKey(biome)) {
                ((List)allPieces.get(biome)).forEach(pair -> {
                    if (pair.getFirst() == piece) {
                        int weight = Math.max((int)((double)((Integer)((Pair)pair.getSecond()).getSecond()).intValue() * 0.6), 1);
                        ((List)buildings.get(biome)).add(Pair.of((Object)piece, (Object)weight));
                        ((List)buildings.get(biome)).add(Pair.of((Object)((Pair)pair.getSecond()).getFirst(), (Object)weight));
                    }
                });
            }
        }));
    }

    private static void addHunterTrainerHouse(Map<String, List<Pair<JigsawPiece, Integer>>> buildings) {
        ImmutableMap processors = ImmutableMap.of((Object)"plains_zombie", (Object)ProcessorLists.field_244102_b, (Object)"desert_zombie", (Object)ProcessorLists.field_244106_f, (Object)"snowy_zombie", (Object)ProcessorLists.field_244104_d, (Object)"savanna_zombie", (Object)ProcessorLists.field_244103_c, (Object)"taiga_zombie", (Object)ProcessorLists.field_244105_e);
        JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(new ResourceLocation("vampirism", "village/entities/hunter_trainer"), new ResourceLocation("empty"), (List)Lists.newArrayList((Object[])new Pair[]{Pair.of(ModWorld.singleJigsawPieceFunction("village/entities/hunter_trainer"), (Object)1)}), JigsawPattern.PlacementBehaviour.RIGID));
        buildings.forEach((arg_0, arg_1) -> ModWorld.lambda$addHunterTrainerHouse$8((Map)processors, arg_0, arg_1));
    }

    private static void addTotem(Map<String, List<Pair<JigsawPiece, Integer>>> buildings) {
        RandomStructureProcessor totemProcessor = new RandomStructureProcessor((List<RandomBlockState>)ImmutableList.of((Object)((Object)new RandomBlockState((RuleTest)new RandomBlockMatchRuleTest((Block)ModBlocks.totem_top, ((Double)VampirismConfig.BALANCE.viTotemPreSetPercentage.get()).floatValue()), (RuleTest)AlwaysTrueRuleTest.field_215190_a, ModBlocks.totem_top_vampirism_hunter.func_176223_P(), ModBlocks.totem_top_vampirism_vampire.func_176223_P()))));
        BiomeTopBlockProcessor totemTopBlock = new BiomeTopBlockProcessor(Blocks.field_222459_lw.func_176223_P());
        SingleJigsawPiece totem = ModWorld.singleJigsawPiece("village/totem", new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{totemProcessor, totemTopBlock})));
        buildings.values().forEach(list -> list.removeIf(pair -> ((JigsawPiece)pair.getFirst()).toString().equals(ModWorld.singleJigsawString("vampirism:village/totem"))));
        buildings.values().forEach(arg_0 -> ModWorld.lambda$addTotem$11((JigsawPiece)totem, arg_0));
    }

    private static void setupSingleJigsawPieceGeneration() {
        ASMHooks.addSingleInstanceStructure(Lists.newArrayList((Object[])new String[]{ModWorld.singleJigsawString("vampirism:village/totem"), ModWorld.singleJigsawString("vampirism:village/desert/houses/hunter_trainer"), ModWorld.singleJigsawString("vampirism:village/plains/houses/hunter_trainer"), ModWorld.singleJigsawString("vampirism:village/snowy/houses/hunter_trainer"), ModWorld.singleJigsawString("vampirism:village/savanna/houses/hunter_trainer"), ModWorld.singleJigsawString("vampirism:village/taiga/houses/hunter_trainer")}));
    }

    private static void saveChanges(Map<String, List<Pair<JigsawPiece, Integer>>> buildings, Map<String, JigsawPattern> patterns) {
        buildings.forEach((biome, list) -> {
            ((JigsawPattern)patterns.get((Object)biome)).field_214952_d = ImmutableList.copyOf((Collection)list);
        });
        patterns.values().forEach(pattern -> {
            pattern.field_214953_e.clear();
            pattern.field_214952_d.forEach(pair -> {
                for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                    pattern.field_214953_e.add(pair.getFirst());
                }
            });
        });
    }

    private static SingleJigsawPiece singleJigsawPiece(@Nonnull String path) {
        return ModWorld.singleJigsawPiece(path, new StructureProcessorList(Collections.emptyList()));
    }

    private static SingleJigsawPiece singleJigsawPiece(@Nonnull String path, @Nonnull StructureProcessorList processors) {
        return (SingleJigsawPiece)SingleJigsawPiece.func_242861_b((String)("vampirism:" + path), (StructureProcessorList)processors).apply(JigsawPattern.PlacementBehaviour.RIGID);
    }

    private static Function<JigsawPattern.PlacementBehaviour, SingleJigsawPiece> singleJigsawPieceFunction(@Nonnull String path) {
        return ModWorld.singleJigsawPieceFunction(path, new StructureProcessorList(Collections.emptyList()));
    }

    private static Function<JigsawPattern.PlacementBehaviour, SingleJigsawPiece> singleJigsawPieceFunction(@Nonnull String path, @Nonnull StructureProcessorList processors) {
        return SingleJigsawPiece.func_242861_b((String)("vampirism:" + path), (StructureProcessorList)processors);
    }

    private static String singleJigsawString(String resourceLocation) {
        return "Single[Left[" + resourceLocation + "]]";
    }

    private static String singleLegacyJigsawString(String resourceLocation) {
        return "LegacySingle[Left[" + resourceLocation + "]]";
    }

    private static /* synthetic */ void lambda$addTotem$11(JigsawPiece totem, List list) {
        list.add(Pair.of((Object)totem, (Object)VampirismConfig.BALANCE.viTotemWeight.get()));
    }

    private static /* synthetic */ void lambda$addHunterTrainerHouse$8(Map processors, String name, List list) {
        list.removeIf(pair -> ((JigsawPiece)pair.getFirst()).toString().equals(ModWorld.singleJigsawString("vampirism:village/" + name.replace("_zombie", "") + "/houses/hunter_trainer")));
        list.add(Pair.of((Object)ModWorld.singleJigsawPiece("village/" + name.replace("_zombie", "") + "/houses/hunter_trainer", processors.getOrDefault(name, new StructureProcessorList(Collections.emptyList()))), (Object)VampirismConfig.BALANCE.viHunterTrainerWeight.get()));
    }
}

