/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.action.vampire;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.action.vampire.VampireEntityAction;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.vector.Vector3d;

public class InvisibleEntityAction<T extends CreatureEntity>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public InvisibleEntityAction(EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public void activate(T entity) {
        ModParticles.spawnParticlesServer(entity.func_130014_f_(), (IParticleData)ParticleTypes.field_197627_t, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 60, 1.0, 1.0, 1.0, 0.0);
    }

    @Override
    public void deactivate(T entity) {
        ((IFactionEntity)entity).getRepresentingEntity().func_82142_c(false);
    }

    @Override
    public int getCooldown(int level) {
        return (Integer)VampirismConfig.BALANCE.eaInvisibilityCooldown.get() * 20;
    }

    @Override
    public int getDuration(int level) {
        return (Integer)VampirismConfig.BALANCE.eaInvisibilityDuration.get() * 20;
    }

    @Override
    public int getWeight(CreatureEntity entity) {
        double distanceToTarget = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()).func_178786_a(entity.func_70638_az().func_226277_ct_(), entity.func_70638_az().func_226278_cu_(), entity.func_70638_az().func_226281_cx_()).func_72433_c();
        if (distanceToTarget > 4.0) {
            return 3;
        }
        return 1;
    }

    @Override
    public void onUpdate(T entity, int duration) {
        if (!((IFactionEntity)entity).getRepresentingEntity().func_82150_aj()) {
            ((IFactionEntity)entity).getRepresentingEntity().func_82142_c(true);
        }
    }

    @Override
    public void updatePreAction(T entity, int duration) {
        if (duration % 5 == 0) {
            ModParticles.spawnParticlesServer(entity.func_130014_f_(), (IParticleData)ParticleTypes.field_197627_t, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 10, 1.0, 1.0, 1.0, 0.0);
        }
    }
}

