/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.entity.goals.AttackMeleeNoSunGoal;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.util.SharedMonsterAttributes;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConvertedCreatureEntity<T extends CreatureEntity>
extends VampireBaseEntity
implements IConvertedCreature<T>,
ISyncable {
    private static final Logger LOGGER = LogManager.getLogger(ConvertedCreatureEntity.class);
    private T entityCreature;
    private boolean entityChanged = false;
    private boolean canDespawn = false;
    @Nullable
    private ITextComponent name;

    public static boolean spawnPredicate(EntityType<? extends ConvertedCreatureEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return (iWorld.func_180495_p(blockPos.func_177977_b()).func_177230_c() == Blocks.field_196658_i || iWorld.func_180495_p(blockPos.func_177977_b()).func_177230_c() == ModBlocks.cursed_earth) && iWorld.func_226659_b_(blockPos, 0) > 8;
    }

    public ConvertedCreatureEntity(EntityType<? extends ConvertedCreatureEntity> type, World world) {
        super(type, world, false);
        this.enableImobConversion();
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.nil()) {
            this.entityCreature.func_82149_j((Entity)this);
            ((CreatureEntity)this.entityCreature).field_70166_s = this.field_70166_s;
            ((CreatureEntity)this.entityCreature).field_70167_r = this.field_70167_r;
            ((CreatureEntity)this.entityCreature).field_70169_q = this.field_70169_q;
            ((CreatureEntity)this.entityCreature).field_70759_as = this.field_70759_as;
            ((CreatureEntity)this.entityCreature).field_70127_C = this.field_70127_C;
            ((CreatureEntity)this.entityCreature).field_70126_B = this.field_70126_B;
            ((CreatureEntity)this.entityCreature).field_70758_at = this.field_70758_at;
            this.entityCreature.func_213317_d(this.func_213322_ci());
            ((CreatureEntity)this.entityCreature).field_70142_S = this.field_70142_S;
            ((CreatureEntity)this.entityCreature).field_70137_T = this.field_70137_T;
            ((CreatureEntity)this.entityCreature).field_70136_U = this.field_70136_U;
            ((CreatureEntity)this.entityCreature).field_70737_aN = this.field_70737_aN;
            ((CreatureEntity)this.entityCreature).field_70738_aO = this.field_70738_aO;
            ((CreatureEntity)this.entityCreature).field_70739_aP = this.field_70739_aP;
            ((CreatureEntity)this.entityCreature).field_70733_aJ = this.field_70733_aJ;
            ((CreatureEntity)this.entityCreature).field_70732_aI = this.field_70732_aI;
            ((CreatureEntity)this.entityCreature).field_184618_aE = this.field_184618_aE;
            ((CreatureEntity)this.entityCreature).field_70721_aZ = this.field_70721_aZ;
            ((CreatureEntity)this.entityCreature).field_184619_aG = this.field_184619_aG;
            ((CreatureEntity)this.entityCreature).field_70761_aq = this.field_70761_aq;
            ((CreatureEntity)this.entityCreature).field_70760_ar = this.field_70760_ar;
            ((CreatureEntity)this.entityCreature).field_70725_aQ = this.field_70725_aQ;
        }
        if (this.entityChanged) {
            this.updateEntityAttributes();
            this.entityChanged = false;
        }
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return super.func_213397_c(distanceToClosestPlayer) && this.canDespawn;
    }

    @Nullable
    public ItemEntity func_70099_a(ItemStack stack, float offsetY) {
        ItemStack actualDrop = stack;
        Item item = stack.func_77973_b();
        if (item.func_219971_r() && item.func_219967_s().func_221467_c()) {
            actualDrop = new ItemStack((IItemProvider)Items.field_151078_bh, stack.func_190916_E());
        }
        return super.func_70099_a(actualDrop, offsetY);
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        if (this.func_145818_k_()) {
            return super.func_200200_C_();
        }
        if (this.name == null) {
            this.name = new StringTextComponent(new TranslationTextComponent("entity.vampirism.vampire.name") + " " + (this.nil() ? super.func_200200_C_() : this.entityCreature.func_200200_C_()));
        }
        return this.name;
    }

    public T getOldCreature() {
        return this.entityCreature;
    }

    @Override
    public void loadUpdateFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("entity_old")) {
            this.setEntityCreature(EntityType.func_220330_a((CompoundNBT)nbt.func_74775_l("entity_old"), (World)this.func_130014_f_()).orElse(null));
        }
    }

    public void func_70642_aH() {
        if (!this.nil()) {
            this.entityCreature.func_70642_aH();
        }
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("entity_old")) {
            this.setEntityCreature(EntityType.func_220330_a((CompoundNBT)nbt.func_74775_l("entity_old"), (World)this.field_70170_p).orElse(null));
            if (this.nil()) {
                LOGGER.warn("Failed to create old entity {}. Maybe the entity does not exist anymore", (Object)nbt.func_74775_l("entity_old"));
            }
        } else {
            LOGGER.warn("Saved entity did not have a old entity");
        }
        if (nbt.func_74764_b("converted_canDespawn")) {
            this.canDespawn = nbt.func_74767_n("converted_canDespawn");
        }
    }

    public void func_213323_x_() {
        super.func_213323_x_();
        this.field_213326_aJ = this.entityCreature == null ? 0.5f : this.entityCreature.func_70047_e();
    }

    public void setCanDespawn() {
        this.canDespawn = true;
    }

    public void setEntityCreature(T creature) {
        if (creature == null && this.entityCreature != null) {
            this.entityChanged = true;
            this.entityCreature = null;
        } else if (creature != null && !creature.equals(this.entityCreature)) {
            this.entityCreature = creature;
            this.entityChanged = true;
            this.field_213325_aI = ((CreatureEntity)creature).field_213325_aI;
        }
        if (this.entityCreature != null && this.getConvertedHelper() == null) {
            this.entityCreature = null;
            LOGGER.warn("Cannot find converting handler for converted creature {} ({})", (Object)this, this.entityCreature);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.entityCreature == null) {
            LOGGER.debug("Setting dead, since creature is null");
            this.func_70106_y();
        }
    }

    @Nonnull
    public String toString() {
        return "[" + super.toString() + " representing " + this.entityCreature + "]";
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        this.writeOldEntityToNBT(nbt);
        nbt.func_74757_a("converter_canDespawn", this.canDespawn);
    }

    @Override
    public void writeFullUpdateToNBT(CompoundNBT nbt) {
        this.writeOldEntityToNBT(nbt);
    }

    @Nullable
    protected IConvertingHandler.IDefaultHelper getConvertedHelper() {
        if (this.nil()) {
            return null;
        }
        BiteableEntry biteableEntry = VampirismAPI.entityRegistry().getEntry((CreatureEntity)this.entityCreature);
        if (biteableEntry == null) {
            LOGGER.warn("Cannot find biteable entry for {}", this.entityCreature);
            return null;
        }
        IConvertingHandler handler = biteableEntry.convertingHandler;
        if (handler instanceof DefaultConvertingHandler) {
            return ((DefaultConvertingHandler)handler).getHelper();
        }
        return null;
    }

    @Override
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? ModEntities.converted_creature_imob : ModEntities.converted_creature;
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        if (this.entityCreature != null) {
            return this.entityCreature.func_213346_cF();
        }
        return super.func_184647_J();
    }

    protected boolean nil() {
        return this.entityCreature == null;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, CreatureEntity.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION)));
        this.field_70714_bg.func_75776_a(4, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new AttackMeleeNoSunGoal(this, 0.9, false));
        this.field_70728_aV = 2;
        this.field_70714_bg.func_75776_a(11, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(13, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(15, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
    }

    protected void updateEntityAttributes() {
        IConvertingHandler.IDefaultHelper helper = this.getConvertedHelper();
        if (helper != null) {
            this.func_110148_a(SharedMonsterAttributes.ATTACK_DAMAGE).func_111128_a(helper.getConvertedDMG((EntityType<? extends CreatureEntity>)this.entityCreature.func_200600_R()));
            this.func_110148_a(SharedMonsterAttributes.MAX_HEALTH).func_111128_a(helper.getConvertedMaxHealth((EntityType<? extends CreatureEntity>)this.entityCreature.func_200600_R()));
            this.func_110148_a(SharedMonsterAttributes.KNOCKBACK_RESISTANCE).func_111128_a(helper.getConvertedKnockbackResistance((EntityType<? extends CreatureEntity>)this.entityCreature.func_200600_R()));
            this.func_110148_a(SharedMonsterAttributes.MOVEMENT_SPEED).func_111128_a(helper.getConvertedSpeed((EntityType<? extends CreatureEntity>)this.entityCreature.func_200600_R()));
        } else {
            this.func_110148_a(SharedMonsterAttributes.MAX_HEALTH).func_111128_a(20.0);
            this.func_110148_a(SharedMonsterAttributes.ATTACK_DAMAGE).func_111128_a(0.0);
            this.func_110148_a(SharedMonsterAttributes.MOVEMENT_SPEED).func_111128_a(0.0);
        }
    }

    private void writeOldEntityToNBT(CompoundNBT nbt) {
        if (!this.nil()) {
            try {
                CompoundNBT entity = new CompoundNBT();
                ((CreatureEntity)this.entityCreature).field_70128_L = false;
                this.entityCreature.func_70039_c(entity);
                ((CreatureEntity)this.entityCreature).field_70128_L = true;
                nbt.func_218657_a("entity_old", (INBT)entity);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Failed to write old entity (%s) to NBT. If this happens more often please report this to the mod author.", this.entityCreature), (Throwable)e);
                this.setEntityCreature(null);
            }
        }
    }

    public static class IMob
    extends ConvertedCreatureEntity
    implements net.minecraft.entity.monster.IMob {
        public IMob(EntityType<? extends ConvertedCreatureEntity> type, World world) {
            super(type, world);
        }
    }
}

