/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.SharedMonsterAttributes;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ConvertedHorseEntity
extends HorseEntity
implements IConvertedCreature<HorseEntity> {
    protected boolean vulnerableToFire = true;
    private EnumStrength garlicCache = EnumStrength.NONE;
    private HorseEntity entityCreature;
    private boolean sundamageCache;
    private boolean dropSoul = false;
    @Nullable
    private ITextComponent name;

    public ConvertedHorseEntity(EntityType<? extends HorseEntity> p_i50238_1_, World p_i50238_2_) {
        super(p_i50238_1_, p_i50238_2_);
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (this.vulnerableToFire) {
            if (DamageSource.field_76372_a.equals(damageSource)) {
                return this.func_70097_a(VReference.VAMPIRE_IN_FIRE, this.calculateFireDamage(amount));
            }
            if (DamageSource.field_76370_b.equals(damageSource)) {
                return this.func_70097_a(VReference.VAMPIRE_ON_FIRE, this.calculateFireDamage(amount));
            }
        }
        return super.func_70097_a(damageSource, amount);
    }

    public boolean func_213397_c(double p_213397_1_) {
        return !this.func_110248_bS();
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return !strength.isStrongerThan(EnumStrength.NONE);
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.func_195064_c(new EffectInstance(Effects.field_76428_l, amt * 20));
    }

    public CreatureAttribute func_70668_bt() {
        return VReference.VAMPIRE_CREATURE_ATTRIBUTE;
    }

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        AttributeModifierMap.MutableAttribute mutableAttribute = AbstractHorseEntity.func_234237_fg_().func_233815_a_(SharedMonsterAttributes.ATTACK_DAMAGE, BalanceMobProps.mobProps.VAMPIRE_ATTACK_DAMAGE_PL);
        BalanceMobProps.mobProps.getClass();
        return mutableAttribute.func_233815_a_((Attribute)ModAttributes.sundamage, 7.0);
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(IWorld iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, Helper.getWorldKey(iWorld));
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(IWorld iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.field_70170_p.func_217381_Z());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.func_70644_a(ModEffects.sunscreen);
    }

    public ITextComponent func_200200_C_() {
        if (this.func_145818_k_()) {
            return super.func_200200_C_();
        }
        if (this.name == null) {
            this.name = new TranslationTextComponent("entity.vampirism.vampire").func_230529_a_((ITextComponent)new TranslationTextComponent("entity.horse"));
        }
        return this.name;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76364_f() instanceof CrossbowArrowEntity && Helper.isHunter(cause.func_76346_g())) {
            this.dropSoul = true;
        } else if (cause.func_76364_f() instanceof PlayerEntity && Helper.isHunter(cause.func_76364_f())) {
            ItemStack weapon = ((PlayerEntity)cause.func_76364_f()).func_184614_ca();
            if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof IVampireFinisher) {
                this.dropSoul = true;
            }
        } else {
            this.dropSoul = false;
        }
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.func_195064_c(new EffectInstance(Effects.field_76437_t, amt * 20));
        return true;
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    protected float calculateFireDamage(float amount) {
        return amount;
    }

    protected void func_70609_aI() {
        if (this.field_70725_aQ == 19 && !this.field_70170_p.field_72995_K && this.dropSoul && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.field_70170_p.func_217376_c((Entity)new SoulOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoulOrbEntity.VARIANT.VAMPIRE));
        }
        super.func_70609_aI();
    }

    public void func_70636_d() {
        if (this.field_70173_aa % 40 == 1) {
            this.isGettingGarlicDamage((IWorld)this.field_70170_p, true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage((IWorld)this.field_70170_p, true);
        }
        if (!this.field_70170_p.field_72995_K) {
            double dmg;
            if (this.isGettingSundamage((IWorld)this.field_70170_p) && this.field_70173_aa % 40 == 11 && (dmg = this.func_110148_a((Attribute)ModAttributes.sundamage).func_111126_e()) > 0.0) {
                this.func_70097_a(VReference.SUNDAMAGE, (float)dmg);
            }
            if (this.isGettingGarlicDamage((IWorld)this.field_70170_p) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((IWorld)this.field_70170_p), this.field_70173_aa);
            }
            if (this.func_70089_S() && this.func_70090_H()) {
                this.func_70050_g(300);
                if (this.field_70173_aa % 16 == 4) {
                    this.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, 0));
                }
            }
        }
        super.func_70636_d();
    }

    protected void func_230273_eI_() {
        this.func_110148_a(SharedMonsterAttributes.MAX_HEALTH).func_111128_a((double)this.func_110138_aP() * 1.5);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, CreatureEntity.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION)));
        this.field_70714_bg.func_75776_a(4, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70728_aV = 2;
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, false, false, false, null)));
    }

    public static class ConvertingHandler
    extends DefaultConvertingHandler<HorseEntity> {
        public ConvertingHandler() {
            super(null);
        }

        @Override
        public IConvertedCreature<HorseEntity> createFrom(HorseEntity entity) {
            ConvertedHorseEntity converted = new ConvertedHorseEntity(ModEntities.converted_horse, entity.field_70170_p);
            this.copyImportantStuff(converted, entity);
            converted.func_184221_a(MathHelper.func_180182_a((Random)converted.field_70146_Z));
            converted.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, 2));
            return converted;
        }

        protected void copyImportantStuff(ConvertedHorseEntity converted, HorseEntity entity) {
            CompoundNBT nbt = new CompoundNBT();
            entity.func_189511_e(nbt);
            converted.func_70020_e(nbt);
            converted.func_70606_j(converted.func_110138_aP() / 3.0f * 2.0f);
        }
    }
}

