/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.entity.factions.Faction;
import de.teamlapen.vampirism.entity.factions.PlayableFaction;
import de.teamlapen.vampirism.entity.factions.PredicateFaction;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.NonNullSupplier;

public class FactionRegistry
implements IFactionRegistry {
    private List<Faction> temp = new CopyOnWriteArrayList<Faction>();
    private Faction[] allFactions;
    private PlayableFaction[] playableFactions;
    private Map<Integer, Predicate<LivingEntity>> predicateMap = new HashMap<Integer, Predicate<LivingEntity>>();

    public void finish() {
        this.allFactions = this.temp.toArray(new Faction[0]);
        this.temp = null;
        ArrayList<PlayableFaction> temp2 = new ArrayList<PlayableFaction>();
        for (Faction allFaction : this.allFactions) {
            if (!(allFaction instanceof PlayableFaction)) continue;
            temp2.add((PlayableFaction)allFaction);
        }
        this.playableFactions = temp2.toArray(new PlayableFaction[0]);
    }

    @Override
    @Nullable
    public IFaction getFaction(Entity entity) {
        if (entity instanceof IFactionEntity) {
            return ((IFactionEntity)entity).getFaction();
        }
        if (entity instanceof PlayerEntity) {
            return VampirismAPI.getFactionPlayerHandler((PlayerEntity)entity).map(f -> Optional.ofNullable(f.getCurrentFaction())).orElse(Optional.empty()).orElse(null);
        }
        return null;
    }

    @Override
    @Nullable
    public IFaction getFactionByID(ResourceLocation id) {
        if (this.allFactions == null) {
            return null;
        }
        for (Faction f : this.allFactions) {
            if (!f.getID().equals((Object)id)) continue;
            return f;
        }
        return null;
    }

    public Faction[] getFactions() {
        return this.allFactions;
    }

    public PlayableFaction[] getPlayableFactions() {
        return this.playableFactions;
    }

    @Override
    public Predicate<LivingEntity> getPredicate(IFaction thisFaction, boolean ignoreDisguise) {
        return this.getPredicate(thisFaction, true, true, true, ignoreDisguise, null);
    }

    @Override
    public Predicate<LivingEntity> getPredicate(IFaction thisFaction, boolean player, boolean mob, boolean neutralPlayer, boolean ignoreDisguise, IFaction otherFaction) {
        Object predicate;
        int id;
        int key = 0;
        if (otherFaction != null) {
            id = otherFaction.hashCode();
            if (id > 63) {
                Biome.field_150586_aC.warn("Faction id over 64, predicates won't work");
            }
            key |= (id & 0x3F) << 10;
        }
        if (player) {
            key |= 0x200;
        }
        if (mob) {
            key |= 0x100;
        }
        if (neutralPlayer) {
            key |= 0x80;
        }
        if (ignoreDisguise) {
            key |= 0x40;
        }
        if ((id = thisFaction.hashCode()) > 64) {
            Biome.field_150586_aC.warn("Faction id over 64, predicates won't work");
        }
        if (this.predicateMap.containsKey(key |= id & 0x3F)) {
            predicate = this.predicateMap.get(key);
        } else {
            predicate = new PredicateFaction(thisFaction, player, mob, neutralPlayer, ignoreDisguise, otherFaction);
            this.predicateMap.put(key, (Predicate<LivingEntity>)predicate);
        }
        return predicate;
    }

    @Override
    public <T extends IFactionEntity> IFaction registerFaction(ResourceLocation id, Class<T> entityInterface, Color color, boolean hostileTowardsNeutral) {
        if (!UtilLib.isNonNull(id, entityInterface)) {
            throw new IllegalArgumentException("[Vampirism]Parameter for faction cannot be null");
        }
        Faction<T> f = new Faction<T>(id, entityInterface, color, hostileTowardsNeutral);
        this.addFaction(f);
        return f;
    }

    public <T extends IFactionPlayer> IPlayableFaction registerPlayableFaction(ResourceLocation id, Class<T> entityInterface, Color color, boolean hostileTowardsNeutral, NonNullSupplier<Capability<T>> playerCapabilitySupplier, int highestLevel) {
        if (!UtilLib.isNonNull(id, entityInterface, playerCapabilitySupplier)) {
            throw new IllegalArgumentException("[Vampirism]Parameters for faction cannot be null");
        }
        PlayableFaction<T> f = new PlayableFaction<T>(id, entityInterface, color, hostileTowardsNeutral, playerCapabilitySupplier, highestLevel);
        this.addFaction(f);
        return f;
    }

    private void addFaction(Faction faction) {
        if (this.temp == null) {
            throw new IllegalStateException(String.format("[Vampirism]You have to register factions during InterModEnqueueEvent. (%s)", faction.getID()));
        }
        this.temp.add(faction);
    }
}

