/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.entity.factions.Faction;
import java.awt.Color;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public class PlayableFaction<T extends IFactionPlayer>
extends Faction<T>
implements IPlayableFaction<T> {
    private final int highestLevel;
    private final NonNullSupplier<Capability<T>> playerCapabilitySupplier;
    private boolean renderLevel = true;

    PlayableFaction(ResourceLocation id, Class<T> entityInterface, Color color, boolean hostileTowardsNeutral, NonNullSupplier<Capability<T>> playerCapabilitySupplier, int highestLevel) {
        super(id, entityInterface, color, hostileTowardsNeutral);
        this.highestLevel = highestLevel;
        this.playerCapabilitySupplier = playerCapabilitySupplier;
    }

    @Override
    public Class<T> getFactionEntityInterface() {
        return super.getFactionEntityInterface();
    }

    @Override
    public Class<T> getFactionPlayerInterface() {
        return super.getFactionEntityInterface();
    }

    @Override
    public int getHighestReachableLevel() {
        return this.highestLevel;
    }

    @Override
    public LazyOptional<T> getPlayerCapability(PlayerEntity player) {
        return player.getCapability((Capability)this.playerCapabilitySupplier.get(), null);
    }

    @Override
    public boolean renderLevel() {
        return this.renderLevel;
    }

    @Override
    public PlayableFaction<T> setRenderLevel(boolean render) {
        this.renderLevel = render;
        return this;
    }

    @Override
    public String toString() {
        return "PlayableFaction{id='" + this.id + '\'' + '}';
    }
}

