/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import com.mojang.authlib.GameProfile;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.hunter.IAdvancedHunter;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.util.IPlayerFace;
import de.teamlapen.vampirism.util.PlayerSkinHelper;
import de.teamlapen.vampirism.util.SharedMonsterAttributes;
import de.teamlapen.vampirism.util.SupporterManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AdvancedHunterEntity
extends HunterBaseEntity
implements IAdvancedHunter,
IPlayerFace,
IEntityActionUser {
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(AdvancedHunterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(AdvancedHunterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(AdvancedHunterEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> TEXTURE = EntityDataManager.func_187226_a(AdvancedHunterEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private final int MAX_LEVEL = 1;
    private final int MOVE_TO_RESTRICT_PRIO = 3;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private GameProfile facePlayerProfile;
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    private final EntityActionTier entitytier;
    private boolean attack;
    @Nullable
    private ICaptureAttributes villageAttributes;

    public AdvancedHunterEntity(EntityType<? extends AdvancedHunterEntity> type, World world) {
        super(type, world, true);
        this.saveHome = true;
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.setDontDropEquipment();
        this.entitytier = EntityActionTier.High;
        this.entityclass = EntityClassType.getRandomClass(this.func_70681_au());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<AdvancedHunterEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag && this.func_184614_ca().func_190926_b()) {
            this.func_184609_a(Hand.MAIN_HAND);
        }
        return flag;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return super.func_213397_c(distanceToClosestPlayer) && this.isLookingForHome();
    }

    public boolean func_94059_bO() {
        return true;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    public int getHunterType() {
        return (Integer)this.func_184212_Q().func_187225_a(TYPE);
    }

    @Override
    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 1) {
                this.func_195064_c(new EffectInstance(Effects.field_76429_m, 1000000, 1));
            }
        }
    }

    @Override
    public int getMaxLevel() {
        return 1;
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        String senderName = (String)this.func_184212_Q().func_187225_a(NAME);
        return "none".equals(senderName) ? super.func_200200_C_() : new StringTextComponent(senderName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public GameProfile getPlayerFaceProfile() {
        if (this.facePlayerProfile == null) {
            String name = this.getTextureName();
            if (name == null) {
                return null;
            }
            this.facePlayerProfile = new GameProfile(null, name);
            PlayerSkinHelper.updateGameProfileAsync(this.facePlayerProfile, profile -> Minecraft.func_71410_x().execute(() -> {
                this.facePlayerProfile = profile;
            }));
        }
        return this.facePlayerProfile;
    }

    @Override
    @Nullable
    public String getTextureName() {
        String texture = (String)this.func_184212_Q().func_187225_a(TEXTURE);
        return "none".equals(texture) ? null : texture;
    }

    @Override
    public boolean isLookingForHome() {
        return this.getHome() == null;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    @Override
    public void func_70037_a(CompoundNBT tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74764_b("level")) {
            this.setLevel(tagCompund.func_74762_e("level"));
        }
        if (tagCompund.func_74764_b("type")) {
            this.func_184212_Q().func_187227_b(TYPE, (Object)tagCompund.func_74762_e("type"));
            this.func_184212_Q().func_187227_b(NAME, (Object)tagCompund.func_74779_i("name"));
            this.func_184212_Q().func_187227_b(TEXTURE, (Object)tagCompund.func_74779_i("texture"));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
        if (tagCompund.func_74764_b("attack")) {
            this.attack = tagCompund.func_74767_n("attack");
        }
    }

    @Override
    public void setCampArea(AxisAlignedBB box) {
        super.setHome(box);
        this.setMoveTowardsRestriction(3, true);
    }

    @Override
    public int suggestLevel(Difficulty d) {
        if (this.field_70146_Z.nextBoolean()) {
            return (int)((float)(d.avgPercLevel * 1) / 100.0f);
        }
        return this.field_70146_Z.nextInt(2);
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74768_a("type", this.getHunterType());
        nbt.func_74778_a("texture", (String)this.func_184212_Q().func_187225_a(TEXTURE));
        nbt.func_74778_a("name", (String)this.func_184212_Q().func_187225_a(NAME));
        nbt.func_74768_a("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
        nbt.func_74757_a("attack", this.attack);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 10 * (1 + this.getLevel());
    }

    @Override
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? ModEntities.advanced_hunter_imob : ModEntities.advanced_hunter;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        SupporterManager.Supporter supporter = SupporterManager.getInstance().getRandomHunter(this.field_70146_Z);
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
        this.func_184212_Q().func_187214_a(TYPE, (Object)supporter.typeId);
        this.func_184212_Q().func_187214_a(NAME, (Object)(supporter.senderName == null ? "none" : supporter.senderName));
        this.func_184212_Q().func_187214_a(TEXTURE, (Object)(supporter.textureName == null ? "none" : supporter.textureName));
    }

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        AttributeModifierMap.MutableAttribute mutableAttribute = VampirismEntity.getAttributeBuilder().func_233815_a_(SharedMonsterAttributes.MAX_HEALTH, (double)BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION).func_233815_a_(SharedMonsterAttributes.ATTACK_DAMAGE, (double)BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER);
        BalanceMobProps.mobProps.getClass();
        return mutableAttribute.func_233815_a_(SharedMonsterAttributes.MOVEMENT_SPEED, 0.285);
    }

    @Override
    public ActionHandlerEntity getActionHandler() {
        return this.entityActionHandler;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand p_184645_2_) {
        if (this.tryCureSanguinare(player)) {
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, p_184645_2_);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.7, 50));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 13.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, VampireBaseEntity.class, 17.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PatrollerEntity.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, Structure.field_236381_q_)));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getLevel(), 0);
        ModifiableAttributeInstance modifiableAttributeInstance = this.func_110148_a(SharedMonsterAttributes.MAX_HEALTH);
        double d = BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION;
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance.func_111128_a(d + 30.0 * (double)l);
        ModifiableAttributeInstance modifiableAttributeInstance2 = this.func_110148_a(SharedMonsterAttributes.ATTACK_DAMAGE);
        double d2 = BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER;
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance2.func_111128_a(d2 + 3.0 * (double)l);
    }

    @Override
    public void stopVillageAttackDefense() {
        this.func_200203_b(null);
        this.villageAttributes = null;
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    @Override
    public void attackVillage(ICaptureAttributes attributes) {
        this.villageAttributes = attributes;
        this.attack = true;
    }

    @Override
    public void defendVillage(ICaptureAttributes attributes) {
        this.villageAttributes = attributes;
        this.attack = false;
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    @Nullable
    public AxisAlignedBB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    public static class IMob
    extends AdvancedHunterEntity
    implements net.minecraft.entity.monster.IMob {
        public IMob(EntityType<? extends AdvancedHunterEntity> type, World world) {
            super(type, world);
        }
    }
}

