/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.VampirismEntity;
import java.util.Random;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class HunterBaseEntity
extends VampirismEntity
implements IHunterMob {
    private final boolean countAsMonster;
    protected final int MOVE_TO_RESTRICT_PRIO = 3;

    public static boolean spawnPredicateHunter(EntityType<? extends HunterBaseEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && HunterBaseEntity.spawnPredicateCanSpawn(entityType, world, spawnReason, blockPos, random);
    }

    public HunterBaseEntity(EntityType<? extends HunterBaseEntity> type, World world, boolean countAsMonster) {
        super(type, world);
        this.countAsMonster = countAsMonster;
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
    }

    public EntityClassification getClassification(boolean forSpawnCount) {
        if (forSpawnCount && this.countAsMonster) {
            return EntityClassification.MONSTER;
        }
        return super.getClassification(forSpawnCount);
    }

    protected boolean tryCureSanguinare(PlayerEntity entity) {
        if (!this.field_70170_p.field_72995_K && entity.func_70644_a(ModEffects.sanguinare)) {
            entity.func_195063_d(ModEffects.sanguinare);
            entity.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.hunter.cured_sanguinare"), Util.field_240973_b_);
            return true;
        }
        return false;
    }

    public void makeCampHunter(BlockPos pos) {
        super.setHome(new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)).func_186662_g(10.0));
        this.setMoveTowardsRestriction(3, true);
    }
}

