/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.vampire.IBasicVampire;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.goals.AttackMeleeNoSunGoal;
import de.teamlapen.vampirism.entity.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.goals.BiteNearbyEntityVampireGoal;
import de.teamlapen.vampirism.entity.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.goals.FollowAdvancedVampireGoal;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.goals.MoveToBiteableVampireGoal;
import de.teamlapen.vampirism.entity.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.util.SharedMonsterAttributes;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreakDoorGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class BasicVampireEntity
extends VampireBaseEntity
implements IBasicVampire,
IEntityActionUser {
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(BasicVampireEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final int MAX_LEVEL = 2;
    private final int ANGRY_TICKS_PER_ATTACK = 120;
    private int bloodtimer = 100;
    private AdvancedVampireEntity advancedLeader = null;
    private int angryTimer = 0;
    private Goal tasks_avoidHunter;
    @Nullable
    private ICaptureAttributes villageAttributes;
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    private final EntityActionTier entitytier;
    private boolean attack;

    public BasicVampireEntity(EntityType<? extends BasicVampireEntity> type, World world) {
        super(type, world, true);
        this.canSuckBloodFromPlayer = true;
        this.hasArms = true;
        this.setSpawnRestriction(VampireBaseEntity.SpawnRestriction.SPECIAL);
        this.entitytier = EntityActionTier.Medium;
        this.entityclass = EntityClassType.getRandomClass(this.func_70681_au());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<BasicVampireEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float p_70097_2_) {
        boolean flag = super.func_70097_a(damageSource, p_70097_2_);
        if (flag) {
            this.angryTimer += 120;
        }
        return flag;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod) {
        super.drinkBlood(amt, saturationMod);
        boolean dedicated = ServerLifecycleHooks.getCurrentServer().func_71262_S();
        this.bloodtimer += amt * 40 + this.func_70681_au().nextInt(1000) * (dedicated ? 2 : 1);
    }

    @Override
    public void attackVillage(ICaptureAttributes totem) {
        this.field_70714_bg.func_85156_a(this.tasks_avoidHunter);
        this.villageAttributes = totem;
        this.attack = true;
    }

    @Override
    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 2) {
                this.func_195064_c(new EffectInstance(Effects.field_76429_m, 1000000, 1));
            }
            if (level == 1) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
            } else {
                this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public int getMaxLevel() {
        return 2;
    }

    public int func_70627_aG() {
        return 600;
    }

    @Override
    public boolean isIgnoringSundamage() {
        float health = this.func_110143_aJ() / this.func_110138_aP();
        return super.isIgnoringSundamage() || this.angryTimer > 0 && health < 0.7f || health < 0.3f;
    }

    @Override
    public void defendVillage(ICaptureAttributes totem) {
        this.field_70714_bg.func_85156_a(this.tasks_avoidHunter);
        this.villageAttributes = totem;
        this.attack = false;
    }

    @Override
    public void func_70037_a(CompoundNBT tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74764_b("level")) {
            this.setLevel(tagCompund.func_74762_e("level"));
        }
        if (tagCompund.func_74764_b("attack")) {
            this.attack = tagCompund.func_74767_n("attack");
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.advancedLeader != null) {
            this.advancedLeader.decreaseFollowerCount();
        }
    }

    @Override
    public int suggestLevel(Difficulty d) {
        switch (this.field_70146_Z.nextInt(5)) {
            case 0: {
                return (int)((float)d.minPercLevel / 100.0f * 2.0f);
            }
            case 1: {
                return (int)((float)d.avgPercLevel / 100.0f * 2.0f);
            }
            case 2: {
                return (int)((float)d.maxPercLevel / 100.0f * 2.0f);
            }
        }
        return this.field_70146_Z.nextInt(3);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.advancedLeader != null && !this.advancedLeader.func_70089_S()) {
            this.advancedLeader = null;
        }
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodtimer == 0;
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74757_a("attack", this.attack);
        nbt.func_74768_a("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
    }

    @Override
    protected float calculateFireDamage(float amount) {
        float protectionMod = 1.0f;
        EffectInstance protection = this.func_70660_b(ModEffects.fire_protection);
        if (protection != null) {
            protectionMod = 1.0f / (2.0f + (float)protection.func_76458_c());
        }
        double d = amount * protectionMod;
        BalanceMobProps.mobProps.getClass();
        return (float)(d * 2.0) * ((float)this.getLevel() * 0.5f + 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.entity_vampire_scream;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 6 + this.getLevel();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
    }

    @Nullable
    public AdvancedVampireEntity getAdvancedLeader() {
        return this.advancedLeader;
    }

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        AttributeModifierMap.MutableAttribute mutableAttribute = VampireBaseEntity.getAttributeBuilder().func_233815_a_(SharedMonsterAttributes.MAX_HEALTH, 1.0);
        BalanceMobProps.mobProps.getClass();
        return mutableAttribute.func_233815_a_(SharedMonsterAttributes.ATTACK_DAMAGE, 3.0).func_233815_a_(SharedMonsterAttributes.MOVEMENT_SPEED, BalanceMobProps.mobProps.VAMPIRE_SPEED);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new BreakDoorGoal((MobEntity)this, difficulty -> difficulty == net.minecraft.world.Difficulty.HARD));
        this.tasks_avoidHunter = new AvoidEntityGoal((CreatureEntity)this, CreatureEntity.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION));
        this.field_70714_bg.func_75776_a(2, this.tasks_avoidHunter);
        this.field_70714_bg.func_75776_a(2, new RestrictSunVampireGoal<BasicVampireEntity>(this));
        this.field_70714_bg.func_75776_a(3, new FleeSunVampireGoal<BasicVampireEntity>(this, 0.9, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackMeleeNoSunGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, new BiteNearbyEntityVampireGoal<BasicVampireEntity>(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowAdvancedVampireGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(7, new MoveToBiteableVampireGoal<BasicVampireEntity>(this, 0.75));
        this.field_70714_bg.func_75776_a(8, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 0.6, true, 600, () -> false));
        this.field_70714_bg.func_75776_a(9, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtClosestVisibleGoal((MobEntity)this, PlayerEntity.class, 20.0f, 0.6f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, HunterBaseEntity.class, 17.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new AttackVillageGoal<BasicVampireEntity>(this));
        this.field_70715_bh.func_75776_a(4, new DefendVillageGoal<BasicVampireEntity>(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PatrollerEntity.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, Structure.field_236381_q_)));
    }

    @Override
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? ModEntities.vampire_imob : ModEntities.vampire;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    public ActionHandlerEntity getActionHandler() {
        return this.entityActionHandler;
    }

    public void setAdvancedLeader(@Nullable AdvancedVampireEntity advancedLeader) {
        this.advancedLeader = advancedLeader;
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    @Nullable
    public AxisAlignedBB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.bloodtimer > 0) {
            --this.bloodtimer;
        }
        if (this.angryTimer > 0) {
            --this.angryTimer;
        }
        if (this.field_70173_aa % 9 == 3 && this.func_70644_a(Effects.field_76426_n)) {
            EffectInstance fireResistance = this.func_184596_c(Effects.field_76426_n);
            assert (fireResistance != null);
            this.func_70688_c(fireResistance);
            this.func_195064_c(new EffectInstance(ModEffects.fire_protection, fireResistance.func_76459_b(), fireResistance.func_76458_c()));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    @Override
    public void stopVillageAttackDefense() {
        this.func_200203_b(null);
        this.villageAttributes = null;
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getLevel(), 0);
        ModifiableAttributeInstance modifiableAttributeInstance = this.func_110148_a(SharedMonsterAttributes.MAX_HEALTH);
        BalanceMobProps.mobProps.getClass();
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance.func_111128_a(30.0 + 3.0 * (double)l);
        ModifiableAttributeInstance modifiableAttributeInstance2 = this.func_110148_a(SharedMonsterAttributes.ATTACK_DAMAGE);
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance2.func_111128_a(3.0 + BalanceMobProps.mobProps.VAMPIRE_ATTACK_DAMAGE_PL * (double)l);
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    public static class IMob
    extends BasicVampireEntity
    implements net.minecraft.entity.monster.IMob {
        public IMob(EntityType<? extends BasicVampireEntity> type, World world) {
            super(type, world);
        }
    }
}

