/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.potion.blood.BloodPotions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.IContainerFactory;

public class BloodPotionTableContainer
extends InventoryContainer {
    private static final InventoryContainer.SelectorInfo[] SELECTOR_INFOS = new InventoryContainer.SelectorInfo[]{new InventoryContainer.SelectorInfo(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.vampire_blood_bottle}), 115, 55, 1), new InventoryContainer.SelectorInfo(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.vampire_blood_bottle}), 137, 55, 1), new InventoryContainer.SelectorInfo(Ingredient.func_199805_a(ModTags.Items.GARLIC), 126, 14), new InventoryContainer.SelectorInfo(BloodPotionTableContainer.getSpecialIngredient(ModTags.Items.GARLIC, new Item[]{ModItems.vampire_blood_bottle}), 101, 22, true)};
    private final HunterPlayer hunterPlayer;
    private final int max_crafting_time;
    private final boolean portable;
    private int craftingTimer = 0;
    private int prevCraftingTimer = 0;

    public BloodPotionTableContainer(int id, PlayerInventory playerInventory, IWorldPosCallable worldPosIn) {
        super(ModContainer.blood_potion_table, id, playerInventory, worldPosIn, (IInventory)new Inventory(SELECTOR_INFOS.length), SELECTOR_INFOS);
        int crafting_time;
        this.hunterPlayer = HunterPlayer.get(playerInventory.field_70458_d);
        this.portable = (Boolean)this.worldPos.func_221485_a((world, blockPos) -> !((Object)((Object)ModBlocks.blood_potion_table)).equals(world.func_180495_p(blockPos).func_177230_c()), (Object)true);
        int n = crafting_time = this.portable ? 500 : 250;
        if (this.hunterPlayer.getSkillHandler().isSkillEnabled(HunterSkills.blood_potion_faster_crafting)) {
            crafting_time /= 2;
        }
        this.max_crafting_time = crafting_time;
        this.addPlayerSlots(playerInventory);
    }

    @Deprecated
    public BloodPotionTableContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public boolean canCurrentlyStartCrafting() {
        return this.craftingTimer <= 0 && this.areRequirementsMet();
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.portable || BloodPotionTableContainer.func_216963_a((IWorldPosCallable)this.worldPos, (PlayerEntity)playerIn, (Block)ModBlocks.blood_potion_table);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener icontainerlistener : this.field_75149_d) {
            if (this.prevCraftingTimer == this.craftingTimer) continue;
            icontainerlistener.func_71112_a((Container)this, 0, this.craftingTimer);
        }
        this.prevCraftingTimer = this.craftingTimer;
    }

    public float getCraftingPercentage() {
        return this.craftingTimer == 0 ? 0.0f : 1.0f - (float)this.craftingTimer / (float)this.max_crafting_time;
    }

    private static Ingredient getSpecialIngredient(ITag<Item> tag, Item ... items) {
        int i;
        List d = tag.func_230236_b_();
        ItemStack[] stacks = new ItemStack[d.size() + items.length];
        for (i = 0; i < items.length; ++i) {
            stacks[i] = new ItemStack((IItemProvider)items[i]);
        }
        for (i = 0; i < d.size(); ++i) {
            stacks[i + items.length] = new ItemStack((IItemProvider)d.get(i));
        }
        return Ingredient.func_193369_a((ItemStack[])stacks);
    }

    public IWorldPosCallable getWorldPosCallable() {
        return this.worldPos;
    }

    @Override
    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.func_130014_f_().field_72995_K) {
            this.func_193327_a(playerIn, playerIn.field_70170_p, this.inventory);
        }
    }

    public void onCraftingClicked() {
        if (this.canCurrentlyStartCrafting()) {
            this.craftingTimer = this.max_crafting_time;
        }
    }

    public void tick() {
        if (this.craftingTimer > 0) {
            --this.craftingTimer;
            if (this.craftingTimer == 0) {
                this.onCraftingTimerFinished();
            } else if (this.craftingTimer % 5 == 0 && !this.areRequirementsMet()) {
                this.craftingTimer = 0;
            }
        }
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack itemstackCopy = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstackCopy = itemstack1.func_77946_l();
            if (index >= 4) {
                if (index < 31) {
                    if (!this.func_75135_a(itemstack1, 0, 4, false)) {
                        return ItemStack.field_190927_a;
                    }
                    if (!this.func_75135_a(itemstack1, 31, 40, true)) {
                        return ItemStack.field_190927_a;
                    }
                } else if (!this.func_75135_a(itemstack1, 0, 31, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(itemstack1, 4, 40, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstackCopy.func_190916_E() == itemstack1.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerEntity, itemstack1);
        }
        return itemstackCopy;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id == 0 && data >= 0 && data <= this.max_crafting_time) {
            this.craftingTimer = data;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public List<ITextComponent> getLocalizedCraftingHint() {
        ItemStack extra = this.inventory.func_70301_a(3);
        if (extra.func_190926_b()) {
            return null;
        }
        if (!this.hunterPlayer.getSkillHandler().isSkillEnabled(HunterSkills.blood_potion_category_hint)) {
            return null;
        }
        List<ITextComponent> hints = BloodPotions.getLocalizedCategoryHint(extra);
        if (hints.isEmpty()) {
            hints.add((ITextComponent)new TranslationTextComponent("text.vampirism.blood_potion.any_effect"));
        } else {
            hints.add(0, (ITextComponent)new TranslationTextComponent("text.vampirism.blood_potion.might_cause"));
        }
        return hints;
    }

    private boolean areRequirementsMet() {
        ItemStack garlic = this.inventory.func_70301_a(2);
        if (garlic.func_190926_b() || !ModTags.Items.GARLIC.func_230235_a_((Object)garlic.func_77973_b())) {
            return false;
        }
        boolean bottle = false;
        ItemStack bottle1 = this.inventory.func_70301_a(0);
        ItemStack bottle2 = this.inventory.func_70301_a(1);
        if (!bottle1.func_190926_b() && bottle1.func_77973_b().equals((Object)ModItems.vampire_blood_bottle)) {
            bottle = true;
        }
        if (!bottle2.func_190926_b() && bottle2.func_77973_b().equals((Object)ModItems.vampire_blood_bottle)) {
            bottle = true;
        }
        return bottle;
    }

    private void onCraftingTimerFinished() {
        if (!this.areRequirementsMet()) {
            return;
        }
        ItemStack extraItem = this.inventory.func_70301_a(3);
        if (!extraItem.func_190926_b()) {
            extraItem = extraItem.func_77946_l();
            extraItem.func_190920_e(1);
            this.inventory.func_70298_a(3, 1);
        }
        this.inventory.func_70298_a(2, 1);
        ItemStack bottle1 = this.inventory.func_70301_a(0);
        ItemStack bottle2 = this.inventory.func_70301_a(1);
        if (!bottle1.func_190926_b() && bottle1.func_77973_b().equals((Object)ModItems.vampire_blood_bottle)) {
            bottle1 = new ItemStack((IItemProvider)ModItems.blood_potion);
            BloodPotions.chooseAndAddEffects(bottle1, this.hunterPlayer, extraItem);
        }
        if (!bottle2.func_190926_b() && bottle2.func_77973_b().equals((Object)ModItems.vampire_blood_bottle)) {
            bottle2 = new ItemStack((IItemProvider)ModItems.blood_potion);
            BloodPotions.chooseAndAddEffects(bottle2, this.hunterPlayer, extraItem);
        }
        this.inventory.func_70299_a(0, bottle1);
        this.inventory.func_70299_a(1, bottle2);
        this.hunterPlayer.getRepresentingPlayer().func_195066_a(ModStats.blood_table);
    }

    public static class Factory
    implements IContainerFactory<BloodPotionTableContainer> {
        public BloodPotionTableContainer create(int windowId, PlayerInventory inv, PacketBuffer data) {
            BlockPos pos = data.func_179259_c();
            return new BloodPotionTableContainer(windowId, inv, IWorldPosCallable.func_221488_a((World)inv.field_70458_d.field_70170_p, (BlockPos)pos));
        }
    }
}

