/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrossbowArrowItem
extends VampirismItem
implements IVampirismCrossbowArrow<CrossbowArrowEntity> {
    private static final String regName = "crossbow_arrow";
    private final EnumArrowType type;

    public CrossbowArrowItem(EnumArrowType type) {
        super("crossbow_arrow_" + type.getName(), new Item.Properties().func_200916_a(VampirismMod.creativeTab));
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> textComponents, ITooltipFlag tooltipFlag) {
        if (this.type != EnumArrowType.NORMAL) {
            textComponents.add((ITextComponent)new TranslationTextComponent(this.type == EnumArrowType.VAMPIRE_KILLER ? "item.vampirism.crossbow_arrow_vampire_killer.tooltip" : "item.vampirism.crossbow_arrow_spitfire.tooltip"));
        }
    }

    @Override
    public CrossbowArrowEntity createEntity(ItemStack stack, World world, PlayerEntity player, double heightOffset, double centerOffset, boolean rightHand) {
        CrossbowArrowEntity entity = CrossbowArrowEntity.createWithShooter(world, (LivingEntity)player, heightOffset, centerOffset, rightHand, stack);
        entity.func_70239_b(this.type.baseDamage * (Double)VampirismConfig.BALANCE.crossbowDamageMult.get());
        if (this.type == EnumArrowType.SPITFIRE) {
            entity.func_70015_d(100);
        }
        return entity;
    }

    public EnumArrowType getType() {
        return this.type;
    }

    @Override
    public boolean isCanBeInfinite() {
        return this.type != EnumArrowType.VAMPIRE_KILLER && this.type != EnumArrowType.SPITFIRE;
    }

    @Override
    public void onHitBlock(ItemStack arrow, BlockPos blockPos, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        CrossbowArrowEntity entity = (CrossbowArrowEntity)arrowEntity;
        if (this.type == EnumArrowType.SPITFIRE) {
            for (int dx = -1; dx < 2; ++dx) {
                for (int dy = -2; dy < 2; ++dy) {
                    for (int dz = -1; dz < 2; ++dz) {
                        BlockPos pos = blockPos.func_177982_a(dx, dy, dz);
                        BlockState blockState = entity.func_130014_f_().func_180495_p(pos);
                        if (!blockState.func_185904_a().func_76222_j() || !entity.func_130014_f_().func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)entity.func_130014_f_(), pos.func_177977_b(), Direction.UP) || entity.getRNG().nextInt(4) == 0) continue;
                        entity.func_130014_f_().func_175656_a(pos, ModBlocks.alchemical_fire.func_176223_P());
                    }
                }
            }
        }
    }

    @Override
    public void onHitEntity(ItemStack arrow, LivingEntity entity, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        float max;
        if (this.type == EnumArrowType.VAMPIRE_KILLER && entity instanceof IVampireMob && (max = entity.func_110138_aP()) < (float)((Integer)VampirismConfig.BALANCE.arrowVampireKillerMaxHealth.get()).intValue()) {
            entity.func_70097_a(DamageSource.func_76353_a((AbstractArrowEntity)((AbstractArrowEntity)arrowEntity), (Entity)shootingEntity), max);
        }
    }

    public static enum EnumArrowType implements IStringSerializable
    {
        NORMAL("normal", 2.0, 0xFFFFFF),
        VAMPIRE_KILLER("vampire_killer", 0.5, 7995507),
        SPITFIRE("spitfire", 0.5, 0xFF2211);

        public final int color;
        final String name;
        final double baseDamage;

        private EnumArrowType(String name, double baseDamage, int color) {
            this.name = name;
            this.baseDamage = baseDamage;
            this.color = color;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getName() {
            return this.func_176610_l();
        }
    }
}

