/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PureBloodItem
extends VampirismItem {
    public static final int COUNT = 5;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String name = "pure_blood";
    private final int level;

    public static Item getBloodItemForLevel(int level) {
        switch (level) {
            case 0: {
                return ModItems.pure_blood_0;
            }
            case 1: {
                return ModItems.pure_blood_1;
            }
            case 2: {
                return ModItems.pure_blood_2;
            }
            case 3: {
                return ModItems.pure_blood_3;
            }
            case 4: {
                return ModItems.pure_blood_4;
            }
        }
        LOGGER.warn("Pure blood of level {} does not exist", (Object)level);
        return ModItems.pure_blood_4;
    }

    public PureBloodItem(int level) {
        super("pure_blood_" + level, new Item.Properties().func_200916_a(VampirismMod.creativeTab));
        this.level = level;
        this.setTranslation_key(name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.vampirism.pure_blood.purity").func_230529_a_((ITextComponent)new StringTextComponent(": " + (this.level + 1) + "/" + 5)).func_240699_a_(TextFormatting.RED));
    }

    public ITextComponent getCustomName() {
        return new TranslationTextComponent(this.func_195935_o()).func_230529_a_((ITextComponent)new StringTextComponent(" " + (this.level + 1)));
    }
}

