/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IFactionSlayerItem;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.VampirismItemWeapon;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class VampirismHunterWeapon
extends VampirismItemWeapon
implements IFactionLevelItem,
IFactionSlayerItem,
IVampireFinisher {
    public VampirismHunterWeapon(String regName, IItemTier material, int attackDamage, float attackSpeed, Item.Properties props) {
        super(regName, material, attackDamage, attackSpeed, props);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.getUsingFaction(stack) != null || this.getMinLevel(stack) > 0 || this.getRequiredSkill(stack) != null) {
            PlayerEntity player = VampirismMod.proxy.getClientPlayer();
            TextFormatting color = player != null && player.func_70089_S() && Helper.canUseFactionItem(stack, this, FactionPlayerHandler.get(player)) ? TextFormatting.BLUE : TextFormatting.DARK_RED;
            IPlayableFaction f = this.getUsingFaction(stack);
            tooltip.add((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)(f == null ? new TranslationTextComponent("text.vampirism.all") : f.getNamePlural())).func_230529_a_((ITextComponent)new StringTextComponent("@" + this.getMinLevel(stack))).func_240699_a_(color));
            ISkill reqSkill = this.getRequiredSkill(stack);
            if (reqSkill != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("text.vampirism.required_skill", new Object[]{new TranslationTextComponent(reqSkill.getTranslationKey())}).func_240699_a_(color));
            }
        }
    }

    @Override
    @Nullable
    public ISkill getRequiredSkill(@Nonnull ItemStack stack) {
        return null;
    }

    @Override
    public IFaction getSlayedFaction() {
        return VReference.VAMPIRE_FACTION;
    }

    public IPlayableFaction getUsingFaction(@Nonnull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }
}

