/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide;

import com.google.common.collect.Maps;
import de.maxanier.guideapi.api.IGuideBook;
import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.BookBinder;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.PageHelper;
import de.maxanier.guideapi.category.CategoryItemStack;
import de.maxanier.guideapi.page.PageImage;
import de.maxanier.guideapi.page.PageText;
import de.maxanier.guideapi.page.PageTextImage;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.AltarPillarBlock;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.BloodBottleItem;
import de.teamlapen.vampirism.modcompat.guide.EntryText;
import de.teamlapen.vampirism.modcompat.guide.GuideHelper;
import de.teamlapen.vampirism.modcompat.guide.ItemInfoBuilder;
import de.teamlapen.vampirism.modcompat.guide.pages.PageHolderWithLinks;
import de.teamlapen.vampirism.modcompat.guide.pages.PageTable;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.player.vampire.VampireLevelingConf;
import java.awt.Color;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@de.maxanier.guideapi.api.GuideBook
public class GuideBook
implements IGuideBook {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String IMAGE_BASE = "vampirismguide:textures/images/";
    private static Book guideBook;
    private static final Map<ResourceLocation, EntryAbstract> links;

    static void buildCategories(List<CategoryAbstract> categories) {
        LOGGER.debug("Building content");
        long start = System.currentTimeMillis();
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildOverview(), GuideBook.translate("guide.vampirism.overview.title", new Object[0]), new ItemStack((IItemProvider)ModItems.vampire_fang)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildVampire(), GuideBook.translate("guide.vampirism.vampire.title", new Object[0]), BloodBottleItem.getStackWithDamage(9)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildHunter(), GuideBook.translate("guide.vampirism.hunter.title", new Object[0]), new ItemStack((IItemProvider)ModItems.human_heart)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildCreatures(), GuideBook.translate("guide.vampirism.entity.title", new Object[0]), new ItemStack((IItemProvider)Items.field_196186_dz)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildWorld(), GuideBook.translate("guide.vampirism.world.title", new Object[0]), new ItemStack((IItemProvider)ModBlocks.cursed_earth)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildItems(), GuideBook.translate("guide.vampirism.items.title", new Object[0]), new ItemStack((IItemProvider)Items.field_151034_e)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildBlocks(), GuideBook.translate("guide.vampirism.blocks.title", new Object[0]), new ItemStack((IItemProvider)ModBlocks.castle_block_dark_brick)));
        LOGGER.debug("Built content in {} ms", (Object)(System.currentTimeMillis() - start));
    }

    @Nullable
    public static EntryAbstract getLinkedEntry(ResourceLocation location) {
        return links.get(location);
    }

    private static Map<ResourceLocation, EntryAbstract> buildOverview() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.overview.";
        ArrayList<IPage> introPages = new ArrayList<IPage>();
        introPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "intro.text", new Object[0])));
        entries.put(new ResourceLocation(base + "intro"), (EntryAbstract)new EntryText(introPages, GuideBook.translate(base + "intro", new Object[0])));
        ArrayList<IPage> gettingStartedPages = new ArrayList<IPage>();
        Object p = new PageText((ITextProperties)GuideBook.translate(base + "getting_started.text", new Object[0]));
        p = new PageHolderWithLinks((IPage)p).addLink("guide.vampirism.vampire.getting_started").addLink("guide.vampirism.hunter.getting_started");
        gettingStartedPages.add((IPage)p);
        entries.put(new ResourceLocation(base + "getting_started"), (EntryAbstract)new EntryText(gettingStartedPages, GuideBook.translate(base + "getting_started", new Object[0])));
        ArrayList<IPage> configPages = new ArrayList<IPage>();
        configPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "config.text", new Object[0])));
        configPages.addAll(PageHelper.pagesForLongText((ITextProperties)ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{GuideBook.translate(base + "config.general.text", new Object[0]), GuideBook.translate(base + "config.general.examples", new Object[0])})));
        configPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "config.balance.text", new Object[0])));
        entries.put(new ResourceLocation(base + "config"), (EntryAbstract)new EntryText(configPages, GuideBook.translate(base + "config", new Object[0])));
        ArrayList<IPage> troublePages = new ArrayList<IPage>();
        troublePages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "trouble.text", new Object[0])));
        GuideHelper.addLinks(troublePages, new PageHolderWithLinks.URLLink(GuideBook.translate(base + "trouble", new Object[0]), URI.create("https://github.com/TeamLapen/Vampirism/wiki/Troubleshooting")));
        entries.put(new ResourceLocation(base + "trouble"), (EntryAbstract)new EntryText(troublePages, GuideBook.translate(base + "trouble", new Object[0])));
        ArrayList<IPage> devPages = new ArrayList<IPage>();
        PageHolderWithLinks.URLLink helpLink = new PageHolderWithLinks.URLLink((ITextComponent)new StringTextComponent("How to help"), URI.create("https://github.com/TeamLapen/Vampirism/wiki#how-you-can-help"));
        devPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "dev.text", new Object[0])), helpLink));
        entries.put(new ResourceLocation(base + "dev"), (EntryAbstract)new EntryText(devPages, GuideBook.translate(base + "dev", new Object[0])));
        ArrayList<IPage> supportPages = new ArrayList<IPage>();
        supportPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "support.text", new Object[0])));
        PageHolderWithLinks.URLLink linkCurseForge = new PageHolderWithLinks.URLLink((ITextComponent)new StringTextComponent("CurseForge"), URI.create("https://minecraft.curseforge.com/projects/vampirism-become-a-vampire"));
        GuideHelper.addLinks(supportPages, linkCurseForge, new ResourceLocation(base + "dev"));
        entries.put(new ResourceLocation(base + "support"), (EntryAbstract)new EntryText(supportPages, GuideBook.translate(base + "support", new Object[0])));
        ArrayList<IPage> creditsPages = new ArrayList<IPage>();
        String lang = VampLib.proxy.getActiveLanguage();
        String credits = "\u00a7lDeveloper:\u00a7r\nMaxanier\nChaterpaul\n\u00a7lThanks to:\u00a7r\nMistadon\nwildbill22\n1LiterZinalco\nAlis\ndimensionpainter\nS_olace\nPiklach\n\n\u00a7lTranslators:\u00a7r\n\u00a7b" + lang + "\u00a7r\n" + GuideBook.translate("text.vampirism.translators", new Object[0]);
        creditsPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(credits, new Object[0])));
        entries.put(new ResourceLocation(base + "credits"), (EntryAbstract)new EntryText(creditsPages, GuideBook.translate(base + "credits", new Object[0])));
        links.putAll(entries);
        return entries;
    }

    private static String loc(Block b) {
        return UtilLib.translate(b.func_149739_a(), new Object[0]);
    }

    private static String loc(Item i) {
        return UtilLib.translate(i.func_77658_a(), new Object[0]);
    }

    private static Map<ResourceLocation, EntryAbstract> buildVampire() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.vampire.";
        ArrayList<IPage> gettingStarted = new ArrayList<IPage>();
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "getting_started.become", new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "getting_started.as_vampire", new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "getting_started.zombie", new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "getting_started.blood", new TranslationTextComponent(ModKeys.getKeyBinding(ModKeys.KEY.SUCK).func_197982_m()))));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{GuideBook.translate(base + "getting_started.level", new Object[0]), GuideBook.translate(base + "getting_started.level2", new Object[0])})));
        entries.put(new ResourceLocation(base + "getting_started"), (EntryAbstract)new EntryText(gettingStarted, GuideBook.translate(base + "getting_started", new Object[0])));
        ArrayList<IPage> bloodPages = new ArrayList<IPage>();
        bloodPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "blood.text", GuideBook.loc(ModItems.blood_bottle), GuideBook.loc(Items.field_151069_bo))));
        bloodPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "blood.storage", GuideBook.loc((Block)ModBlocks.blood_container))), new ResourceLocation("guide.vampirism.blocks.blood_container")));
        bloodPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "blood.biteable_creatures", new Object[0])), new PageHolderWithLinks.URLLink((ITextComponent)new StringTextComponent("Biteable Creatures"), URI.create("https://github.com/TeamLapen/Vampirism/wiki/Biteable-Creatures"))));
        entries.put(new ResourceLocation(base + "blood"), (EntryAbstract)new EntryText(bloodPages, GuideBook.translate(base + "blood", new Object[0])));
        VampireLevelingConf levelingConf = VampireLevelingConf.getInstance();
        ArrayList<IPage> levelingPages = new ArrayList<IPage>();
        levelingPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "leveling.intro", new Object[0])));
        String altarOfInspiration = "\u00a7l" + GuideBook.loc((Block)ModBlocks.altar_inspiration) + "\u00a7r\n\u00a7o" + GuideBook.translate(base + "leveling.inspiration.reach", new Object[0]) + "\u00a7r\n";
        altarOfInspiration = altarOfInspiration + GuideBook.translate(base + "leveling.inspiration.text", new Object[0]) + "\n";
        altarOfInspiration = altarOfInspiration + GuideBook.translate(base + "leveling.inspiration.requirements", levelingConf.getRequiredBloodForAltarInspiration(2), levelingConf.getRequiredBloodForAltarInspiration(3), levelingConf.getRequiredBloodForAltarInspiration(4));
        levelingPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(altarOfInspiration)), new ResourceLocation("guide.vampirism.blocks.altar_inspiration")));
        String altarOfInfusion = "\u00a7l" + GuideBook.loc((Block)ModBlocks.altar_infusion) + "\u00a7r\n\u00a7o" + GuideBook.translate(base + "leveling.infusion.reach", new Object[0]) + "\u00a7r\n";
        altarOfInfusion = altarOfInfusion + GuideBook.translate(base + "leveling.infusion.intro", GuideBook.loc((Block)ModBlocks.altar_infusion), GuideBook.loc(ModBlocks.altar_pillar), GuideBook.loc(ModBlocks.altar_tip));
        levelingPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(altarOfInfusion)), new ResourceLocation("guide.vampirism.blocks.altar_infusion")));
        StringBuilder blocks = new StringBuilder();
        for (AltarPillarBlock.EnumPillarType t : AltarPillarBlock.EnumPillarType.values()) {
            if (t == AltarPillarBlock.EnumPillarType.NONE) continue;
            blocks.append(GuideBook.translate(t.fillerBlock.func_149739_a(), new Object[0])).append("(").append(t.getValue()).append("),");
        }
        levelingPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "leveling.infusion.structure", blocks.toString())));
        String items = GuideBook.loc(ModItems.human_heart) + ", " + GuideBook.loc(ModItems.pure_blood_0) + ", " + GuideBook.loc(ModItems.vampire_book);
        levelingPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "leveling.infusion.items", items)), new ResourceLocation("guide.vampirism.items.human_heart"), new ResourceLocation("guide.vampirism.items.pure_blood_0"), new ResourceLocation("guide.vampirism.items.vampire_book")));
        PageTable.Builder requirementsBuilder = new PageTable.Builder(5);
        requirementsBuilder.addUnlocLine("text.vampirism.level_short", base + "leveling.infusion.req.structure_points", ModItems.pure_blood_0.func_77658_a(), base + "leveling.infusion.req.heart", base + "leveling.infusion.req.book");
        requirementsBuilder.addLine("5", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(5), "0", "5", "1");
        requirementsBuilder.addLine("6", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(6), "1 Purity(1)", "5", "1");
        requirementsBuilder.addLine("7", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(7), "1 Purity(1)", "10", "1");
        requirementsBuilder.addLine("8", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(8), "1 Purity(2)", "10", "1");
        requirementsBuilder.addLine("9", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(9), "1 Purity(2)", "10", "1");
        requirementsBuilder.addLine("10", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(10), "1 Purity(3)", "15", "1");
        requirementsBuilder.addLine("11", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(11), "1 Purity(3)", "15", "1");
        requirementsBuilder.addLine("12", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(12), "1 Purity(4)", "20", "1");
        requirementsBuilder.addLine("13", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(13), "2 Purity(4)", "20", "1");
        requirementsBuilder.addLine("14", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(14), "2 Purity(5)", "25", "1");
        requirementsBuilder.setHeadline(GuideBook.translate(base + "leveling.infusion.req", new Object[0]));
        PageHolderWithLinks requirementTable = new PageHolderWithLinks((IPage)requirementsBuilder.build());
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.human_heart"));
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.vampire_book"));
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.pure_blood_0"));
        levelingPages.add(requirementTable);
        levelingPages.add((IPage)new PageTextImage((ITextProperties)GuideBook.translate(base + "leveling.infusion.image1", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion1.png"), false));
        levelingPages.add((IPage)new PageTextImage((ITextProperties)GuideBook.translate(base + "leveling.infusion.image2", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion2.png"), false));
        levelingPages.add((IPage)new PageTextImage((ITextProperties)GuideBook.translate(base + "leveling.infusion.image3", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion3.png"), false));
        levelingPages.add((IPage)new PageTextImage((ITextProperties)GuideBook.translate(base + "leveling.infusion.image4", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion4.png"), false));
        levelingPages.add((IPage)new PageTextImage((ITextProperties)GuideBook.translate(base + "leveling.infusion.image5", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion5.png"), false));
        entries.put(new ResourceLocation(base + "leveling"), (EntryAbstract)new EntryText(levelingPages, GuideBook.translate(base + "leveling", new Object[0])));
        ArrayList<IPage> skillPages = new ArrayList<IPage>();
        skillPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "skills.text", UtilLib.translate(ModKeys.getKeyBinding(ModKeys.KEY.SKILL).func_197982_m(), new Object[0]))));
        skillPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "skills.actions", UtilLib.translate(ModKeys.getKeyBinding(ModKeys.KEY.ACTION).func_197982_m(), new Object[0]))));
        skillPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate("guide.vampirism.skills.bind_action", new Object[0])));
        skillPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "skills.actions2", new Object[0])));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, GuideBook.translate(base + "skills", new Object[0])));
        ArrayList<IPage> unvampirePages = new ArrayList<IPage>();
        unvampirePages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "unvampire.text", GuideBook.loc((Block)ModBlocks.church_altar))));
        entries.put(new ResourceLocation(base + "unvampire"), (EntryAbstract)new EntryText(unvampirePages, GuideBook.translate(base + "unvampire", new Object[0])));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildHunter() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.hunter.";
        ArrayList<IPage> gettingStarted = new ArrayList<IPage>();
        ITextComponent become = GuideBook.translate(base + "getting_started.become", GuideBook.translate(ModEntities.hunter_trainer.func_210760_d(), new Object[0]), GuideBook.loc(ModItems.injection_garlic));
        gettingStarted.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)become), new ResourceLocation("guide.vampirism.items.injection_empty")));
        gettingStarted.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/hunter_trainer.png")));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "getting_started.as_hunter", new Object[0])));
        entries.put(new ResourceLocation(base + "getting_started"), (EntryAbstract)new EntryText(gettingStarted, GuideBook.translate(base + "getting_started", new Object[0])));
        HunterLevelingConf levelingConf = HunterLevelingConf.instance();
        ArrayList<IPage> levelingPages = new ArrayList<IPage>();
        levelingPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "leveling.intro", new Object[0])));
        String train1 = "\u00a7l" + GuideBook.translate(base + "leveling.to_reach", "2-4") + "\u00a7r\n";
        train1 = train1 + GuideBook.translate(base + "leveling.train1.text", levelingConf.getVampireBloodCountForBasicHunter(2), levelingConf.getVampireBloodCountForBasicHunter(3), levelingConf.getVampireBloodCountForBasicHunter(4));
        levelingPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(train1)), new ResourceLocation("guide.vampirism.items.stake"), new ResourceLocation("guide.vampirism.items.vampire_blood_bottle")));
        String train2 = "\u00a7l" + GuideBook.translate(base + "leveling.to_reach", "5+") + "\u00a7r\n";
        train2 = train2 + GuideBook.translate(base + "leveling.train2.text", GuideBook.loc(ModBlocks.hunter_table));
        levelingPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(train2)), new ResourceLocation("guide.vampirism.blocks.hunter_table")));
        PageTable.Builder builder = new PageTable.Builder(4);
        builder.addUnlocLine("text.vampirism.level", base + "leveling.train2.fang", GuideBook.loc(ModItems.pure_blood_0), GuideBook.loc(ModItems.vampire_book));
        for (int i = levelingConf.TABLE_MIN_LEVEL; i <= levelingConf.TABLE_MAX_LEVEL; ++i) {
            int[] req = levelingConf.getItemRequirementsForTable(i);
            String pure = "";
            if (req[1] > 0) {
                pure = "" + req[1] + " Purity(" + (req[2] + 1) + ")";
            }
            builder.addLine(i, req[0], pure, req[3]);
        }
        builder.setHeadline(GuideBook.translate(base + "leveling.train2.req", new Object[0]));
        PageHolderWithLinks requirementsTable = new PageHolderWithLinks((IPage)builder.build());
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.vampire_fang"));
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.pure_blood_0"));
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.vampire_book"));
        levelingPages.add(requirementsTable);
        entries.put(new ResourceLocation(base + "leveling"), (EntryAbstract)new EntryText(levelingPages, GuideBook.translate(base + "leveling", new Object[0])));
        ArrayList<IPage> skillPages = new ArrayList<IPage>();
        skillPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "skills.intro", UtilLib.translate(ModKeys.getKeyBinding(ModKeys.KEY.SKILL).func_197982_m(), new Object[0]))));
        String disguise = String.format("\u00a7l%s\u00a7r\n", GuideBook.translate(HunterActions.disguise_hunter.getTranslationKey(), new Object[0]));
        disguise = disguise + GuideBook.translate(base + "skills.disguise.text", ModKeys.getKeyBinding(ModKeys.KEY.ACTION).func_197982_m());
        skillPages.addAll(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(disguise)));
        String bloodPotion = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc(ModBlocks.blood_potion_table));
        bloodPotion = bloodPotion + GuideBook.translate(base + "skills.blood_potion.text", UtilLib.translate(ModKeys.getKeyBinding(ModKeys.KEY.BLOOD_POTION).func_197982_m(), new Object[0]));
        skillPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(bloodPotion)), new ResourceLocation("guide.vampirism.blocks.blood_potion_table")));
        String weaponTable = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc(ModBlocks.weapon_table));
        weaponTable = weaponTable + GuideBook.translate(base + "skills.weapon_table.text", new Object[0]);
        skillPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(weaponTable)), new ResourceLocation("guide.vampirism.blocks.weapon_table")));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, GuideBook.translate(base + "skills", new Object[0])));
        ArrayList<IPage> vampSlayerPages = new ArrayList<IPage>();
        vampSlayerPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "vamp_slayer.intro", new Object[0])));
        String garlic = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc(ModItems.item_garlic));
        garlic = garlic + GuideBook.translate(base + "vamp_slayer.garlic", new Object[0]) + "\n" + GuideBook.translate(base + "vamp_slayer.garlic2", new Object[0]) + "\n" + GuideBook.translate(base + "vamp_slayer.garlic.diffusor", new Object[0]);
        vampSlayerPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(garlic)), new ResourceLocation("guide.vampirism.blocks.garlic_beacon_normal")));
        String holyWater = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc(ModItems.holy_water_bottle_normal));
        holyWater = holyWater + GuideBook.translate(base + "vamp_slayer.holy_water", new Object[0]);
        vampSlayerPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(holyWater)), new ResourceLocation("guide.vampirism.items.holy_water_bottle")));
        String fire = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc(Blocks.field_150480_ab));
        fire = fire + GuideBook.translate(base + "vamp_slayer.fire", new Object[0]);
        vampSlayerPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(fire)), new ResourceLocation("guide.vampirism.items.item_alchemical_fire"), new ResourceLocation("guide.vampirism.items.crossbow_arrow_normal")));
        entries.put(new ResourceLocation(base + "vamp_slayer"), (EntryAbstract)new EntryText(vampSlayerPages, GuideBook.translate(base + "vamp_slayer", new Object[0])));
        ArrayList<IPage> unHunterPages = new ArrayList<IPage>();
        unHunterPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "unhunter.text", GuideBook.loc(ModItems.injection_sanguinare), GuideBook.loc(ModBlocks.med_chair))), new ResourceLocation("guide.vampirism.items.injection_empty"), new ResourceLocation("guide.vampirism.blocks.item_med_chair")));
        entries.put(new ResourceLocation(base + "unhunter"), (EntryAbstract)new EntryText(unHunterPages, GuideBook.translate(base + "unhunter", new Object[0])));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildCreatures() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.entity.";
        ArrayList<IPage> generalPages = new ArrayList<IPage>(PageHelper.pagesForLongText((ITextProperties)ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{GuideBook.translate(base + "general.text", new Object[0]), GuideBook.translate(base + "general.text2", new Object[0])})));
        entries.put(new ResourceLocation(base + "general"), (EntryAbstract)new EntryText(generalPages, GuideBook.translate(base + "general", new Object[0])));
        ArrayList<IPage> hunterPages = new ArrayList<IPage>();
        hunterPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/hunter.png")));
        hunterPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "hunter.text", GuideBook.loc(ModItems.human_heart))));
        entries.put(new ResourceLocation(base + "hunter"), (EntryAbstract)new EntryText(hunterPages, ModEntities.hunter.func_212546_e()));
        ArrayList<IPage> vampirePages = new ArrayList<IPage>();
        vampirePages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/vampire.png")));
        vampirePages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "vampire.text", GuideBook.loc(ModItems.vampire_fang), GuideBook.loc(ModItems.vampire_blood_bottle), GuideBook.loc((Item)ModItems.stake))));
        entries.put(new ResourceLocation(base + "vampire"), (EntryAbstract)new EntryText(vampirePages, ModEntities.vampire.func_212546_e()));
        ArrayList<IPage> advancedHunterPages = new ArrayList<IPage>();
        advancedHunterPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/advanced_hunter.png")));
        advancedHunterPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "advanced_hunter.text", new Object[0])));
        entries.put(new ResourceLocation(base + "advanced_hunter"), (EntryAbstract)new EntryText(advancedHunterPages, ModEntities.advanced_hunter.func_212546_e()));
        ArrayList<IPage> advancedVampirePages = new ArrayList<IPage>();
        advancedVampirePages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/advanced_vampire.png")));
        advancedVampirePages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "advanced_vampire.text", GuideBook.loc(ModItems.blood_bottle), GuideBook.loc(ModItems.vampire_blood_bottle))));
        entries.put(new ResourceLocation(base + "advanced_vampire"), (EntryAbstract)new EntryText(advancedVampirePages, ModEntities.advanced_vampire.func_212546_e()));
        ArrayList<IPage> vampireBaronPages = new ArrayList<IPage>();
        vampireBaronPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/vampire_baron.png")));
        vampireBaronPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "vampire_baron.text", GuideBook.loc(ModItems.pure_blood_0))));
        GuideHelper.addLinks(vampireBaronPages, new ResourceLocation("guide.vampirism.world.vampire_forest"));
        entries.put(new ResourceLocation(base + "vampire_baron"), (EntryAbstract)new EntryText(vampireBaronPages, ModEntities.vampire_baron.func_212546_e()));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildWorld() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.world.";
        ArrayList<IPage> vampireForestPages = new ArrayList<IPage>(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "vampire_forest.text", new Object[0])));
        entries.put(new ResourceLocation(base + "vampire_forest"), (EntryAbstract)new EntryText(vampireForestPages, GuideBook.translate(base + "vampire_forest", new Object[0])));
        ArrayList<IPage> villagePages = new ArrayList<IPage>(GuideHelper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + "villages.text", new Object[0])), new ResourceLocation("guide.vampirism.blocks.totem_base"), new ResourceLocation("guide.vampirism.blocks.totem_top")));
        entries.put(new ResourceLocation(base + "villages"), (EntryAbstract)new EntryText(villagePages, GuideBook.translate(base + "villages", new Object[0])));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildItems() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.items.";
        ItemInfoBuilder.create(ModItems.vampire_fang).build(entries);
        ItemInfoBuilder.create(ModItems.human_heart).build(entries);
        ItemInfoBuilder.create(ModItems.pure_blood_0, ModItems.pure_blood_1, ModItems.pure_blood_2, ModItems.pure_blood_3, ModItems.pure_blood_4).setFormats(GuideBook.translate(ModEntities.vampire_baron.func_210760_d(), new Object[0])).build(entries);
        ItemInfoBuilder.create(ModItems.vampire_blood_bottle).setFormats(GuideBook.translate(ModEntities.vampire.func_210760_d(), new Object[0]), GuideBook.loc((Item)ModItems.stake), GuideBook.translate(ModEntities.advanced_vampire.func_210760_d(), new Object[0])).build(entries);
        ItemInfoBuilder.create(ModItems.vampire_book).build(entries);
        ItemInfoBuilder.create(false, BloodBottleItem.getStackWithDamage(9)).build(entries);
        ItemInfoBuilder.create(ModItems.blood_infused_iron_ingot).recipes("vampire/blood_infused_iron_ingot", "vampire/blood_infused_enhanced_iron_ingot").build(entries);
        ItemInfoBuilder.create(new Item[]{ModItems.heart_seeker_normal, ModItems.heart_seeker_enhanced, ModItems.heart_seeker_ultimate}).recipes("vampire/heart_seeker_normal", "vampire/heart_seeker_enhanced").build(entries);
        ItemInfoBuilder.create(new Item[]{ModItems.heart_striker_normal, ModItems.heart_striker_enhanced, ModItems.heart_striker_ultimate}).recipes("vampire/heart_striker_normal", "vampire/heart_striker_normal").build(entries);
        ItemInfoBuilder.create(new Item[]{ModItems.vampire_cloak_black_red, ModItems.vampire_cloak_black_blue, ModItems.vampire_cloak_red_black, ModItems.vampire_cloak_black_white, ModItems.vampire_cloak_white_black}).recipes("vampire/vampire_cloak_black_red", "vampire/vampire_cloak_black_blue", "vampire/vampire_cloak_black_white", "vampire/vampire_cloak_red_black", "vampire/vampire_cloak_white_black").build(entries);
        ItemInfoBuilder.create(ModItems.injection_empty, ModItems.injection_garlic, ModItems.injection_sanguinare).recipes("general/injection_0", "general/injection_1", "general/injection_2").build(entries);
        ItemInfoBuilder.create(ModItems.hunter_intel_0).setLinks(new ResourceLocation("guide.vampirism.blocks.hunter_table")).setFormats(GuideBook.loc(ModBlocks.hunter_table)).build(entries);
        ItemInfoBuilder.create(ModItems.item_garlic).build(entries);
        ItemInfoBuilder.create(ModItems.purified_garlic).setFormats(GuideBook.loc((Block)ModBlocks.garlic_beacon_normal)).setLinks(new ResourceLocation("guide.vampirism.blocks.garlic_beacon_normal")).recipes("alchemical_cauldron/purified_garlic").build(entries);
        ItemInfoBuilder.create(new Item[]{ModItems.pitchfork}).recipes("weapontable/pitchfork").build(entries);
        ItemInfoBuilder.create(new Item[]{ModItems.stake}).setFormats((int)((Double)VampirismConfig.BALANCE.hsInstantKill1MaxHealth.get() * 100.0) + "%").recipes("hunter/stake").build(entries);
        ItemInfoBuilder.create(ModItems.basic_crossbow, ModItems.enhanced_crossbow, ModItems.basic_double_crossbow, ModItems.enhanced_double_crossbow, ModItems.basic_tech_crossbow, ModItems.enhanced_tech_crossbow).setFormats(GuideBook.loc(ModItems.crossbow_arrow_normal), GuideBook.loc(ModItems.tech_crossbow_ammo_package)).setLinks(new ResourceLocation("guide.vampirism.items.crossbow_arrow_normal")).recipes("weapontable/basic_crossbow", "weapontable/enhanced_crossbow", "weapontable/basic_double_crossbow", "weapontable/enhanced_double_crossbow", "weapontable/basic_tech_crossbow", "weapontable/enhanced_tech_crossbow", "weapontable/tech_crossbow_ammo_package").setName("crossbows").customName().build(entries);
        ItemInfoBuilder.create(ModItems.crossbow_arrow_normal, ModItems.crossbow_arrow_spitfire, ModItems.crossbow_arrow_vampire_killer).recipes("hunter/crossbow_arrow_normal", "weapontable/crossbow_arrow_spitfire", "weapontable/crossbow_arrow_vampire_killer").build(entries);
        ItemInfoBuilder.create(ModItems.holy_water_bottle_normal, ModItems.holy_water_bottle_enhanced, ModItems.holy_water_bottle_ultimate).setLinks(new ResourceLocation("guide.vampirism.hunter.vamp_slayer"), new ResourceLocation("guide.vampirism.items.holy_salt")).setFormats(GuideBook.loc(ModItems.holy_salt_water), GuideBook.loc(ModItems.holy_salt_water), GuideBook.loc(ModItems.holy_salt)).brewingItems(ModItems.holy_salt_water, ModItems.holy_water_splash_bottle_normal).build(entries);
        ItemInfoBuilder.create(ModItems.holy_salt).setLinks(new ResourceLocation("guide.vampirism.items.holy_water_bottle")).setFormats(GuideBook.loc(ModItems.pure_salt), GuideBook.loc(ModItems.pure_salt), GuideBook.loc((Block)ModBlocks.alchemical_cauldron)).recipes("alchemical_cauldron/pure_salt").build(entries);
        ItemInfoBuilder.create(ModItems.item_alchemical_fire).setLinks(new ResourceLocation("guide.vampirism.items.crossbow_arrow_normal")).recipes("alchemical_cauldron/alchemical_fire_4", "alchemical_cauldron/alchemical_fire_5", "alchemical_cauldron/alchemical_fire_6").build(entries);
        ItemInfoBuilder.create(new Item[]{ModItems.armor_of_swiftness_chest_normal, ModItems.armor_of_swiftness_chest_enhanced, ModItems.armor_of_swiftness_chest_enhanced, ModItems.armor_of_swiftness_legs_normal, ModItems.armor_of_swiftness_legs_enhanced, ModItems.armor_of_swiftness_legs_ultimate, ModItems.armor_of_swiftness_head_normal, ModItems.armor_of_swiftness_head_enhanced, ModItems.armor_of_swiftness_head_ultimate, ModItems.armor_of_swiftness_feet_normal, ModItems.armor_of_swiftness_feet_enhanced, ModItems.armor_of_swiftness_feet_ultimate}).recipes("weapontable/armor_of_swiftness_chest_normal", "weapontable/armor_of_swiftness_legs_normal", "weapontable/armor_of_swiftness_head_normal", "weapontable/armor_of_swiftness_feet_normal", "weapontable/armor_of_swiftness_enhanced_chest", "weapontable/armor_of_swiftness_enhanced_legs", "weapontable/armor_of_swiftness_enhanced_head", "weapontable/armor_of_swiftness_enhanced_feet").build(entries);
        ItemInfoBuilder.create(new Item[]{ModItems.hunter_coat_chest_normal, ModItems.hunter_coat_chest_enhanced, ModItems.hunter_coat_chest_enhanced, ModItems.hunter_coat_legs_normal, ModItems.hunter_coat_legs_enhanced, ModItems.hunter_coat_legs_ultimate, ModItems.hunter_coat_head_normal, ModItems.hunter_coat_head_enhanced, ModItems.hunter_coat_head_ultimate, ModItems.hunter_coat_feet_normal, ModItems.hunter_coat_feet_enhanced, ModItems.hunter_coat_feet_ultimate}).recipes("weapontable/hunter_coat_chest_normal", "weapontable/hunter_coat_legs_normal", "weapontable/hunter_coat_head_normal", "weapontable/hunter_coat_feet_normal", "weapontable/hunter_coat_chest_enhanced", "weapontable/hunter_coat_legs_enhanced", "weapontable/hunter_coat_head_enhanced", "weapontable/hunter_coat_feet_enhanced").build(entries);
        ItemInfoBuilder.create(new Item[]{ModItems.obsidian_armor_chest_normal, ModItems.obsidian_armor_chest_enhanced, ModItems.obsidian_armor_chest_enhanced, ModItems.obsidian_armor_legs_normal, ModItems.obsidian_armor_legs_enhanced, ModItems.obsidian_armor_legs_ultimate, ModItems.obsidian_armor_head_normal, ModItems.obsidian_armor_head_enhanced, ModItems.obsidian_armor_head_ultimate, ModItems.obsidian_armor_feet_normal, ModItems.obsidian_armor_feet_enhanced, ModItems.obsidian_armor_feet_ultimate}).recipes("weapontable/obsidian_armor_chest_normal", "weapontable/obsidian_armor_legs_normal", "weapontable/obsidian_armor_head_normal", "weapontable/obsidian_armor_feet_normal", "weapontable/obsidian_armor_chest_enhanced", "weapontable/obsidian_armor_legs_enhanced", "weapontable/obsidian_armor_head_enhanced", "weapontable/obsidian_armor_feet_enhanced").build(entries);
        ItemInfoBuilder.create(new Item[]{ModItems.hunter_axe_normal, ModItems.hunter_axe_enhanced, ModItems.hunter_axe_ultimate}).recipes("weapontable/hunter_axe", "weapontable/hunter_axe_enhanced").build(entries);
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildBlocks() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.blocks.";
        ItemInfoBuilder.create(ModBlocks.castle_block_dark_brick).recipes("general/castle_block_dark_brick_0", "general/castle_block_dark_brick_1", "general/castle_block_dark_stone", "general/castle_block_normal_brick", "general/castle_block_purple_brick", "general/castle_slab_dark_brick", "general/castle_stairs_dark_brick").build(entries);
        ItemInfoBuilder.create(new Block[]{ModBlocks.vampire_orchid}).build(entries);
        ItemInfoBuilder.create(new Block[]{ModBlocks.blood_container}).recipes("vampire/blood_container").build(entries);
        ItemInfoBuilder.create(new Block[]{ModBlocks.altar_inspiration}).setLinks(new ResourceLocation("guide.vampirism.vampire.leveling")).recipes("vampire/altar_inspiration").build(entries);
        ItemInfoBuilder.create(new Block[]{ModBlocks.altar_infusion}).setLinks(new ResourceLocation("guide.vampirism.vampire.leveling")).recipes("vampire/altar_infusion", "vampire/altar_pillar", "vampire/altar_tip").build(entries);
        ItemInfoBuilder.create(new Block[]{ModBlocks.coffin}).recipes("vampire/coffin").build(entries);
        ItemInfoBuilder.create(new Block[]{ModBlocks.church_altar}).build(entries);
        ItemInfoBuilder.create(true, new ItemStack((IItemProvider)ModItems.item_med_chair)).setFormats(GuideBook.loc(ModItems.injection_garlic), GuideBook.loc(ModItems.injection_sanguinare)).recipes("hunter/item_med_chair").build(entries);
        ItemInfoBuilder.create(ModBlocks.hunter_table).setFormats(GuideBook.loc(ModItems.hunter_intel_0)).setLinks(new ResourceLocation("guide.vampirism.hunter.leveling"), new ResourceLocation("guide.vampirism.items.hunter_intel")).recipes("hunter/hunter_table").build(entries);
        ItemInfoBuilder.create(ModBlocks.weapon_table).recipes("hunter/weapon_table").build(entries);
        ItemInfoBuilder.create(ModBlocks.blood_potion_table).recipes("hunter/blood_potion_table").build(entries);
        ItemInfoBuilder.create(new Block[]{ModBlocks.alchemical_cauldron}).recipes("hunter/alchemical_cauldron").build(entries);
        int cn = (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorNormalDist.get() * 2 + 1;
        int ce = (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorEnhancedDist.get() * 2 + 1;
        ItemInfoBuilder.create(new Block[]{ModBlocks.garlic_beacon_normal, ModBlocks.garlic_beacon_weak, ModBlocks.garlic_beacon_weak}).setFormats(cn, cn, ce, ce, GuideBook.loc(ModItems.purified_garlic)).setLinks(new ResourceLocation("guide.vampirism.items.item_garlic"), new ResourceLocation("guide.vampirism.items.purified_garlic"), new ResourceLocation("guide.vampirism.items.holy_water_bottle")).recipes("hunter/garlic_beacon", "hunter/garlic_beacon_improved", "alchemical_cauldron/garlic_beacon_core", "alchemical_cauldron/garlic_beacon_core_improved").build(entries);
        ItemInfoBuilder.create(new Block[]{ModBlocks.blood_pedestal}).recipes("vampire/blood_pedestal").build(entries);
        ItemInfoBuilder.create(new Block[]{ModBlocks.blood_grinder}).recipes("general/blood_grinder").setFormats(GuideBook.loc(ModItems.human_heart), GuideBook.loc(Items.field_151082_bd), GuideBook.loc((Block)ModBlocks.blood_sieve)).build(entries);
        ItemInfoBuilder.create(new Block[]{ModBlocks.blood_sieve}).recipes("general/blood_sieve").setFormats(GuideBook.translate(ModFluids.impure_blood.getAttributes().getTranslationKey(), new Object[0]), GuideBook.loc((Block)ModBlocks.blood_grinder)).setLinks(new ResourceLocation("guide.vampirism.blocks.blood_grinder")).build(entries);
        ItemInfoBuilder.create(new Block[]{ModBlocks.totem_top}).recipes("general/totem_top").setLinks(new ResourceLocation("guide.vampirism.blocks.totem_base"), new ResourceLocation("guide.vampirism.world.villages")).build(entries);
        ItemInfoBuilder.create(ModBlocks.totem_base).recipes("general/totem_base").setLinks(new ResourceLocation("guide.vampirism.blocks.totem_top"), new ResourceLocation("guide.vampirism.world.villages")).build(entries);
        links.putAll(entries);
        return entries;
    }

    public static ITextComponent translate(String key, Object ... format) {
        String result = UtilLib.translate(key, format);
        return new StringTextComponent(result.replaceAll("\\\\n", Matcher.quoteReplacement("\n")));
    }

    @Nullable
    public Book buildBook() {
        BookBinder binder = new BookBinder(new ResourceLocation("vampirism", "guidebook"));
        binder.setGuideTitleKey("guide.vampirism.title");
        binder.setItemNameKey("guide.vampirism");
        binder.setHeaderKey("guide.vampirism.welcome");
        binder.setAuthor((ITextComponent)new StringTextComponent("Maxanier"));
        binder.setColor(Color.WHITE);
        binder.setOutlineTexture(new ResourceLocation("vampirismguide", "textures/gui/book_violet_border.png"));
        binder.setSpawnWithBook();
        binder.setContentProvider(GuideBook::buildCategories);
        guideBook = binder.build();
        return guideBook;
    }

    @Nullable
    public ResourceLocation getModel() {
        return new ResourceLocation("vampirism", "guidebook");
    }

    static {
        links = Maps.newHashMap();
    }
}

