/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide;

import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.PageHelper;
import de.maxanier.guideapi.entry.EntryItemStack;
import de.maxanier.guideapi.page.PageBrewingRecipe;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.modcompat.guide.GuideBook;
import de.teamlapen.vampirism.modcompat.guide.GuideHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.brewing.BrewingRecipe;
import org.apache.logging.log4j.LogManager;

public class ItemInfoBuilder {
    private final boolean block;
    private String name;
    private Object[] formats = new Object[0];
    private Object[] links = null;
    private boolean customName;
    @Nonnull
    private List<ResourceLocation> recipes = Collections.emptyList();
    private final Ingredient ingredient;
    private final ItemStack mainStack;
    @Nullable
    private ItemStack[] brewingStacks;

    public static ItemInfoBuilder create(Item ... items) {
        assert (items.length > 0);
        Item i0 = items[0];
        String name = i0 instanceof IItemWithTier ? ((IItemWithTier)i0).getBaseRegName() : i0.getRegistryName().func_110623_a();
        return new ItemInfoBuilder(Ingredient.func_199804_a((IItemProvider[])items), new ItemStack((IItemProvider)i0), name, false);
    }

    public static ItemInfoBuilder create(boolean block, ItemStack ... stacks) {
        assert (stacks.length > 0);
        ItemStack i0 = stacks[0];
        Item item = i0.func_77973_b();
        String name = item instanceof IItemWithTier ? ((IItemWithTier)item).getBaseRegName() : item.getRegistryName().func_110623_a();
        return new ItemInfoBuilder(Ingredient.func_193369_a((ItemStack[])stacks), i0, name, block);
    }

    public static ItemInfoBuilder create(Block ... blocks) {
        assert (blocks.length > 0);
        Block i0 = blocks[0];
        String name = i0.getRegistryName().func_110623_a();
        return new ItemInfoBuilder(Ingredient.func_199804_a((IItemProvider[])blocks), new ItemStack((IItemProvider)i0), name, true);
    }

    private ItemInfoBuilder(Ingredient ingredient, ItemStack mainStack, String name, boolean block) {
        this.ingredient = ingredient;
        this.block = block;
        this.mainStack = mainStack;
        this.name = name;
    }

    public ItemInfoBuilder brewingItems(Item ... brewableItems) {
        this.brewingStacks = (ItemStack[])Arrays.stream(brewableItems).map(ItemStack::new).toArray(ItemStack[]::new);
        return this;
    }

    public ItemInfoBuilder recipes(ResourceLocation ... ids) {
        this.recipes = Arrays.asList(ids);
        return this;
    }

    public ItemInfoBuilder recipes(String ... vampIDs) {
        this.recipes = Arrays.stream(vampIDs).map(id -> new ResourceLocation("vampirism", id)).collect(Collectors.toList());
        return this;
    }

    public ItemInfoBuilder brewingStacks(ItemStack ... brewableStacks) {
        this.brewingStacks = brewableStacks;
        return this;
    }

    public void build(Map<ResourceLocation, EntryAbstract> entries) {
        ArrayList<IPage> pages = new ArrayList<IPage>();
        String base = "guide.vampirism." + (this.block ? "blocks" : "items") + "." + this.name;
        pages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translate(base + ".text", this.formats), (Ingredient)this.ingredient));
        for (ResourceLocation id : this.recipes) {
            pages.add(GuideHelper.getRecipePage(id));
        }
        if (this.brewingStacks != null) {
            for (ItemStack brew : this.brewingStacks) {
                BrewingRecipe r = GuideHelper.getBrewingRecipe(brew);
                if (r == null) {
                    LogManager.getLogger().error("Could not find brewing recipe for {}", (Object)brew.toString());
                    continue;
                }
                pages.add((IPage)new PageBrewingRecipe(r));
            }
        }
        if (this.links != null) {
            GuideHelper.addLinks(pages, this.links);
        }
        entries.put(new ResourceLocation(base), (EntryAbstract)new EntryItemStack(pages, (ITextComponent)new TranslationTextComponent(this.customName ? base : this.mainStack.func_77977_a()), this.mainStack));
    }

    public ItemInfoBuilder customName() {
        this.customName = true;
        return this;
    }

    public ItemInfoBuilder setFormats(Object ... formats) {
        this.formats = formats;
        return this;
    }

    public ItemInfoBuilder setLinks(Object ... links) {
        this.links = links;
        return this;
    }

    public ItemInfoBuilder setName(String name) {
        this.name = name;
        return this;
    }
}

