/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.inventory.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import java.awt.Color;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class AlchemicalCauldronRecipeCategory
implements IRecipeCategory<AlchemicalCauldronRecipe> {
    private final String localizedName = UtilLib.translate(ModBlocks.alchemical_cauldron.func_149739_a(), new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    private static final ResourceLocation location = new ResourceLocation("vampirism", "textures/gui/alchemical_cauldron.png");
    private final IDrawableAnimated flame;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated bubbles;

    AlchemicalCauldronRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.alchemical_cauldron));
        this.background = guiHelper.drawableBuilder(location, 38, 10, 120, 70).addPadding(0, 33, 0, 0).build();
        IDrawableStatic flameDrawable = guiHelper.createDrawable(location, 176, 0, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 300, IDrawableAnimated.StartDirection.TOP, true);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, 176, 14, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        IDrawableStatic bubblesDrawable = guiHelper.createDrawable(location, 176, 31, 12, 29);
        this.bubbles = guiHelper.createAnimatedDrawable(bubblesDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void draw(AlchemicalCauldronRecipe recipe, MatrixStack stack, double mouseX, double mouseY) {
        this.flame.draw(stack, 19, 27);
        this.arrow.draw(stack, 41, 25);
        this.bubbles.draw(stack, 104, 19);
        Minecraft minecraft = Minecraft.func_71410_x();
        int x = 0;
        int y = 65;
        if (recipe.getRequiredLevel() > 1) {
            TranslationTextComponent level = new TranslationTextComponent("gui.vampirism.alchemical_cauldron.level", new Object[]{recipe.getRequiredLevel()});
            minecraft.field_71466_p.func_243248_b(stack, (ITextComponent)level, (float)x, (float)y, Color.gray.getRGB());
            minecraft.field_71466_p.getClass();
            y += 9 + 2;
        }
        if (recipe.getRequiredSkills().length > 0) {
            StringBuilder skills = new StringBuilder();
            for (ISkill s : recipe.getRequiredSkills()) {
                skills.append(UtilLib.translate(s.getTranslationKey(), new Object[0])).append(" ");
            }
            TranslationTextComponent skillText = new TranslationTextComponent("gui.vampirism.alchemical_cauldron.skill", new Object[]{skills.toString()});
            minecraft.field_71466_p.func_238418_a_((ITextProperties)skillText, x, y, 132, Color.gray.getRGB());
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends AlchemicalCauldronRecipe> getRecipeClass() {
        return AlchemicalCauldronRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public ResourceLocation getUid() {
        return VampirismJEIPlugin.ALCHEMICAL_CAULDRON_RECIPE_UID;
    }

    public void setIngredients(AlchemicalCauldronRecipe recipe, IIngredients iIngredients) {
        ArrayList ingredients = new ArrayList();
        recipe.getFluid().ifRight(fluidStack -> ingredients.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{fluidStack.getFluid().func_204524_b()})));
        recipe.getFluid().ifLeft(ingredients::add);
        ingredients.addAll(recipe.func_192400_c());
        iIngredients.setInputIngredients(ingredients);
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, AlchemicalCauldronRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        guiItemStackGroup.init(0, false, 77, 23);
        guiItemStackGroup.init(1, true, 5, 6);
        guiItemStackGroup.init(2, true, 29, 6);
        guiItemStackGroup.set(ingredients);
    }
}

