/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.potion.blood;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.items.IBloodPotionCategory;
import de.teamlapen.vampirism.api.items.IBloodPotionEffect;
import de.teamlapen.vampirism.api.items.IBloodPotionRegistry;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class BloodPotionCategory
implements IBloodPotionCategory {
    private static final Logger LOGGER = LogManager.getLogger(BloodPotionCategory.class);
    @Nullable
    private final String unlocDesc;
    private final ResourceLocation id;
    private final List<ItemStack> exactItems = NonNullList.func_191196_a();
    private final List<Item> items = Lists.newLinkedList();
    private final List<IBloodPotionRegistry.WeightedEffect> effects = Lists.newArrayList();

    BloodPotionCategory(ResourceLocation id) {
        this.unlocDesc = "text.vampirism.potioncat." + id.func_110624_b() + "." + id.func_110623_a() + ".desc";
        this.id = id;
    }

    public void addEffect(IBloodPotionEffect effect, int weight) {
        this.effects.add(new IBloodPotionRegistry.WeightedEffect(effect, weight));
    }

    @Override
    public void addItem(Item item) {
        this.items.add(item);
    }

    @Override
    public void addItem(Block block) {
        this.items.add(Item.func_150898_a((Block)block));
    }

    @Override
    public void addItemExact(@Nonnull ItemStack stack) {
        this.exactItems.add(stack);
    }

    @Override
    public void addItems(Object ... items) {
        for (Object item : items) {
            if (item instanceof Item) {
                this.addItem((Item)item);
                continue;
            }
            if (item instanceof Block) {
                this.addItem((Block)item);
                continue;
            }
            if (item instanceof ItemStack) {
                this.addItemExact((ItemStack)item);
                continue;
            }
            LOGGER.warn("Failed to add item '{}' of unkown type", item);
        }
    }

    @Override
    public boolean containsItem(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        if (this.items.contains(item)) {
            return true;
        }
        for (ItemStack next : this.exactItems) {
            if (stack.func_77973_b() != next.func_77973_b() || stack.func_77952_i() != next.func_77952_i() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)next)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescTranslationKey() {
        return this.unlocDesc == null ? "" : this.unlocDesc;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<IBloodPotionRegistry.WeightedEffect> getImmutableEffectsList() {
        return Collections.unmodifiableList(this.effects);
    }

    public String toString() {
        return "BloodPotionCategory{tileInventory=" + this.items + ", unlocDesc='" + this.unlocDesc + '\'' + ", exactItems=" + this.exactItems + '}';
    }
}

