/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.vm.tileentity;

import com.lupicus.vm.block.ModBlocks;
import com.lupicus.vm.config.MyConfig;
import com.lupicus.vm.sound.ModSounds;
import com.lupicus.vm.tileentity.ModTileEntities;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.OperatorOnlyItem;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class VendingMachineTileEntity
extends TileEntity
implements IMerchant {
    MerchantOffers offers = null;
    PlayerEntity customer = null;
    boolean fixed = MyConfig.fixed;
    long stockTime = 0L;
    private static final long DAY = 24000L;
    private static final int ITEM_COUNT = 7;
    private static final int RETRIES = 8;

    public VendingMachineTileEntity() {
        super(ModTileEntities.VENDING_MACHINE);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.stockTime = compound.func_74763_f("stockTime");
        this.fixed = compound.func_74767_n("fixed");
        this.offers = new MerchantOffers(compound);
        if (this.offers.isEmpty()) {
            this.offers = null;
        }
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74772_a("stockTime", this.stockTime);
        compound.func_74757_a("fixed", this.fixed);
        if (this.offers != null) {
            compound.func_197643_a(this.offers.func_222199_a());
        }
        return super.func_189515_b(compound);
    }

    public void func_70932_a_(PlayerEntity player) {
        this.customer = player;
    }

    public PlayerEntity func_70931_l_() {
        return this.customer;
    }

    public MerchantOffers func_213706_dY() {
        if (MyConfig.restock) {
            long time = this.field_145850_b.func_72820_D();
            if (time < this.stockTime) {
                this.stockTime = time;
                this.stockTime -= Math.abs(this.stockTime % 24000L);
            }
            if (time - this.stockTime >= 24000L) {
                this.stockTime = time;
                this.stockTime -= Math.abs(this.stockTime % 24000L);
                if (this.fixed) {
                    this.restock();
                } else {
                    this.offers = null;
                }
            }
        }
        if (this.offers == null) {
            if (this.fixed) {
                this.configOffers();
            } else {
                this.fillOffers();
            }
        }
        return this.offers;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_213703_a(MerchantOffers offers) {
        this.offers = offers;
    }

    public void func_213704_a(MerchantOffer offer) {
        offer.func_222219_j();
        this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, ModSounds.VENDING_MACHINE_TAKE_RESULT, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void func_110297_a_(ItemStack stack) {
    }

    public World func_190670_t_() {
        return this.field_145850_b;
    }

    public int func_213708_dV() {
        return 0;
    }

    public void func_213702_q(int xpIn) {
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_187915_go;
    }

    public void openGui(PlayerEntity player) {
        this.func_70932_a_(player);
        TranslationTextComponent name = new TranslationTextComponent(ModBlocks.VENDING_MACHINE.func_149739_a());
        this.func_213707_a(player, (ITextComponent)name, 5);
    }

    private void fillOffers() {
        int tryCount = 0;
        this.offers = new MerchantOffers();
        HashSet<Item> set = new HashSet<Item>(ForgeRegistries.ITEMS.getValues());
        if (!MyConfig.includeGroupSet.contains("*") || MyConfig.excludeGroupSet.size() != 1 || !MyConfig.excludeGroupSet.contains("!")) {
            this.filterGroups(set);
        }
        if (!MyConfig.includeModSet.contains("*") || !MyConfig.excludeModSet.isEmpty()) {
            this.filterMods(set);
        }
        if (set.isEmpty()) {
            set.add(Items.field_190931_a);
        }
        Item[] values = set.toArray(new Item[0]);
        NonNullList items = NonNullList.func_191196_a();
        int i = 0;
        while (i < 7) {
            int maxUses;
            ItemStack payment;
            ++tryCount;
            int j = this.field_145850_b.field_73012_v.nextInt(values.length);
            Item item = values[j];
            items.clear();
            item.func_150895_a(ItemGroup.field_78027_g, items);
            ItemStack stack = !items.isEmpty() ? (ItemStack)items.get(this.field_145850_b.field_73012_v.nextInt(items.size())) : new ItemStack((IItemProvider)item);
            Rarity rarity = MyConfig.itemRarityMap.get(item);
            if (rarity == null) {
                rarity = item.func_77613_e(stack);
            }
            if ((payment = this.itemPayment(rarity)).func_190926_b() || this.invalidItem(item)) {
                if (tryCount < 8) continue;
                stack.func_190920_e(0);
                payment = this.itemPayment(Rarity.COMMON);
                maxUses = 1;
            } else {
                maxUses = this.itemUses(rarity);
            }
            MerchantOffer offer = new MerchantOffer(payment, stack, maxUses, 0, 0.0f);
            this.offers.add((Object)offer);
            tryCount = 0;
            ++i;
        }
    }

    private void configOffers() {
        this.offers = new MerchantOffers();
        NonNullList items = NonNullList.func_191196_a();
        for (int i = 0; i < 7; ++i) {
            int maxUses;
            ItemStack payment;
            Item item = MyConfig.fixedItems[i];
            items.clear();
            item.func_150895_a(ItemGroup.field_78027_g, items);
            ItemStack stack = !items.isEmpty() ? (ItemStack)items.get(this.field_145850_b.field_73012_v.nextInt(items.size())) : new ItemStack((IItemProvider)item);
            Rarity rarity = MyConfig.itemRarityMap.get(item);
            if (rarity == null) {
                rarity = item.func_77613_e(stack);
            }
            if ((payment = this.itemPayment(rarity)).func_190926_b()) {
                payment = this.itemPayment(Rarity.EPIC);
                maxUses = this.itemUses(Rarity.EPIC);
            } else {
                maxUses = this.itemUses(rarity);
            }
            MerchantOffer offer = new MerchantOffer(payment, stack, maxUses, 0, 0.0f);
            this.offers.add((Object)offer);
        }
    }

    private void restock() {
        if (this.offers == null) {
            return;
        }
        for (MerchantOffer offer : this.offers) {
            offer.func_222203_h();
        }
    }

    private void filterGroups(Collection<Item> set) {
        HashSet<String> includeSet = MyConfig.includeGroupSet;
        HashSet<String> excludeSet = MyConfig.excludeGroupSet;
        boolean addAll = includeSet.contains("*");
        set.removeIf(item -> {
            String name;
            ItemGroup group = item.func_77640_w();
            String string = name = group == null ? "!" : group.func_200300_c();
            return !addAll && !includeSet.contains(name) || excludeSet.contains(name);
        });
    }

    private void filterMods(Collection<Item> set) {
        HashSet<String> includeSet = MyConfig.includeModSet;
        HashSet<String> excludeSet = MyConfig.excludeModSet;
        boolean addAll = includeSet.contains("*");
        set.removeIf(item -> {
            String name = item.getRegistryName().func_110624_b();
            return !addAll && !includeSet.contains(name) || excludeSet.contains(name);
        });
    }

    private boolean invalidItem(Item item) {
        String groupName;
        if (item instanceof OperatorOnlyItem) {
            return true;
        }
        ItemGroup group = item.func_77640_w();
        String string = groupName = group == null ? "!" : group.func_200300_c();
        if (!MyConfig.includeGroupSet.contains("*") && !MyConfig.includeGroupSet.contains(groupName)) {
            return true;
        }
        if (MyConfig.excludeGroupSet.contains(groupName)) {
            return true;
        }
        String modName = item.getRegistryName().func_110624_b();
        if (!MyConfig.includeModSet.contains("*") && !MyConfig.includeModSet.contains(modName)) {
            return true;
        }
        return MyConfig.excludeModSet.contains(modName) || MyConfig.excludeItemSet.contains(item);
    }

    private ItemStack itemPayment(Rarity type) {
        ItemStack cost;
        switch (type) {
            case COMMON: {
                cost = new ItemStack((IItemProvider)MyConfig.commonItem, MyConfig.commonCost);
                break;
            }
            case EPIC: {
                cost = new ItemStack((IItemProvider)MyConfig.epicItem, MyConfig.epicCost);
                break;
            }
            case RARE: {
                cost = new ItemStack((IItemProvider)MyConfig.rareItem, MyConfig.rareCost);
                break;
            }
            case UNCOMMON: {
                cost = new ItemStack((IItemProvider)MyConfig.uncommonItem, MyConfig.uncommonCost);
                break;
            }
            default: {
                cost = ItemStack.field_190927_a;
            }
        }
        return cost;
    }

    private int itemUses(Rarity type) {
        int maxUses;
        switch (type) {
            case COMMON: {
                maxUses = MyConfig.commonUses;
                break;
            }
            case EPIC: {
                maxUses = MyConfig.epicUses;
                break;
            }
            case RARE: {
                maxUses = MyConfig.rareUses;
                break;
            }
            case UNCOMMON: {
                maxUses = MyConfig.uncommonUses;
                break;
            }
            default: {
                maxUses = 0;
            }
        }
        return maxUses;
    }
}

