/*
 * Decompiled with CFR 0.152.
 */
package com.hoopawolf.dmm.network;

import com.hoopawolf.dmm.network.packets.client.MessageToClient;
import com.hoopawolf.dmm.network.packets.client.SpawnParticleMessage;
import com.hoopawolf.dmm.ref.Reference;
import com.hoopawolf.dmm.util.ParticleRegistryHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageHandlerOnClient {
    static final BasicParticleType[] types = new BasicParticleType[]{ParticleTypes.field_197631_x, ParticleTypes.field_197629_v, ParticleTypes.field_197624_q, (BasicParticleType)ParticleRegistryHandler.DEATH_MARK_PARTICLE.get(), ParticleTypes.field_197601_L, (BasicParticleType)ParticleRegistryHandler.PLAGUE_PARTICLE.get(), ParticleTypes.field_197592_C, ParticleTypes.field_197633_z, ParticleTypes.field_197609_b, ParticleTypes.field_197607_R};

    public static void onMessageReceived(MessageToClient message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.CLIENT) {
            Reference.LOGGER.warn("MessageToClient received on wrong side:" + ctx.getDirection().getReceptionSide());
            return;
        }
        if (!message.isMessageValid()) {
            Reference.LOGGER.warn("MessageToClient was invalid" + message.toString());
            return;
        }
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            Reference.LOGGER.warn("MessageToClient context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> MessageHandlerOnClient.processMessage((ClientWorld)clientWorld.get(), message));
    }

    private static void processMessage(ClientWorld worldClient, MessageToClient message) {
        switch (message.getMessageType()) {
            case 1: {
                SpawnParticleMessage _message = (SpawnParticleMessage)message;
                for (int i = 0; i < _message.getIteration(); ++i) {
                    Vec3d targetCoordinates = _message.getTargetCoordinates();
                    Vec3d targetSpeed = _message.getTargetSpeed();
                    double spread = _message.getParticleSpread();
                    double spawnXpos = targetCoordinates.field_72450_a;
                    double spawnYpos = targetCoordinates.field_72448_b;
                    double spawnZpos = targetCoordinates.field_72449_c;
                    double speedX = targetSpeed.field_72450_a;
                    double speedY = targetSpeed.field_72448_b;
                    double speedZ = targetSpeed.field_72449_c;
                    worldClient.func_195590_a((IParticleData)types[_message.getPartcleType()], true, MathHelper.func_219803_d((double)worldClient.field_73012_v.nextDouble(), (double)(spawnXpos + spread), (double)(spawnXpos - spread)), spawnYpos, MathHelper.func_219803_d((double)worldClient.field_73012_v.nextDouble(), (double)(spawnZpos + spread), (double)(spawnZpos - spread)), speedX, speedY, speedZ);
                }
                break;
            }
        }
    }

    public static boolean isThisProtocolAcceptedByClient(String protocolVersion) {
        return "1.0".equals(protocolVersion);
    }
}

