/*
 * Decompiled with CFR 0.152.
 */
package com.hoopawolf.dmm.network;

import com.hoopawolf.dmm.network.packets.server.MessageToServer;
import com.hoopawolf.dmm.network.packets.server.SetPotionEffectMessage;
import com.hoopawolf.dmm.network.packets.server.SetPotionEffectMultipleMessage;
import com.hoopawolf.dmm.ref.Reference;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageHandlerOnServer {
    static final Effect[] types = new Effect[]{Effects.field_76436_u, Effects.field_76421_d, Effects.field_76437_t, Effects.field_76431_k};

    public static void onMessageReceived(MessageToServer message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.SERVER) {
            Reference.LOGGER.warn("MessageToServer received on wrong side:" + ctx.getDirection().getReceptionSide());
            return;
        }
        if (!message.isMessageValid()) {
            Reference.LOGGER.warn("MessageToServer was invalid" + message.toString());
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Reference.LOGGER.warn("EntityPlayerMP was null when MessageToServer was received");
        }
        ctx.enqueueWork(() -> MessageHandlerOnServer.processMessage(message, sendingPlayer));
    }

    static void processMessage(MessageToServer message, ServerPlayerEntity sendingPlayer) {
        switch (message.getMessageType()) {
            case 0: {
                SetPotionEffectMessage _message = (SetPotionEffectMessage)message;
                Entity _entity = sendingPlayer.field_70170_p.func_73045_a(_message.getEntityID());
                if (_entity == null || !(_entity instanceof LivingEntity) || !_entity.func_70089_S()) break;
                ((LivingEntity)_entity).func_195064_c(new EffectInstance(types[_message.getPotionType()], _message.getDuration(), _message.getAmplifier()));
                break;
            }
            case 1: {
                SetPotionEffectMultipleMessage _message = (SetPotionEffectMultipleMessage)message;
                Entity _entity = sendingPlayer.field_70170_p.func_73045_a(_message.getEntityID());
                if (_entity == null || !(_entity instanceof LivingEntity) || !_entity.func_70089_S()) break;
                int max = MathHelper.func_76125_a((int)_message.getEnding(), (int)0, (int)(types.length - 1));
                for (int i = _message.getStarting(); i <= max; ++i) {
                    ((LivingEntity)_entity).func_195064_c(new EffectInstance(types[i], _message.getDuration(), _message.getAmplifier()));
                }
                break;
            }
        }
    }

    public static boolean isThisProtocolAcceptedByServer(String protocolVersion) {
        return "1.0".equals(protocolVersion);
    }
}

