/*
 * Decompiled with CFR 0.152.
 */
package com.hoopawolf.dmm.network.packets.client;

import com.hoopawolf.dmm.network.packets.client.MessageToClient;
import com.hoopawolf.dmm.ref.Reference;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;

public class SpawnParticleMessage
extends MessageToClient {
    private Vec3d targetCoordinates;
    private Vec3d targetSpeed;
    private int iteration;
    private int particle_type;
    private double spread;

    public SpawnParticleMessage(Vec3d i_targetCoordinates, Vec3d i_targetSpeed, int _iteration, int _particle_type, double _spread) {
        this.messageIsValid = true;
        this.messageType = 1;
        this.targetCoordinates = i_targetCoordinates;
        this.targetSpeed = i_targetSpeed;
        this.iteration = _iteration;
        this.particle_type = _particle_type;
        this.spread = _spread;
    }

    public SpawnParticleMessage() {
        this.messageIsValid = false;
    }

    public static SpawnParticleMessage decode(PacketBuffer buf) {
        double spreadDist;
        double speedz;
        double speedy;
        double speedx;
        double z;
        double y;
        double x;
        int iterationAmount;
        int particletype;
        try {
            particletype = buf.readInt();
            iterationAmount = buf.readInt();
            x = buf.readDouble();
            y = buf.readDouble();
            z = buf.readDouble();
            speedx = buf.readDouble();
            speedy = buf.readDouble();
            speedz = buf.readDouble();
            spreadDist = buf.readDouble();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Reference.LOGGER.warn("Exception while reading SpawnParticleMessageToClient: " + e);
            return new SpawnParticleMessage();
        }
        return new SpawnParticleMessage(new Vec3d(x, y, z), new Vec3d(speedx, speedy, speedz), iterationAmount, particletype, spreadDist);
    }

    public Vec3d getTargetCoordinates() {
        return this.targetCoordinates;
    }

    public Vec3d getTargetSpeed() {
        return this.targetSpeed;
    }

    public int getIteration() {
        return this.iteration;
    }

    public int getPartcleType() {
        return this.particle_type;
    }

    public double getParticleSpread() {
        return this.spread;
    }

    @Override
    public void encode(PacketBuffer buf) {
        if (!this.messageIsValid) {
            return;
        }
        buf.writeInt(this.particle_type);
        buf.writeInt(this.iteration);
        buf.writeDouble(this.targetCoordinates.field_72450_a);
        buf.writeDouble(this.targetCoordinates.field_72448_b);
        buf.writeDouble(this.targetCoordinates.field_72449_c);
        buf.writeDouble(this.targetSpeed.field_72450_a);
        buf.writeDouble(this.targetSpeed.field_72448_b);
        buf.writeDouble(this.targetSpeed.field_72449_c);
        buf.writeDouble(this.spread);
    }

    @Override
    public String toString() {
        return "SpawnParticleMessageToClient[targetCoordinates=" + this.targetCoordinates + "]";
    }
}

