/*
 * Decompiled with CFR 0.152.
 */
package com.hoopawolf.dmm.structure;

import com.hoopawolf.dmm.config.ConfigHandler;
import com.hoopawolf.dmm.ref.Reference;
import com.hoopawolf.dmm.structure.piece.SwordStructurePiece;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.Level;

public class SwordStructure
extends Structure<NoFeatureConfig> {
    public SwordStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxDistance = (Integer)ConfigHandler.COMMON.minStructureAway.get();
        int minDistance = (Integer)ConfigHandler.COMMON.maxStructureAway.get();
        int xTemp = x + maxDistance * spacingOffsetsX;
        int ztemp = z + maxDistance * spacingOffsetsZ;
        int xTemp2 = xTemp < 0 ? xTemp - maxDistance + 1 : xTemp;
        int zTemp2 = ztemp < 0 ? ztemp - maxDistance + 1 : ztemp;
        int validChunkX = xTemp2 / maxDistance;
        int validChunkZ = zTemp2 / maxDistance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), validChunkX, validChunkZ, this.getSeedModifier());
        validChunkX *= maxDistance;
        validChunkZ *= maxDistance;
        return new ChunkPos(validChunkX += random.nextInt(maxDistance + minDistance), validChunkZ += random.nextInt(maxDistance + minDistance));
    }

    public String func_143025_a() {
        return "vrm:swordstructure";
    }

    public int func_202367_b() {
        return 0;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    protected int getSeedModifier() {
        return 62353535;
    }

    public boolean func_225558_a_(BiomeManager p_225558_1_, ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ, Biome biome) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b && rand.nextInt(100) < (Integer)ConfigHandler.COMMON.structureSpawnChance.get()) {
            return chunkGen.func_202094_a(biome, (Structure)this);
        }
        return false;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            int surfaceY = generator.func_222531_c(x, z, Heightmap.Type.WORLD_SURFACE_WG);
            BlockPos blockpos = new BlockPos(x, surfaceY, z);
            SwordStructurePiece.start(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
            Reference.LOGGER.log(Level.DEBUG, "Sword Structure at " + blockpos.func_177958_n() + " " + blockpos.func_177956_o() + " " + blockpos.func_177952_p());
        }
    }
}

