/*
 * Decompiled with CFR 0.152.
 */
package com.hoopawolf.dmm.util;

import com.hoopawolf.dmm.entities.ai.DazedGoal;
import com.hoopawolf.dmm.entities.projectiles.PesArrowEntity;
import com.hoopawolf.dmm.items.weapons.DeathSwordItem;
import com.hoopawolf.dmm.network.VRMPacketHandler;
import com.hoopawolf.dmm.network.packets.client.SpawnParticleMessage;
import com.hoopawolf.dmm.util.ItemBlockRegistryHandler;
import com.hoopawolf.dmm.util.PotionRegistryHandler;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="vrm")
public class VRMEventHandler {
    @SubscribeEvent
    public static void DeathEvent(LivingDeathEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            LivingEntity target;
            if (event.getEntity() instanceof PlayerEntity && event.getSource().func_76346_g() instanceof LivingEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntity();
                LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
                if (player.func_184614_ca().func_77973_b().equals(ItemBlockRegistryHandler.DEATH_SWORD.get()) && DeathSwordItem.getDeathCoolDown(player.func_184614_ca()) <= 0) {
                    event.setCanceled(true);
                    attacker.func_70097_a(new DamageSource("death"), attacker.func_110138_aP() * 0.5f);
                    player.func_70606_j(player.func_110138_aP() * 0.5f);
                    player.func_71024_bL().func_75114_a(20);
                    DeathSwordItem.setDeathCoolDown(player.func_184614_ca(), 600);
                    player.func_213823_a(SoundEvents.field_193782_bq, SoundCategory.BLOCKS, 5.0f, 0.1f);
                    for (int i = 1; i <= 180; ++i) {
                        double yaw = i * 360 / 180;
                        double speed = 0.3;
                        double xSpeed = speed * Math.cos(Math.toRadians(yaw));
                        double zSpeed = speed * Math.sin(Math.toRadians(yaw));
                        SpawnParticleMessage spawnParticleMessage = new SpawnParticleMessage(new Vec3d(player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_()), new Vec3d(xSpeed, 0.0, zSpeed), 3, 4, 0.0);
                        VRMPacketHandler.packetHandler.sendToDimension(player.field_71093_bK, spawnParticleMessage);
                    }
                }
            }
            if (event.getEntity() instanceof LivingEntity && ((target = (LivingEntity)event.getEntity()).func_70644_a((Effect)PotionRegistryHandler.PLAGUE_EFFECT.get()) || event.getSource().func_76364_f() instanceof PesArrowEntity)) {
                target.func_184185_a(SoundEvents.field_203825_gn, 0.5f, 0.1f);
                for (int i = 1; i <= 180; ++i) {
                    double yaw = i * 360 / 180;
                    double speed = 0.7;
                    double xSpeed = speed * Math.cos(Math.toRadians(yaw));
                    double zSpeed = speed * Math.sin(Math.toRadians(yaw));
                    SpawnParticleMessage spawnParticleMessage = new SpawnParticleMessage(new Vec3d(target.func_226277_ct_(), target.func_226278_cu_() + 0.5, target.func_226281_cx_()), new Vec3d(xSpeed, 0.9, zSpeed), 3, 5, 0.0);
                    VRMPacketHandler.packetHandler.sendToDimension(target.field_71093_bK, spawnParticleMessage);
                }
            }
        }
    }

    @SubscribeEvent
    public static void HurtEvent(LivingHurtEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            if (event.getEntity() instanceof CreatureEntity && ((CreatureEntity)event.getEntity()).func_70644_a((Effect)PotionRegistryHandler.DAZED_EFFECT.get())) {
                ((CreatureEntity)event.getEntity()).func_195063_d((Effect)PotionRegistryHandler.DAZED_EFFECT.get());
            }
            if (event.getEntity() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntity();
                if (player.func_184614_ca().func_77973_b().equals(ItemBlockRegistryHandler.DEATH_SWORD.get()) && DeathSwordItem.getVoodooID(player.func_184614_ca()) != 0 && player.field_70170_p.func_73045_a(DeathSwordItem.getVoodooID(player.func_184614_ca())) != null && player.field_70170_p.func_73045_a(DeathSwordItem.getVoodooID(player.func_184614_ca())).func_70089_S()) {
                    event.setCanceled(true);
                    player.field_70170_p.func_73045_a(DeathSwordItem.getVoodooID(player.func_184614_ca())).func_70097_a(new DamageSource("reaper"), event.getAmount());
                    player.func_213823_a(SoundEvents.field_191265_hd, SoundCategory.BLOCKS, 5.0f, 0.1f);
                }
                if (player.field_70170_p.field_73012_v.nextInt(100) < 40 && (player.func_184614_ca().func_77973_b().equals(ItemBlockRegistryHandler.FAM_SCALE.get()) || player.func_184592_cb().func_77973_b().equals(ItemBlockRegistryHandler.FAM_SCALE.get()))) {
                    if (event.getSource().func_76346_g() instanceof CreatureEntity) {
                        ((CreatureEntity)event.getSource().func_76346_g()).func_195064_c(new EffectInstance(new EffectInstance((Effect)PotionRegistryHandler.DAZED_EFFECT.get(), 100)));
                        SpawnParticleMessage spawnParticleMessage = new SpawnParticleMessage(new Vec3d(event.getSource().func_76346_g().func_226277_ct_(), event.getSource().func_76346_g().func_226278_cu_() + 0.5, event.getSource().func_76346_g().func_226281_cx_()), new Vec3d(0.0, 0.0, 0.0), 3, 9, event.getSource().func_76346_g().func_213311_cf());
                        VRMPacketHandler.packetHandler.sendToDimension(event.getSource().func_76346_g().field_71093_bK, spawnParticleMessage);
                    }
                    player.func_213823_a(SoundEvents.field_219665_hd, SoundCategory.BLOCKS, 5.0f, 0.1f);
                }
                if (player.func_110143_aJ() < player.func_110138_aP() * 0.3f && player.func_184614_ca().func_77973_b().equals(ItemBlockRegistryHandler.WAR_SWORD.get()) && event.getSource().func_76346_g() instanceof LivingEntity) {
                    event.getSource().func_76346_g().func_70015_d(10);
                    player.func_213823_a(SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 5.0f, 0.1f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void ApplyPotionEvent(PotionEvent.PotionApplicableEvent event) {
        PlayerEntity player;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntity()).func_184614_ca().func_77973_b().equals(ItemBlockRegistryHandler.PES_BOW.get()) && !event.getPotionEffect().func_188419_a().func_188408_i()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        World world = entity.field_70170_p;
        if (!world.field_72995_K) {
            if (entity instanceof CreatureEntity) {
                ((CreatureEntity)entity).field_70714_bg.func_75776_a(0, (Goal)new DazedGoal((LivingEntity)((CreatureEntity)entity)));
            }
            if (entity instanceof CowEntity || entity instanceof RabbitEntity || entity instanceof SheepEntity || entity instanceof AbstractHorseEntity || entity instanceof PigEntity || entity instanceof ChickenEntity) {
                ((AnimalEntity)entity).func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
                ((AnimalEntity)entity).func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
                ((AnimalEntity)entity).func_110148_a(SharedMonsterAttributes.field_221120_g).func_111128_a(1.0);
                ((AnimalEntity)entity).field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)((AnimalEntity)entity), 1.0, true));
            }
        }
    }
}

