/*
 * Decompiled with CFR 0.152.
 */
package com.hoopawolf.dmm.blocks.tileentity;

import com.hoopawolf.dmm.blocks.tileentity.RuneTileEntity;
import com.hoopawolf.dmm.network.VRMPacketHandler;
import com.hoopawolf.dmm.network.packets.client.SpawnParticleMessage;
import com.hoopawolf.dmm.util.ItemBlockRegistryHandler;
import com.hoopawolf.dmm.util.TileEntityRegistryHandler;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SwordStoneTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final BlockPos[] runePos = new BlockPos[]{new BlockPos(2, 1, 2), new BlockPos(-2, 1, -2), new BlockPos(-2, 1, 2), new BlockPos(2, 1, -2)};
    private static final EntityType[] firePhase = new EntityType[]{EntityType.field_200792_f, EntityType.field_200771_K, EntityType.field_233592_ba_};
    private static final EntityType[] heavyPhase = new EntityType[]{EntityType.field_200759_ay, EntityType.field_200755_au, EntityType.field_200740_af};
    private static final EntityType[] slowPhase = new EntityType[]{EntityType.field_200725_aD, EntityType.field_200741_ag, EntityType.field_200748_an};
    private static final EntityType[] witherPhase = new EntityType[]{EntityType.field_200722_aA, EntityType.field_200794_h, EntityType.field_200758_ax, EntityType.field_200806_t};
    private static final ArrayList<EntityType[]> phraseList = new ArrayList();
    private float timer = 0.0f;
    private float degree = 0.0f;
    private boolean activated;
    private boolean activatedDone;
    private UUID player = null;

    public SwordStoneTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        phraseList.add(firePhase);
        phraseList.add(slowPhase);
        phraseList.add(heavyPhase);
        phraseList.add(witherPhase);
    }

    public SwordStoneTileEntity() {
        this((TileEntityType)TileEntityRegistryHandler.SWORD_STONE_TILE_ENTITY.get());
    }

    public boolean anyPlayerInRange() {
        return this.player != null && this.field_145850_b.func_217371_b(this.player) != null && Objects.requireNonNull(this.field_145850_b.func_217371_b(this.player)).func_70092_e((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()) < 60.0;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean flag) {
        this.activated = flag;
    }

    public boolean isDone() {
        return this.activatedDone;
    }

    public void setDone(boolean flag) {
        this.activatedDone = flag;
    }

    public float getDegree() {
        return this.degree;
    }

    public float getTimer() {
        return this.timer;
    }

    public void setUUID(UUID _uuidIn) {
        this.player = _uuidIn;
    }

    public void func_73660_a() {
        if (!this.isDone()) {
            for (BlockPos pos : runePos) {
                if (this.field_145850_b.func_180495_p(new BlockPos(this.func_174877_v().func_177958_n() + pos.func_177958_n(), this.func_174877_v().func_177956_o() + pos.func_177956_o(), this.func_174877_v().func_177952_p() + pos.func_177952_p())).hasTileEntity() && this.field_145850_b.func_175625_s(new BlockPos(this.func_174877_v().func_177958_n() + pos.func_177958_n(), this.func_174877_v().func_177956_o() + pos.func_177956_o(), this.func_174877_v().func_177952_p() + pos.func_177952_p())) instanceof RuneTileEntity) {
                    if (((RuneTileEntity)Objects.requireNonNull(this.field_145850_b.func_175625_s(new BlockPos(this.func_174877_v().func_177958_n() + pos.func_177958_n(), this.func_174877_v().func_177956_o() + pos.func_177956_o(), this.func_174877_v().func_177952_p() + pos.func_177952_p())))).isActivated()) continue;
                    this.resetData();
                    break;
                }
                this.resetData();
                break;
            }
            if (this.isActivated()) {
                if (!this.anyPlayerInRange()) {
                    this.resetData();
                } else {
                    if (this.timer <= 0.0f) {
                        if (!this.field_145850_b.field_72995_K) {
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_193782_bq, SoundCategory.BLOCKS, 2.0f, 0.1f);
                            ((ServerWorld)this.field_145850_b.func_201672_e()).func_241113_a_(0, 6000, true, true);
                        }
                    } else if (this.timer % 150.0f == 0.0f && !this.field_145850_b.field_72995_K) {
                        int max = this.field_145850_b.field_73012_v.nextInt(8) + 5;
                        for (int i = 0; i < max; ++i) {
                            MobEntity entity = (MobEntity)phraseList.get((int)this.timer / 150 - 1)[this.field_145850_b.field_73012_v.nextInt(3)].func_200721_a(this.field_145850_b);
                            entity.func_70012_b((double)(this.func_174877_v().func_177958_n() + (this.field_145850_b.field_73012_v.nextInt(5) - this.field_145850_b.field_73012_v.nextInt(5))), (double)this.func_174877_v().func_177956_o() + 1.0, (double)(this.func_174877_v().func_177952_p() + (this.field_145850_b.field_73012_v.nextInt(5) - this.field_145850_b.field_73012_v.nextInt(5))), 0.0f, 0.0f);
                            entity.func_70624_b((LivingEntity)this.field_145850_b.func_217371_b(this.player));
                            if (entity instanceof SkeletonEntity) {
                                entity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151031_f));
                            } else if (entity instanceof ZombifiedPiglinEntity || entity instanceof WitherSkeletonEntity) {
                                entity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151052_q));
                            }
                            this.field_145850_b.func_217376_c((Entity)entity);
                        }
                    }
                    this.timer += 0.5f;
                    if (!this.field_145850_b.field_72995_K) {
                        for (BlockPos pos : runePos) {
                            Vector3d block = new Vector3d((double)(this.func_174877_v().func_177958_n() + pos.func_177958_n()) + 0.5, (double)(this.func_174877_v().func_177956_o() + pos.func_177956_o()) + 1.75, (double)(this.func_174877_v().func_177952_p() + pos.func_177952_p()) + 0.5);
                            Vector3d dir = new Vector3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5).func_178788_d(new Vector3d(block.func_82615_a(), block.func_82617_b(), block.func_82616_c())).func_72432_b();
                            SpawnParticleMessage particleFireworks = new SpawnParticleMessage(new Vector3d(block.func_82615_a(), block.func_82617_b(), block.func_82616_c()), new Vector3d(dir.func_82615_a(), dir.func_82617_b(), dir.func_82616_c()), 3, 1, 0.0);
                            VRMPacketHandler.packetHandler.sendToDimension((RegistryKey<World>)this.field_145850_b.func_234923_W_(), particleFireworks);
                            SpawnParticleMessage particleEndrod = new SpawnParticleMessage(new Vector3d(block.func_82615_a(), block.func_82617_b(), block.func_82616_c()), new Vector3d(dir.func_82615_a(), dir.func_82617_b(), dir.func_82616_c()), 3, 2, 0.0);
                            VRMPacketHandler.packetHandler.sendToDimension((RegistryKey<World>)this.field_145850_b.func_234923_W_(), particleEndrod);
                        }
                    }
                    if (this.getTimer() > 600.0f) {
                        this.setDone(true);
                        if (!this.field_145850_b.field_72995_K) {
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187802_ec, SoundCategory.BLOCKS, 2.0f, 0.1f);
                            ((ServerWorld)this.field_145850_b.func_201672_e()).func_241113_a_(6000, 0, false, false);
                        }
                        for (BlockPos pos : runePos) {
                            this.field_145850_b.func_175656_a(new BlockPos(this.func_174877_v().func_177958_n() + pos.func_177958_n(), this.func_174877_v().func_177956_o() + pos.func_177956_o(), this.func_174877_v().func_177952_p() + pos.func_177952_p()), Blocks.field_150350_a.func_176223_P());
                        }
                    }
                }
            }
        }
        if (this.getTimer() > 300.0f) {
            this.degree += 0.5f;
        }
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.activated = compound.func_74767_n("activated");
        this.activatedDone = compound.func_74767_n("activatedDone");
        this.timer = compound.func_74760_g("timer");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("activated", this.activated);
        compound.func_74757_a("activatedDone", this.activatedDone);
        compound.func_74776_a("timer", this.timer);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 3, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    private void resetData() {
        this.timer = 0.0f;
        this.degree = 0.0f;
        this.setActivated(false);
    }

    public Item getActivationItem() {
        return this.isDone() ? (Item)ItemBlockRegistryHandler.VULCAN_SWORD.get() : Items.field_151052_q;
    }
}

