/*
 * Decompiled with CFR 0.152.
 */
package com.hoopawolf.dmm.helper;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EntityHelper {
    public static double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.func_226281_cx_() - first.func_226281_cx_(), second.func_226277_ct_() - first.func_226277_ct_()) * 57.29577951308232 + 90.0;
    }

    public static void sendCoolDownMessage(PlayerEntity entityIn, int cooldownIn) {
        String message = "";
        message = cooldownIn > 0 ? "message.vrm.cooldown" : "message.vrm.error";
        entityIn.func_145747_a((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)message, (Object[])new Object[0]) + (cooldownIn > 0 ? " " + cooldownIn / 20 + "s" : "")).func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), entityIn.func_110124_au());
    }

    public static List<PlayerEntity> getPlayersNearby(Entity ent, double distanceX, double distanceY, double distanceZ, double radius) {
        List nearbyEntities = ent.field_70170_p.func_72839_b(ent, ent.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        return nearbyEntities.stream().filter(entityNeighbor -> entityNeighbor instanceof PlayerEntity && (double)ent.func_70032_d(entityNeighbor) <= radius).map(entityNeighbor -> (PlayerEntity)entityNeighbor).collect(Collectors.toList());
    }

    public static List<LivingEntity> getEntityLivingBaseNearby(Entity ent, double distanceX, double distanceY, double distanceZ, double radius) {
        return EntityHelper.getEntitiesNearby(ent, LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public static <T extends Entity> List<T> getEntitiesNearby(Entity ent, Class<T> entityClass, double r) {
        return ent.field_70170_p.func_175647_a(entityClass, ent.func_174813_aQ().func_72314_b(r, r, r), e -> e != ent && (double)ent.func_70032_d(e) <= r);
    }

    public static <T extends Entity> List<T> getEntitiesNearby(Entity ent, Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return ent.field_70170_p.func_175647_a(entityClass, ent.func_174813_aQ().func_72314_b(dX, dY, dZ), e -> e != ent && (double)ent.func_70032_d(e) <= r && e.func_226278_cu_() <= ent.func_226278_cu_() + dY);
    }

    public static <T extends Entity> List<T> getEntitiesNearbyWithPos(World world, AxisAlignedBB box, BlockPos pos, Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return world.func_175647_a(entityClass, box.func_72314_b(dX, dY, dZ), e -> pos.func_218137_a((IPosition)e.func_213303_ch(), r) && e.func_226278_cu_() <= (double)pos.func_177956_o() + dY);
    }
}

