/*
 * Decompiled with CFR 0.152.
 */
package com.hoopawolf.dmm.items.weapons;

import com.hoopawolf.dmm.helper.EntityHelper;
import com.hoopawolf.dmm.network.VRMPacketHandler;
import com.hoopawolf.dmm.network.packets.client.SpawnParticleMessage;
import com.hoopawolf.dmm.tab.VRMItemGroup;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DeathSwordItem
extends SwordItem {
    public DeathSwordItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder.func_200916_a((ItemGroup)VRMItemGroup.instance).func_208103_a(Rarity.UNCOMMON));
    }

    public static int getVoodooCoolDown(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_196082_o().func_74768_a("voodoo", 0);
        }
        return stack.func_77978_p().func_74762_e("voodoo");
    }

    public static int getDeathCoolDown(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_196082_o().func_74768_a("death", 0);
        }
        return stack.func_77978_p().func_74762_e("death");
    }

    public static int getMarkCoolDown(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_196082_o().func_74768_a("mark", 0);
        }
        return stack.func_77978_p().func_74762_e("mark");
    }

    public static int getVoodooID(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_196082_o().func_74768_a("voodooid", 0);
        }
        return stack.func_77978_p().func_74762_e("voodooid");
    }

    public static void setVoodooCoolDown(ItemStack stack, int amount) {
        stack.func_196082_o().func_74768_a("voodoo", amount);
    }

    public static void setDeathCoolDown(ItemStack stack, int amount) {
        stack.func_196082_o().func_74768_a("death", amount);
    }

    public static void setMarkCoolDown(ItemStack stack, int amount) {
        stack.func_196082_o().func_74768_a("mark", amount);
    }

    public static void setVoodooID(ItemStack stack, int id) {
        stack.func_196082_o().func_74768_a("voodooid", id);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!playerIn.func_213453_ef() && handIn.equals((Object)Hand.MAIN_HAND)) {
            if (DeathSwordItem.getMarkCoolDown(playerIn.func_184586_b(handIn)) <= 0) {
                if (!worldIn.field_72995_K) {
                    DeathSwordItem.setMarkCoolDown(playerIn.func_184586_b(handIn), 200);
                    for (LivingEntity entity : EntityHelper.getEntityLivingBaseNearby((Entity)playerIn, 5.0, 2.0, 5.0, 10.0)) {
                        entity.func_195064_c(new EffectInstance(Effects.field_188423_x, 180, 1));
                    }
                    playerIn.func_213823_a(SoundEvents.field_203639_hT, SoundCategory.BLOCKS, 5.0f, 0.1f);
                }
            } else if (!worldIn.field_72995_K) {
                playerIn.func_213823_a(SoundEvents.field_187676_dE, SoundCategory.BLOCKS, 5.0f, 0.1f);
            } else {
                EntityHelper.sendCoolDownMessage(playerIn, DeathSwordItem.getMarkCoolDown(playerIn.func_184586_b(handIn)));
            }
        }
        return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (playerIn.func_213453_ef() && hand.equals((Object)Hand.MAIN_HAND)) {
            if (DeathSwordItem.getVoodooCoolDown(playerIn.func_184586_b(hand)) <= 0) {
                if (!playerIn.field_70170_p.field_72995_K) {
                    DeathSwordItem.setVoodooCoolDown(playerIn.func_184586_b(hand), 200);
                    DeathSwordItem.setVoodooID(playerIn.func_184586_b(hand), target.func_145782_y());
                    playerIn.func_213823_a(SoundEvents.field_193789_dh, SoundCategory.BLOCKS, 5.0f, 0.1f);
                    return ActionResultType.SUCCESS;
                }
            } else if (!playerIn.field_70170_p.field_72995_K) {
                playerIn.func_213823_a(SoundEvents.field_187676_dE, SoundCategory.BLOCKS, 5.0f, 0.1f);
            } else {
                EntityHelper.sendCoolDownMessage(playerIn, DeathSwordItem.getVoodooCoolDown(playerIn.func_184586_b(hand)));
            }
        }
        return ActionResultType.FAIL;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.func_77644_a(stack, target, attacker);
        if (attacker.field_70170_p.field_73012_v.nextInt(100) < 30 || target.func_70644_a(Effects.field_188423_x)) {
            attacker.func_70691_i(this.func_200894_d() * 0.5f);
        }
        if (target.func_70644_a(Effects.field_188423_x)) {
            target.func_70097_a(new DamageSource("reaper"), this.func_200894_d() * 2.0f);
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            Entity entity;
            if (entityIn.field_70173_aa % 2 == 0) {
                if (DeathSwordItem.getDeathCoolDown(stack) > 0) {
                    DeathSwordItem.setDeathCoolDown(stack, DeathSwordItem.getDeathCoolDown(stack) - 1);
                }
                if (DeathSwordItem.getMarkCoolDown(stack) > 0) {
                    DeathSwordItem.setMarkCoolDown(stack, DeathSwordItem.getMarkCoolDown(stack) - 1);
                }
                if (DeathSwordItem.getVoodooCoolDown(stack) > 0) {
                    DeathSwordItem.setVoodooCoolDown(stack, DeathSwordItem.getVoodooCoolDown(stack) - 1);
                } else if (DeathSwordItem.getVoodooCoolDown(stack) <= 0 && DeathSwordItem.getVoodooID(stack) != 0) {
                    DeathSwordItem.setVoodooID(stack, 0);
                }
                if (worldIn.func_73045_a(DeathSwordItem.getVoodooID(stack)) == null || !worldIn.func_73045_a(DeathSwordItem.getVoodooID(stack)).func_70089_S()) {
                    DeathSwordItem.setVoodooID(stack, 0);
                }
            }
            if (DeathSwordItem.getVoodooID(stack) != 0 && (entity = worldIn.func_73045_a(DeathSwordItem.getVoodooID(stack))) != null) {
                SpawnParticleMessage spawnParticleMessage = new SpawnParticleMessage(new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() + 0.5, entity.func_226281_cx_()), new Vector3d(0.0, 0.0, 0.0), 1, 3, 0.0);
                VRMPacketHandler.packetHandler.sendToDimension((RegistryKey<World>)entity.field_70170_p.func_234923_W_(), spawnParticleMessage);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"tooltip.vrm:death1", (Object[])new Object[0])).func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.LIGHT_PURPLE)));
        tooltip.add((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"tooltip.vrm:death2", (Object[])new Object[0]) + (DeathSwordItem.getMarkCoolDown(stack) > 0 ? " [" + DeathSwordItem.getMarkCoolDown(stack) / 20 + "s]" : "")).func_240703_c_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(DeathSwordItem.getMarkCoolDown(stack) > 0 ? TextFormatting.DARK_GRAY : TextFormatting.GRAY)));
        tooltip.add((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"tooltip.vrm:death3", (Object[])new Object[0]) + (DeathSwordItem.getVoodooCoolDown(stack) > 0 ? " [" + DeathSwordItem.getVoodooCoolDown(stack) / 20 + "s]" : "")).func_240703_c_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(DeathSwordItem.getVoodooCoolDown(stack) > 0 ? TextFormatting.DARK_GRAY : TextFormatting.GRAY)));
        tooltip.add((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"tooltip.vrm:death4", (Object[])new Object[0]) + (DeathSwordItem.getDeathCoolDown(stack) > 0 ? " [" + DeathSwordItem.getDeathCoolDown(stack) / 20 + "s]" : "")).func_240703_c_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(DeathSwordItem.getDeathCoolDown(stack) > 0 ? TextFormatting.DARK_GRAY : TextFormatting.GRAY)));
    }
}

