/*
 * Decompiled with CFR 0.152.
 */
package com.hoopawolf.dmm.items.weapons;

import com.hoopawolf.dmm.helper.EntityHelper;
import com.hoopawolf.dmm.network.VRMPacketHandler;
import com.hoopawolf.dmm.network.packets.client.SpawnParticleMessage;
import com.hoopawolf.dmm.tab.VRMItemGroup;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WarSwordItem
extends SwordItem {
    public WarSwordItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder.func_200916_a((ItemGroup)VRMItemGroup.instance).func_208103_a(Rarity.UNCOMMON));
    }

    public static int getWarCryCoolDown(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_196082_o().func_74768_a("warcry", 0);
        }
        return stack.func_77978_p().func_74762_e("warcry");
    }

    public static int getRageCoolDown(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_196082_o().func_74768_a("rage", 0);
        }
        return stack.func_77978_p().func_74762_e("rage");
    }

    public static void setWarCryCoolDown(ItemStack stack, int amount) {
        stack.func_196082_o().func_74768_a("warcry", amount);
    }

    public static void setRageCoolDown(ItemStack stack, int amount) {
        stack.func_196082_o().func_74768_a("rage", amount);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            if (!playerIn.func_213453_ef() && handIn.equals((Object)Hand.MAIN_HAND)) {
                if (WarSwordItem.getWarCryCoolDown(playerIn.func_184586_b(handIn)) <= 0) {
                    WarSwordItem.setWarCryCoolDown(playerIn.func_184586_b(handIn), 200);
                    playerIn.func_195064_c(new EffectInstance(Effects.field_76420_g, 150, 3));
                    playerIn.func_195064_c(new EffectInstance(Effects.field_76429_m, 150, 3));
                    if (playerIn.func_110143_aJ() < playerIn.func_110138_aP() * 0.3f) {
                        playerIn.func_195064_c(new EffectInstance(Effects.field_76444_x, 150, 3));
                    }
                    playerIn.func_213823_a(SoundEvents.field_187527_aQ, SoundCategory.BLOCKS, 5.0f, 0.1f);
                } else {
                    playerIn.func_213823_a(SoundEvents.field_187676_dE, SoundCategory.BLOCKS, 5.0f, 0.1f);
                    EntityHelper.sendCoolDownMessage(playerIn, WarSwordItem.getWarCryCoolDown(playerIn.func_184586_b(handIn)));
                }
            } else if (handIn.equals((Object)Hand.MAIN_HAND)) {
                if (WarSwordItem.getRageCoolDown(playerIn.func_184586_b(handIn)) <= 0) {
                    WarSwordItem.setRageCoolDown(playerIn.func_184586_b(handIn), 200);
                    CreatureEntity temp = null;
                    for (LivingEntity entity : EntityHelper.getEntityLivingBaseNearby((Entity)playerIn, 10.0, 2.0, 10.0, 15.0)) {
                        if (!(entity instanceof CreatureEntity)) continue;
                        if (temp == null) {
                            temp = (CreatureEntity)entity;
                            continue;
                        }
                        ((CreatureEntity)entity).func_70624_b((LivingEntity)temp);
                        temp.func_70624_b(entity);
                        SpawnParticleMessage mob1 = new SpawnParticleMessage(new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + 0.5, entity.func_226281_cx_()), new Vector3d(0.0, 0.0, 0.0), 3, 8, temp.func_213311_cf());
                        VRMPacketHandler.packetHandler.sendToDimension((RegistryKey<World>)playerIn.field_70170_p.func_234923_W_(), mob1);
                        SpawnParticleMessage mob2 = new SpawnParticleMessage(new Vector3d(temp.func_226277_ct_(), temp.func_226278_cu_() + 0.5, temp.func_226281_cx_()), new Vector3d(0.0, 0.0, 0.0), 3, 0, temp.func_213311_cf());
                        VRMPacketHandler.packetHandler.sendToDimension((RegistryKey<World>)playerIn.field_70170_p.func_234923_W_(), mob2);
                        temp = null;
                    }
                    for (int i = 1; i <= 180; ++i) {
                        double yaw = i * 360 / 180;
                        double speed = 1.5;
                        double xSpeed = speed * Math.cos(Math.toRadians(yaw));
                        double zSpeed = speed * Math.sin(Math.toRadians(yaw));
                        SpawnParticleMessage spawnParticleMessage = new SpawnParticleMessage(new Vector3d(playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + 0.5, playerIn.func_226281_cx_()), new Vector3d(xSpeed, 0.0, zSpeed), 3, 0, 0.0);
                        VRMPacketHandler.packetHandler.sendToDimension((RegistryKey<World>)playerIn.field_70170_p.func_234923_W_(), spawnParticleMessage);
                    }
                    playerIn.func_213823_a(SoundEvents.field_187525_aO, SoundCategory.BLOCKS, 5.0f, 0.1f);
                } else {
                    playerIn.func_213823_a(SoundEvents.field_187676_dE, SoundCategory.BLOCKS, 5.0f, 0.1f);
                    EntityHelper.sendCoolDownMessage(playerIn, WarSwordItem.getRageCoolDown(playerIn.func_184586_b(handIn)));
                }
            }
        }
        return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.func_77644_a(stack, target, attacker);
        if (attacker.field_70170_p.field_73012_v.nextInt(100) < 30 || attacker.func_110143_aJ() < attacker.func_110138_aP() * 0.3f) {
            target.func_70015_d(10);
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            if (entityIn.field_70173_aa % 2 == 0) {
                if (WarSwordItem.getRageCoolDown(stack) > 0) {
                    WarSwordItem.setRageCoolDown(stack, WarSwordItem.getRageCoolDown(stack) - 1);
                }
                if (WarSwordItem.getWarCryCoolDown(stack) > 0) {
                    WarSwordItem.setWarCryCoolDown(stack, WarSwordItem.getWarCryCoolDown(stack) - 1);
                }
            }
            if (entityIn instanceof LivingEntity && isSelected) {
                if (((LivingEntity)entityIn).func_110143_aJ() < ((LivingEntity)entityIn).func_110138_aP() * 0.3f) {
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76420_g, 1, 3));
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76429_m, 1, 3));
                }
                if (entityIn.func_223314_ad() > 0) {
                    entityIn.func_70066_B();
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"tooltip.vrm:war1", (Object[])new Object[0])).func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.LIGHT_PURPLE)));
        tooltip.add((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"tooltip.vrm:war2", (Object[])new Object[0]) + (WarSwordItem.getWarCryCoolDown(stack) > 0 ? " [" + WarSwordItem.getWarCryCoolDown(stack) / 20 + "s]" : "")).func_240703_c_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(WarSwordItem.getWarCryCoolDown(stack) > 0 ? TextFormatting.DARK_GRAY : TextFormatting.GRAY)));
        tooltip.add((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"tooltip.vrm:war3", (Object[])new Object[0]) + (WarSwordItem.getRageCoolDown(stack) > 0 ? " [" + WarSwordItem.getRageCoolDown(stack) / 20 + "s]" : "")).func_240703_c_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(WarSwordItem.getRageCoolDown(stack) > 0 ? TextFormatting.DARK_GRAY : TextFormatting.GRAY)));
        tooltip.add((ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"tooltip.vrm:war4", (Object[])new Object[0])).func_240703_c_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.GRAY)));
    }
}

