/*
 * Decompiled with CFR 0.152.
 */
package com.hoopawolf.dmm.network.packets.server;

import com.hoopawolf.dmm.network.packets.server.MessageToServer;
import com.hoopawolf.dmm.ref.Reference;
import net.minecraft.network.PacketBuffer;

public class SetPotionEffectMessage
extends MessageToServer {
    private int entity_ID;
    private int potion_type;
    private int duration;
    private int amplifier;

    public SetPotionEffectMessage(int entityID, int potionType, int durationIn, int amplifierIn) {
        this.messageIsValid = true;
        this.messageType = 0;
        this.entity_ID = entityID;
        this.potion_type = potionType;
        this.duration = durationIn;
        this.amplifier = amplifierIn;
    }

    public SetPotionEffectMessage() {
        this.messageIsValid = false;
    }

    public static SetPotionEffectMessage decode(PacketBuffer buf) {
        int _amplifier;
        int _duration;
        int potionType;
        int entityID;
        try {
            entityID = buf.readInt();
            potionType = buf.readInt();
            _duration = buf.readInt();
            _amplifier = buf.readInt();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Reference.LOGGER.warn("Exception while reading SetPotionEffectMessageToServer: " + e);
            return new SetPotionEffectMessage();
        }
        return new SetPotionEffectMessage(entityID, potionType, _duration, _amplifier);
    }

    public int getEntityID() {
        return this.entity_ID;
    }

    public int getPotionType() {
        return this.potion_type;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    @Override
    public void encode(PacketBuffer buf) {
        if (!this.messageIsValid) {
            return;
        }
        buf.writeInt(this.entity_ID);
        buf.writeInt(this.potion_type);
        buf.writeInt(this.duration);
        buf.writeInt(this.amplifier);
    }

    @Override
    public String toString() {
        return "SetPotionEffectMessage[targetID=" + this.entity_ID + "]";
    }
}

