/*
 * Decompiled with CFR 0.152.
 */
package com.hoopawolf.dmm.network.packets.server;

import com.hoopawolf.dmm.network.packets.server.MessageToServer;
import com.hoopawolf.dmm.ref.Reference;
import net.minecraft.network.PacketBuffer;

public class SetPotionEffectMultipleMessage
extends MessageToServer {
    private int entity_ID;
    private int duration;
    private int amplifier;
    private int start;
    private int end;

    public SetPotionEffectMultipleMessage(int entityID, int durationIn, int amplifierIn, int startIn, int endIn) {
        this.messageIsValid = true;
        this.messageType = 1;
        this.entity_ID = entityID;
        this.duration = durationIn;
        this.amplifier = amplifierIn;
        this.start = startIn;
        this.end = endIn;
    }

    public SetPotionEffectMultipleMessage() {
        this.messageIsValid = false;
    }

    public static SetPotionEffectMultipleMessage decode(PacketBuffer buf) {
        int _end;
        int _start;
        int _amplifier;
        int _duration;
        int entityID;
        try {
            entityID = buf.readInt();
            _duration = buf.readInt();
            _amplifier = buf.readInt();
            _start = buf.readInt();
            _end = buf.readInt();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Reference.LOGGER.warn("Exception while reading SetPotionEffectMessageToServer: " + e);
            return new SetPotionEffectMultipleMessage();
        }
        return new SetPotionEffectMultipleMessage(entityID, _duration, _amplifier, _start, _end);
    }

    public int getEntityID() {
        return this.entity_ID;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getStarting() {
        return this.start;
    }

    public int getEnding() {
        return this.end;
    }

    @Override
    public void encode(PacketBuffer buf) {
        if (!this.messageIsValid) {
            return;
        }
        buf.writeInt(this.entity_ID);
        buf.writeInt(this.duration);
        buf.writeInt(this.amplifier);
        buf.writeInt(this.start);
        buf.writeInt(this.end);
    }

    @Override
    public String toString() {
        return "SetPotionEffectMultipleMessage[targetID=" + this.entity_ID + "]";
    }
}

