/*
 * Decompiled with CFR 0.152.
 */
package com.hoopawolf.dmm.structure;

import com.hoopawolf.dmm.config.ConfigHandler;
import com.hoopawolf.dmm.ref.Reference;
import com.hoopawolf.dmm.structure.piece.SwordStructurePiece;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.Level;

public class SwordStructure
extends Structure<NoFeatureConfig> {
    public SwordStructure(Codec<NoFeatureConfig> p_i231997_1_) {
        super(p_i231997_1_);
    }

    public String func_143025_a() {
        return "vrm:swordstructure";
    }

    protected ChunkPos getStartPositionForPosition(ChunkGenerator chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxDistance = (Integer)ConfigHandler.COMMON.minStructureAway.get();
        int minDistance = (Integer)ConfigHandler.COMMON.maxStructureAway.get();
        int xTemp = x + maxDistance * spacingOffsetsX;
        int ztemp = z + maxDistance * spacingOffsetsZ;
        int xTemp2 = xTemp < 0 ? xTemp - maxDistance + 1 : xTemp;
        int zTemp2 = ztemp < 0 ? ztemp - maxDistance + 1 : ztemp;
        int validChunkX = xTemp2 / maxDistance;
        int validChunkZ = zTemp2 / maxDistance;
        ((SharedSeedRandom)random).func_202427_a(62353535L, validChunkX, validChunkZ, 62226333);
        validChunkX *= maxDistance;
        validChunkZ *= maxDistance;
        return new ChunkPos(validChunkX += random.nextInt(maxDistance + minDistance), validChunkZ += random.nextInt(maxDistance + minDistance));
    }

    protected boolean func_230363_a_(ChunkGenerator p_230363_1_, BiomeProvider p_230363_2_, long p_230363_3_, SharedSeedRandom p_230363_5_, int p_230363_6_, int p_230363_7_, Biome p_230363_8_, ChunkPos p_230363_9_, NoFeatureConfig p_230363_10_) {
        ChunkPos chunkpos = this.getStartPositionForPosition(p_230363_1_, (Random)p_230363_5_, p_230363_6_, p_230363_7_, 0, 0);
        if (p_230363_6_ == chunkpos.field_77276_a && p_230363_7_ == chunkpos.field_77275_b && p_230363_5_.nextInt(100) < (Integer)ConfigHandler.COMMON.structureSpawnChance.get()) {
            return p_230363_2_.func_205004_a((Structure)this);
        }
        return false;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_230364_a_(ChunkGenerator generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig p_230364_6_) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            int surfaceY = generator.func_222532_b(x, z, Heightmap.Type.WORLD_SURFACE_WG);
            BlockPos blockpos = new BlockPos(x, surfaceY, z);
            SwordStructurePiece.start(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
            Reference.LOGGER.log(Level.DEBUG, "Sword Structure at " + blockpos.func_177958_n() + " " + blockpos.func_177956_o() + " " + blockpos.func_177952_p());
        }
    }
}

