/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.config.WaystoneConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class WaystoneBlock
extends Block {
    public static final VoxelShape LOWER_SHAPE = VoxelShapes.func_216384_a((VoxelShape)WaystoneBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{WaystoneBlock.func_208617_a((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), WaystoneBlock.func_208617_a((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), WaystoneBlock.func_208617_a((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)}).func_197753_c();
    public static final VoxelShape UPPER_SHAPE = VoxelShapes.func_216384_a((VoxelShape)WaystoneBlock.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (VoxelShape[])new VoxelShape[]{WaystoneBlock.func_208617_a((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), WaystoneBlock.func_208617_a((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), WaystoneBlock.func_208617_a((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), WaystoneBlock.func_208617_a((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)}).func_197753_c();
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;

    public WaystoneBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(5.0f, 2000.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighbor, IWorld world, BlockPos pos, BlockPos offset) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        if ((facing.func_176740_k() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.UP) || neighbor.func_177230_c() == this && neighbor.func_177229_b(HALF) != half) && (half != DoubleBlockHalf.LOWER || facing != Direction.DOWN || state.func_196955_c((IWorldReader)world, pos))) {
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        BlockPos offset = half == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        BlockState other = world.func_180495_p(offset);
        if (other.func_177230_c() == this && other.func_177229_b(HALF) != half) {
            world.func_180501_a(offset, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, offset, Block.func_196246_j((BlockState)other));
            if (!world.field_72995_K && !player.func_184812_l_()) {
                WaystoneBlock.func_220054_a((BlockState)other, (World)world, (BlockPos)offset, null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE : LOWER_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
        builder.func_206894_a(new Property[]{HALF});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WaystoneTileEntity();
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        if (!PlayerWaystoneManager.mayBreakWaystone(player, world, pos)) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return true;
        }
        BlockState below = world.func_180495_p(pos.func_177977_b());
        return below.func_177230_c() == this && below.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!PlayerWaystoneManager.mayPlaceWaystone(context.func_195999_j())) {
            return null;
        }
        BlockPos pos = context.func_195995_a();
        if (pos.func_177956_o() < context.func_195991_k().func_217301_I() - 1 && context.func_195991_k().func_180495_p(pos.func_177984_a()).func_196953_a(context)) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
        }
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockPos posAbove = pos.func_177984_a();
        world.func_175656_a(posAbove, (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER));
        TileEntity waystoneTileEntity = world.func_175625_s(pos);
        if (waystoneTileEntity instanceof WaystoneTileEntity) {
            ((WaystoneTileEntity)waystoneTileEntity).initializeWaystone((IWorld)world, placer, false);
            TileEntity waystoneTileEntityAbove = world.func_175625_s(posAbove);
            if (waystoneTileEntityAbove instanceof WaystoneTileEntity) {
                ((WaystoneTileEntity)waystoneTileEntityAbove).initializeFromBase((WaystoneTileEntity)waystoneTileEntity);
            }
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        WaystoneTileEntity tileEntity = (WaystoneTileEntity)world.func_175625_s(pos);
        if (tileEntity != null) {
            IWaystone waystone = tileEntity.getWaystone();
            WaystoneManager.get().removeWaystone(waystone);
            PlayerWaystoneManager.removeKnownWaystone(waystone);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        WaystoneTileEntity tileEntity = (WaystoneTileEntity)world.func_175625_s(pos);
        if (tileEntity == null) {
            return ActionResultType.FAIL;
        }
        if (player.field_71075_bZ.field_75098_d) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.func_77973_b() == Items.field_222068_kQ) {
                if (!world.field_72995_K) {
                    tileEntity.uninitializeWaystone();
                    player.func_146105_b((ITextComponent)new StringTextComponent("Waystone was successfully reset - it will re-initialize once it is next loaded."), false);
                }
                return ActionResultType.SUCCESS;
            }
            if (heldItem.func_77973_b() == Items.field_151055_y) {
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new StringTextComponent("Waystone UUID: " + tileEntity.getWaystone().getWaystoneUid()), false);
                }
                return ActionResultType.SUCCESS;
            }
        }
        IWaystone waystone = tileEntity.getWaystone();
        if (player.func_225608_bj_()) {
            WaystoneEditPermissions result = PlayerWaystoneManager.mayEditWaystone(player, world, waystone);
            if (result != WaystoneEditPermissions.ALLOW) {
                if (result.getLangKey() != null) {
                    TranslationTextComponent chatComponent = new TranslationTextComponent(result.getLangKey());
                    chatComponent.func_240699_a_(TextFormatting.RED);
                    player.func_146105_b((ITextComponent)chatComponent, true);
                }
                return ActionResultType.SUCCESS;
            }
            if (!world.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity.getWaystoneSettingsContainerProvider(), (BlockPos)pos);
            }
            return ActionResultType.SUCCESS;
        }
        boolean isActivated = PlayerWaystoneManager.isWaystoneActivated(player, waystone);
        if (isActivated) {
            if (!world.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity.getWaystoneSelectionContainerProvider(), it -> {
                    it.writeByte(WarpMode.WAYSTONE_TO_WAYSTONE.ordinal());
                    it.func_179255_a(pos);
                });
            }
        } else {
            PlayerWaystoneManager.activateWaystone(player, waystone);
            if (!world.field_72995_K) {
                StringTextComponent nameComponent = new StringTextComponent(waystone.getName());
                nameComponent.func_240699_a_(TextFormatting.WHITE);
                TranslationTextComponent chatComponent = new TranslationTextComponent("chat.waystones.waystone_activated", new Object[]{nameComponent});
                chatComponent.func_240699_a_(TextFormatting.YELLOW);
                player.func_145747_a((ITextComponent)chatComponent, Util.field_240973_b_);
                WaystoneSyncManager.sendKnownWaystones(player);
            }
            this.notifyObserversOfActivation(world, pos);
            if (world.field_72995_K) {
                Waystones.proxy.playSound(SoundEvents.field_187802_ec, pos, 1.0f);
                for (int i = 0; i < 32; ++i) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)(pos.func_177956_o() + 3), (double)pos.func_177952_p() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, 0.0, -5.0, 0.0);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)(pos.func_177956_o() + 4), (double)pos.func_177952_p() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, 0.0, -5.0, 0.0);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void notifyObserversOfActivation(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.func_177972_a(direction);
                BlockState neighbourState = world.func_180495_p(offset);
                Block neighbourBlock = neighbourState.func_177230_c();
                if (!(neighbourBlock instanceof ObserverBlock) || neighbourState.func_177229_b((Property)ObserverBlock.field_176387_N) != direction.func_176734_d() || world.func_205220_G_().func_205359_a(offset, (Object)neighbourBlock)) continue;
                world.func_205220_G_().func_205360_a(offset, (Object)neighbourBlock, 2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (!((Boolean)WaystoneConfig.CLIENT.disableParticles.get()).booleanValue() && random.nextFloat() < 0.75f) {
            WaystoneTileEntity tileEntity = (WaystoneTileEntity)world.func_175625_s(pos);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (tileEntity != null && PlayerWaystoneManager.isWaystoneActivated((PlayerEntity)Objects.requireNonNull(player), tileEntity.getWaystone())) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n() + 0.5 + (random.nextDouble() - 0.5) * 1.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + (random.nextDouble() - 0.5) * 1.5, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5 + (random.nextDouble() - 0.5) * 1.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + (random.nextDouble() - 0.5) * 1.5, 0.0, 0.0, 0.0);
            }
        }
    }
}

