/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class WaystoneManager
extends WorldSavedData {
    private static final String DATA_NAME = "waystones";
    private static final String TAG_WAYSTONES = "Waystones";
    private static final WaystoneManager clientStorageCopy = new WaystoneManager();
    private final Map<UUID, IWaystone> waystones = new HashMap<UUID, IWaystone>();

    public WaystoneManager() {
        super(DATA_NAME);
    }

    public void addWaystone(IWaystone waystone) {
        this.waystones.put(waystone.getWaystoneUid(), waystone);
        this.func_76185_a();
    }

    public void updateWaystone(IWaystone waystone) {
        Waystone mutableWaystone = (Waystone)this.waystones.getOrDefault(waystone.getWaystoneUid(), waystone);
        mutableWaystone.setName(waystone.getName());
        mutableWaystone.setGlobal(waystone.isGlobal());
        this.waystones.put(waystone.getWaystoneUid(), mutableWaystone);
        this.func_76185_a();
    }

    public void removeWaystone(IWaystone waystone) {
        this.waystones.remove(waystone.getWaystoneUid());
        this.func_76185_a();
    }

    public Optional<IWaystone> getWaystoneAt(IBlockReader world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof WaystoneTileEntity) {
            return Optional.of(((WaystoneTileEntity)tileEntity).getWaystone());
        }
        return Optional.empty();
    }

    public Optional<IWaystone> getWaystoneById(UUID waystoneUid) {
        return Optional.ofNullable(this.waystones.get(waystoneUid));
    }

    public Optional<IWaystone> findWaystoneByName(String name) {
        return this.waystones.values().stream().filter(it -> it.getName().equals(name)).findFirst();
    }

    public List<IWaystone> getGlobalWaystones() {
        return this.waystones.values().stream().filter(IWaystone::isGlobal).collect(Collectors.toList());
    }

    public void func_76184_a(CompoundNBT tagCompound) {
        ListNBT tagList = tagCompound.func_150295_c(TAG_WAYSTONES, 10);
        for (INBT tag : tagList) {
            CompoundNBT compound = (CompoundNBT)tag;
            UUID waystoneUid = NBTUtil.func_186860_b((INBT)Objects.requireNonNull(compound.func_74781_a("WaystoneUid")));
            String name = compound.func_74779_i("Name");
            RegistryKey dimensionType = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("World")));
            BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("BlockPos"));
            boolean wasGenerated = compound.func_74767_n("WasGenerated");
            UUID ownerUid = compound.func_74764_b("OwnerUid") ? NBTUtil.func_186860_b((INBT)Objects.requireNonNull(compound.func_74781_a("OwnerUid"))) : null;
            Waystone waystone = new Waystone(waystoneUid, (RegistryKey<World>)dimensionType, pos, wasGenerated, ownerUid);
            waystone.setName(name);
            waystone.setGlobal(compound.func_74767_n("IsGlobal"));
            this.waystones.put(waystoneUid, waystone);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tagCompound) {
        ListNBT tagList = new ListNBT();
        for (IWaystone waystone : this.waystones.values()) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("WaystoneUid", (INBT)NBTUtil.func_240626_a_((UUID)waystone.getWaystoneUid()));
            compound.func_74778_a("Name", waystone.getName());
            compound.func_74778_a("World", waystone.getDimension().func_240901_a_().toString());
            compound.func_218657_a("BlockPos", (INBT)NBTUtil.func_186859_a((BlockPos)waystone.getPos()));
            compound.func_74757_a("WasGenerated", waystone.wasGenerated());
            if (waystone.getOwnerUid() != null) {
                compound.func_218657_a("OwnerUid", (INBT)NBTUtil.func_240626_a_((UUID)waystone.getOwnerUid()));
            }
            compound.func_74757_a("IsGlobal", waystone.isGlobal());
            tagList.add((Object)compound);
        }
        tagCompound.func_218657_a(TAG_WAYSTONES, (INBT)tagList);
        return tagCompound;
    }

    public static WaystoneManager get() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            ServerWorld overworld = server.func_71218_a(World.field_234918_g_);
            DimensionSavedDataManager storage = overworld.func_217481_x();
            return (WaystoneManager)storage.func_215752_a(WaystoneManager::new, DATA_NAME);
        }
        return clientStorageCopy;
    }
}

