/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.UUID;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WaystoneProxy
implements IWaystone {
    private final UUID waystoneUid;
    private IWaystone backingWaystone;

    public WaystoneProxy(UUID waystoneUid) {
        this.waystoneUid = waystoneUid;
    }

    @Override
    public boolean isValid() {
        return WaystoneManager.get().getWaystoneById(this.waystoneUid).isPresent();
    }

    public IWaystone getBackingWaystone() {
        if (this.backingWaystone == null) {
            this.backingWaystone = WaystoneManager.get().getWaystoneById(this.waystoneUid).orElse(InvalidWaystone.INSTANCE);
        }
        return this.backingWaystone;
    }

    @Override
    public UUID getOwnerUid() {
        return this.getBackingWaystone().getOwnerUid();
    }

    @Override
    public UUID getWaystoneUid() {
        return this.waystoneUid;
    }

    @Override
    public String getName() {
        return this.getBackingWaystone().getName();
    }

    @Override
    public RegistryKey<World> getDimension() {
        return this.getBackingWaystone().getDimension();
    }

    @Override
    public boolean wasGenerated() {
        return this.getBackingWaystone().wasGenerated();
    }

    @Override
    public boolean isGlobal() {
        return this.getBackingWaystone().isGlobal();
    }

    @Override
    public boolean isOwner(PlayerEntity player) {
        return this.getBackingWaystone().isOwner(player);
    }

    @Override
    public BlockPos getPos() {
        return this.getBackingWaystone().getPos();
    }
}

