/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.config.WaystoneConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.item.IFOVOnUse;
import net.blay09.mods.waystones.item.IResetUseOnDamage;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoundScrollItem
extends Item
implements IResetUseOnDamage,
IFOVOnUse {
    public static final String name = "bound_scroll";
    public static final ResourceLocation registryName = new ResourceLocation("waystones", "bound_scroll");

    public BoundScrollItem() {
        super(new Item.Properties().func_200916_a(Waystones.itemGroup));
    }

    public int func_77626_a(ItemStack itemStack) {
        return (Integer)WaystoneConfig.SERVER.scrollUseTime.get();
    }

    public UseAction func_77661_b(ItemStack itemStack) {
        if (Waystones.proxy.isVivecraftInstalled()) {
            return UseAction.NONE;
        }
        return UseAction.BOW;
    }

    private void setBoundTo(ItemStack itemStack, @Nullable IWaystone entry) {
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
            itemStack.func_77982_d(tagCompound);
        }
        if (entry != null) {
            tagCompound.func_218657_a("WaystonesBoundTo", (INBT)NBTUtil.func_240626_a_((UUID)entry.getWaystoneUid()));
        } else {
            tagCompound.func_82580_o("WaystonesBoundTo");
        }
    }

    @Nullable
    protected IWaystone getBoundTo(PlayerEntity player, ItemStack itemStack) {
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("WaystonesBoundTo", 11)) {
            return new WaystoneProxy(NBTUtil.func_186860_b((INBT)Objects.requireNonNull(tagCompound.func_74781_a("WaystonesBoundTo"))));
        }
        return null;
    }

    protected WarpMode getWarpMode() {
        return WarpMode.BOUND_SCROLL;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        ItemStack heldItem = player.func_184586_b(context.func_221531_n());
        World world = context.func_195991_k();
        TileEntity tileEntity = world.func_175625_s(context.func_195995_a());
        if (tileEntity instanceof WaystoneTileEntity) {
            IWaystone waystone = ((WaystoneTileEntity)tileEntity).getWaystone();
            if (!PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
                PlayerWaystoneManager.activateWaystone(player, waystone);
            }
            if (!world.field_72995_K) {
                ItemStack boundItem = heldItem.func_190916_E() == 1 ? heldItem : heldItem.func_77979_a(1);
                this.setBoundTo(boundItem, waystone);
                if (boundItem != heldItem && !player.func_191521_c(boundItem)) {
                    player.func_71019_a(boundItem, false);
                }
                TranslationTextComponent chatComponent = new TranslationTextComponent("chat.waystones.scroll_bound", new Object[]{waystone.getName()});
                chatComponent.func_240699_a_(TextFormatting.YELLOW);
                player.func_146105_b((ITextComponent)chatComponent, true);
            }
            Waystones.proxy.playSound(SoundEvents.field_187802_ec, context.func_195995_a(), 2.0f);
            return !world.field_72995_K ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, LivingEntity entity) {
        PlayerEntity player;
        IWaystone boundTo;
        if (!world.field_72995_K && entity instanceof ServerPlayerEntity && (boundTo = this.getBoundTo(player = (PlayerEntity)entity, itemStack)) != null) {
            double distance = entity.func_70092_e((double)boundTo.getPos().func_177958_n(), (double)boundTo.getPos().func_177956_o(), (double)boundTo.getPos().func_177952_p());
            if (distance <= 3.0) {
                return itemStack;
            }
            PlayerWaystoneManager.tryTeleportToWaystone((ServerPlayerEntity)player, boundTo, this.getWarpMode(), null);
        }
        return itemStack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        IWaystone boundTo = this.getBoundTo(player, itemStack);
        if (boundTo != null) {
            if (!player.func_184587_cr() && world.field_72995_K) {
                Waystones.proxy.playSound(SoundEvents.field_187814_ei, new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()), 2.0f);
            }
            if (Waystones.proxy.isVivecraftInstalled()) {
                this.func_77654_b(itemStack, world, (LivingEntity)player);
            } else {
                player.func_184598_c(hand);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
        }
        TranslationTextComponent chatComponent = new TranslationTextComponent("chat.waystones.scroll_not_yet_bound");
        chatComponent.func_240699_a_(TextFormatting.RED);
        player.func_146105_b((ITextComponent)chatComponent, true);
        return new ActionResult(ActionResultType.FAIL, (Object)itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        StringTextComponent targetText;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        IWaystone boundTo = this.getBoundTo((PlayerEntity)player, itemStack);
        Object object = targetText = boundTo != null ? new StringTextComponent(boundTo.getName()) : new TranslationTextComponent("tooltip.waystones.bound_to_none");
        if (boundTo != null) {
            targetText.func_240699_a_(TextFormatting.AQUA);
        }
        TranslationTextComponent boundToText = new TranslationTextComponent("tooltip.waystones.bound_to", new Object[]{targetText});
        boundToText.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)boundToText);
    }
}

